/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.rtsp.RtspSender;
import com.pedro.rtsp.rtsp.commands.CommandsManager;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.ExtensionsKt;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00104\u001a\u000205J\u001c\u00106\u001a\u0002052\b\u00101\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00107\u001a\u00020\fH\u0007J\u0006\u00108\u001a\u000205J\u0019\u00108\u001a\u0002052\u0006\u00109\u001a\u00020\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0006\u0010;\u001a\u00020\bJ\u0011\u0010<\u001a\u000205H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010=J\u0012\u0010>\u001a\u00020\f2\b\b\u0002\u0010?\u001a\u00020@H\u0007J\b\u0010A\u001a\u00020\fH\u0002J\u001c\u0010B\u001a\u0002052\u0006\u0010C\u001a\u00020\u00132\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010E\u001a\u000205J\u0006\u0010F\u001a\u000205J\u0006\u0010G\u001a\u000205J\u0006\u0010H\u001a\u000205J\u000e\u0010I\u001a\u0002052\u0006\u0010J\u001a\u00020\bJ\u0016\u0010K\u001a\u0002052\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0016\u0010P\u001a\u0002052\u0006\u0010Q\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0016\u0010R\u001a\u0002052\u0006\u0010S\u001a\u00020\b2\u0006\u0010T\u001a\u00020\fJ\u001a\u0010U\u001a\u0002052\b\u0010V\u001a\u0004\u0018\u00010\u00062\b\u0010W\u001a\u0004\u0018\u00010\u0006J\u000e\u0010X\u001a\u0002052\u0006\u0010Y\u001a\u00020\fJ\u000e\u0010Z\u001a\u0002052\u0006\u0010[\u001a\u00020\fJ\u000e\u0010\\\u001a\u0002052\u0006\u0010]\u001a\u00020\fJ\u000e\u0010^\u001a\u0002052\u0006\u0010_\u001a\u00020\fJ\u000e\u0010`\u001a\u0002052\u0006\u0010a\u001a\u00020bJ\u000e\u0010c\u001a\u0002052\u0006\u0010!\u001a\u00020\bJ \u0010d\u001a\u0002052\u0006\u0010e\u001a\u00020M2\u0006\u0010f\u001a\u00020M2\b\u0010g\u001a\u0004\u0018\u00010MJ\u000e\u0010h\u001a\u00020\f2\u0006\u0010i\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0015R\u0011\u0010.\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0015R\u000e\u00100\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006j"}, d2={"Lcom/pedro/rtsp/rtsp/RtspClient;", "", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "checkServerAlive", "", "commandsManager", "Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "connectionSocket", "Ljava/net/Socket;", "doingRetry", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "<set-?>", "isStreaming", "()Z", "job", "Lkotlinx/coroutines/Job;", "jobRetry", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "numRetry", "reTries", "reader", "Ljava/io/BufferedReader;", "rtspSender", "Lcom/pedro/rtsp/rtsp/RtspSender;", "rtspUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "scope", "Lkotlinx/coroutines/CoroutineScope;", "scopeRetry", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "tlsEnabled", "url", "writer", "Ljava/io/BufferedWriter;", "clearCache", "", "connect", "isRetry", "disconnect", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getItemsInCache", "handleServerCommands", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasCongestion", "percentUsed", "", "isAlive", "reConnect", "delay", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setAuthorization", "user", "password", "setCheckServerAlive", "enabled", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setProtocol", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "setReTries", "setVideoInfo", "sps", "pps", "vps", "shouldRetry", "reason", "rtsp_release"})
@SourceDebugExtension(value={"SMAP\nRtspClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtspClient.kt\ncom/pedro/rtsp/rtsp/RtspClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,473:1\n1#2:474\n*E\n"})
public final class RtspClient {
    @NotNull
    private final ConnectCheckerRtsp connectCheckerRtsp;
    @NotNull
    private final String TAG;
    private final Pattern rtspUrlPattern;
    @Nullable
    private Socket connectionSocket;
    @Nullable
    private BufferedReader reader;
    @Nullable
    private BufferedWriter writer;
    @NotNull
    private CoroutineScope scope;
    @NotNull
    private CoroutineScope scopeRetry;
    @Nullable
    private Job job;
    @Nullable
    private Job jobRetry;
    @NotNull
    private Mutex mutex;
    private volatile boolean isStreaming;
    private boolean tlsEnabled;
    @NotNull
    private final RtspSender rtspSender;
    @Nullable
    private String url;
    @NotNull
    private final CommandsManager commandsManager;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;
    private boolean checkServerAlive;

    public RtspClient(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.TAG = "RtspClient";
        this.rtspUrlPattern = Pattern.compile("^rtsps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.scopeRetry = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.mutex = MutexKt.Mutex((boolean)true);
        this.rtspSender = new RtspSender(this.connectCheckerRtsp);
        this.commandsManager = new CommandsManager();
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.rtspSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.rtspSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.rtspSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.rtspSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.rtspSender.getSentVideoFrames();
    }

    public final void setCheckServerAlive(boolean enabled) {
        this.checkServerAlive = enabled;
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        if (onlyAudio) {
            RtpConstants.INSTANCE.setTrackAudio(0);
            RtpConstants.INSTANCE.setTrackVideo(1);
        } else {
            RtpConstants.INSTANCE.setTrackVideo(0);
            RtpConstants.INSTANCE.setTrackAudio(1);
        }
        this.commandsManager.setAudioDisabled(false);
        this.commandsManager.setVideoDisabled(onlyAudio);
    }

    public final void setOnlyVideo(boolean onlyVideo) {
        RtpConstants.INSTANCE.setTrackVideo(0);
        RtpConstants.INSTANCE.setTrackAudio(1);
        this.commandsManager.setVideoDisabled(false);
        this.commandsManager.setAudioDisabled(onlyVideo);
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.commandsManager.setProtocol(protocol);
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        this.commandsManager.setAuth(user, password);
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.commandsManager.setVideoInfo(sps, pps, vps);
        if (this.mutex.isLocked()) {
            RtspClient rtspClient = this;
            try {
                RtspClient $this$setVideoInfo_u24lambda_u240 = rtspClient;
                boolean bl = false;
                Mutex.DefaultImpls.unlock$default((Mutex)$this$setVideoInfo_u24lambda_u240.mutex, null, (int)1, null);
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.commandsManager.setAudioInfo(sampleRate, isStereo);
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        if (!isRetry) {
            this.doingRetry = true;
        }
        if (!this.isStreaming || isRetry) {
            this.isStreaming = true;
            this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(url, this, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ String $url;
                final /* synthetic */ RtspClient this$0;
                {
                    this.$url = $url;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:61)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public static /* synthetic */ void connect$default(RtspClient rtspClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rtspClient.connect(string, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object handleServerCommands(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof handleServerCommands.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RtspClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RtspClient.access$handleServerCommands(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ** break;
            }
            case 1: {
                $i$a$-runCatching-RtspClient$handleServerCommands$error$1 = false;
                $this$handleServerCommands_u24lambda_u242 = (RtspClient)$continuation.L$1;
                this = (RtspClient)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    while (true) {
                        if ($this$handleServerCommands_u24lambda_u242.reader != null) {
                            $i$a$-let-RtspClient$handleServerCommands$error$1$1 = false;
                            if (r.ready()) {
                                CommandsManager.getResponse$default($this$handleServerCommands_u24lambda_u242.commandsManager, r, null, 2, null);
                            }
                            v1 = Unit.INSTANCE;
                        } else {
                            v1 = null;
                        }
                        ** GOTO lbl67
                        break;
                    }
                }
                catch (Throwable var5_9) {
                    var4_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_9));
lbl35:
                    // 2 sources

                    ** while ((error = Result.exceptionOrNull-impl((Object)var4_7)) == null || error instanceof SocketTimeoutException)
                }
            }
lbl-1000:
            // 3 sources

            {
                while (CoroutineScopeKt.isActive((CoroutineScope)this.scope) && this.isStreaming) {
                    var3_6 = this;
                    {
                        $this$handleServerCommands_u24lambda_u242 = var3_6;
                        $i$a$-runCatching-RtspClient$handleServerCommands$error$1 = false;
                        if (!$this$handleServerCommands_u24lambda_u242.isAlive()) ** GOTO lbl48
                        $continuation.L$0 = this;
                        $continuation.L$1 = $this$handleServerCommands_u24lambda_u242;
                        $continuation.label = 1;
                        if ((v0 = DelayKt.delay((long)2000L, (Continuation)$continuation)) != var10_4) ** continue;
                    }
                    return var10_4;
lbl48:
                    // 1 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$handleServerCommands_u24lambda_u242;
                    $continuation.label = 2;
                    v2 = ExtensionsKt.onMainThread((Function0<Unit>)((Function0)new Function0<Unit>($this$handleServerCommands_u24lambda_u242){
                        final /* synthetic */ RtspClient $this_runCatching;
                        {
                            this.$this_runCatching = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            RtspClient.access$getConnectCheckerRtsp$p(this.$this_runCatching).onConnectionFailedRtsp("No response from server");
                        }
                    }), (Continuation<? super Unit>)$continuation);
                    if (v2 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl64
                }
                return Unit.INSTANCE;
lbl56:
                // 1 sources

                ** GOTO lbl69
            }
            case 2: {
                $i$a$-runCatching-RtspClient$handleServerCommands$error$1 = false;
                $this$handleServerCommands_u24lambda_u242 = (RtspClient)$continuation.L$1;
                this = (RtspClient)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl64:
                    // 2 sources

                    CoroutineScopeKt.cancel$default((CoroutineScope)$this$handleServerCommands_u24lambda_u242.scope, null, (int)1, null);
                    v1 = Unit.INSTANCE;
lbl67:
                    // 3 sources

                    var4_7 = Result.constructor-impl((Object)v1);
                }
                ** GOTO lbl35
lbl69:
                // 1 sources

                CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
                ** break;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isAlive() {
        boolean connected;
        Socket socket = this.connectionSocket;
        boolean bl = connected = socket != null ? socket.isConnected() : false;
        if (!this.checkServerAlive) {
            return connected;
        }
        Object object = this.connectionSocket;
        boolean reachable = object != null && (object = ((Socket)object).getInetAddress()) != null ? ((InetAddress)object).isReachable(5000) : false;
        return connected && !reachable ? false : connected;
    }

    public final void disconnect() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RtspClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = RtspClient.access$disconnect(this.this$0, true, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object disconnect(boolean var1_1, Continuation<? super Unit> var2_2) {
        block24: {
            block23: {
                block22: {
                    if (!(var2_2 instanceof disconnect.2)) ** GOTO lbl-1000
                    var8_3 = var2_2;
                    if ((var8_3.label & -2147483648) != 0) {
                        var8_3.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var2_2){
                            Object L$0;
                            boolean Z$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ RtspClient this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return RtspClient.access$disconnect(this.this$0, false, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.isStreaming) {
                                $continuation.L$0 = this;
                                $continuation.Z$0 = clear;
                                $continuation.label = 1;
                                v0 = this.rtspSender.stop((Continuation<? super Unit>)$continuation);
                                if (v0 == var9_5) {
                                    return var9_5;
                                }
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            clear = $continuation.Z$0;
                            this = (RtspClient)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var4_6 = this;
                            try {
                                $this$disconnect_u24lambda_u243 = var4_6;
                                $i$a$-runCatching-RtspClient$disconnect$error$1 = false;
                                v1 = $this$disconnect_u24lambda_u243.writer;
                                if (v1 != null) {
                                    v1.write($this$disconnect_u24lambda_u243.commandsManager.createTeardown());
                                }
                                v2 = $this$disconnect_u24lambda_u243.writer;
                                if (v2 != null) {
                                    v2.flush();
                                }
                                v3 = $this$disconnect_u24lambda_u243.connectionSocket;
                                if (v3 != null) {
                                    v3.close();
                                }
                                v4 = $this$disconnect_u24lambda_u243.reader;
                                if (v4 != null) {
                                    v4.close();
                                }
                                $this$disconnect_u24lambda_u243.reader = null;
                                v5 = $this$disconnect_u24lambda_u243.writer;
                                if (v5 != null) {
                                    v5.close();
                                }
                                $this$disconnect_u24lambda_u243.writer = null;
                                $this$disconnect_u24lambda_u243.connectionSocket = null;
                                var5_7 = Result.constructor-impl((Object)Boxing.boxInt((int)Log.i((String)$this$disconnect_u24lambda_u243.TAG, (String)"write teardown success")));
                            }
                            catch (Throwable var6_9) {
                                var5_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var6_9));
                            }
                            error = Result.exceptionOrNull-impl((Object)var5_7);
                            if (error != null) {
                                Log.e((String)this.TAG, (String)"disconnect error", (Throwable)error);
                            }
                            if (!clear) break block22;
                            this.commandsManager.clear();
                            this.reTries = this.numRetry;
                            this.doingRetry = false;
                            this.isStreaming = false;
                            $continuation.L$0 = this;
                            $continuation.label = 2;
                            v6 = ExtensionsKt.onMainThread((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                final /* synthetic */ RtspClient this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onDisconnectRtsp();
                                }
                            }), (Continuation<? super Unit>)$continuation);
                            if (v6 == var9_5) {
                                return var9_5;
                            }
                            ** GOTO lbl73
                        }
                        case 2: {
                            this = (RtspClient)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl73:
                            // 2 sources

                            this.mutex = MutexKt.Mutex((boolean)true);
                            v7 = this.jobRetry;
                            if (v7 == null) break;
                            $continuation.L$0 = this;
                            $continuation.label = 3;
                            v8 = JobKt.cancelAndJoin((Job)v7, (Continuation)$continuation);
                            if (v8 == var9_5) {
                                return var9_5;
                            }
                            break;
                        }
                        case 3: {
                            this = (RtspClient)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v8 = $result;
                            break;
                        }
                    }
                    this.jobRetry = null;
                    CoroutineScopeKt.cancel$default((CoroutineScope)this.scopeRetry, null, (int)1, null);
                    this.scopeRetry = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
                    break block23;
                }
                this.commandsManager.retryClear();
            }
            v9 = this.job;
            if (v9 == null) break block24;
            $continuation.L$0 = this;
            $continuation.label = 4;
            v10 = JobKt.cancelAndJoin((Job)v9, (Continuation)$continuation);
            if (v10 == var9_5) {
                return var9_5;
            }
            break block24;
            {
                case 4: {
                    this = (RtspClient)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v10 = $result;
                    break;
                }
            }
        }
        this.job = null;
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getVideoDisabled()) {
            this.rtspSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getAudioDisabled()) {
            this.rtspSender.sendAudioFrame(aacBuffer, info);
        }
    }

    @JvmOverloads
    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        return this.rtspSender.hasCongestion(percentUsed);
    }

    public static /* synthetic */ boolean hasCongestion$default(RtspClient rtspClient, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return rtspClient.hasCongestion(f);
    }

    @JvmOverloads
    public final void reConnect(long delay, @Nullable String backupUrl) {
        this.jobRetry = BuildersKt.launch$default((CoroutineScope)this.scopeRetry, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, delay, backupUrl, null){
            int label;
            final /* synthetic */ RtspClient this$0;
            final /* synthetic */ long $delay;
            final /* synthetic */ String $backupUrl;
            {
                this.this$0 = $receiver;
                this.$delay = $delay;
                this.$backupUrl = $backupUrl;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.this$0;
                        var3_4 = RtspClient.access$getReTries$p(var2_3);
                        RtspClient.access$setReTries$p(var2_3, var3_4 + -1);
                        this.label = 1;
                        v0 = RtspClient.access$disconnect(this.this$0, false, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.label = 2;
                        v1 = DelayKt.delay((long)this.$delay, (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        if ((v2 = this.$backupUrl) == null) {
                            v2 = RtspClient.access$getUrl$p(this.this$0);
                        }
                        reconnectUrl = v2;
                        this.this$0.connect(reconnectUrl, true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void reConnect$default(RtspClient rtspClient, long l, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        rtspClient.reConnect(l, string);
    }

    public final void resetSentAudioFrames() {
        this.rtspSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.rtspSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.rtspSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.rtspSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.rtspSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.rtspSender.setLogs(enable);
    }

    public final void clearCache() {
        this.rtspSender.clearCache();
    }

    public final int getItemsInCache() {
        return this.rtspSender.getItemsInCache();
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        RtspClient.connect$default(this, url, false, 2, null);
    }

    @JvmOverloads
    public final boolean hasCongestion() throws IllegalArgumentException {
        return RtspClient.hasCongestion$default(this, 0.0f, 1, null);
    }

    @JvmOverloads
    public final void reConnect(long delay) {
        RtspClient.reConnect$default(this, delay, null, 2, null);
    }

    public static final /* synthetic */ void access$setStreaming$p(RtspClient $this, boolean bl) {
        $this.isStreaming = bl;
    }

    public static final /* synthetic */ ConnectCheckerRtsp access$getConnectCheckerRtsp$p(RtspClient $this) {
        return $this.connectCheckerRtsp;
    }

    public static final /* synthetic */ void access$setUrl$p(RtspClient $this, String string) {
        $this.url = string;
    }

    public static final /* synthetic */ Pattern access$getRtspUrlPattern$p(RtspClient $this) {
        return $this.rtspUrlPattern;
    }

    public static final /* synthetic */ void access$setTlsEnabled$p(RtspClient $this, boolean bl) {
        $this.tlsEnabled = bl;
    }

    public static final /* synthetic */ boolean access$getTlsEnabled$p(RtspClient $this) {
        return $this.tlsEnabled;
    }

    public static final /* synthetic */ String access$getTAG$p(RtspClient $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ RtspSender access$getRtspSender$p(RtspClient $this) {
        return $this.rtspSender;
    }

    public static final /* synthetic */ CommandsManager access$getCommandsManager$p(RtspClient $this) {
        return $this.commandsManager;
    }

    public static final /* synthetic */ Mutex access$getMutex$p(RtspClient $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ void access$setConnectionSocket$p(RtspClient $this, Socket socket) {
        $this.connectionSocket = socket;
    }

    public static final /* synthetic */ Socket access$getConnectionSocket$p(RtspClient $this) {
        return $this.connectionSocket;
    }

    public static final /* synthetic */ void access$setReader$p(RtspClient $this, BufferedReader bufferedReader) {
        $this.reader = bufferedReader;
    }

    public static final /* synthetic */ void access$setWriter$p(RtspClient $this, BufferedWriter bufferedWriter) {
        $this.writer = bufferedWriter;
    }

    public static final /* synthetic */ void access$setReTries$p(RtspClient $this, int n) {
        $this.reTries = n;
    }

    public static final /* synthetic */ int access$getNumRetry$p(RtspClient $this) {
        return $this.numRetry;
    }

    public static final /* synthetic */ Object access$handleServerCommands(RtspClient $this, Continuation $completion) {
        return $this.handleServerCommands((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$disconnect(RtspClient $this, boolean clear, Continuation $completion) {
        return $this.disconnect(clear, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ int access$getReTries$p(RtspClient $this) {
        return $this.reTries;
    }

    public static final /* synthetic */ String access$getUrl$p(RtspClient $this) {
        return $this.url;
    }
}

