/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

public abstract class BaseSenderReport {
    protected final String TAG = "SenderReport";
    protected static final int MTU = 1500;
    protected static final int PACKET_LENGTH = 28;
    protected byte[] mBuffer = new byte[1500];
    protected int mOctetCount = 0;
    protected int mPacketCount = 0;
    protected long interval;
    protected long delta;
    protected long now;
    protected long old;

    public BaseSenderReport() {
        this.mBuffer[0] = (byte)Integer.parseInt("10000000", 2);
        this.mBuffer[1] = -56;
        this.setLong(6L, 2, 4);
        this.delta = this.interval = 3000L;
    }

    public void setSSRC(int ssrc) {
        this.setLong(ssrc, 4, 8);
        this.mPacketCount = 0;
        this.mOctetCount = 0;
        this.setLong(this.mPacketCount, 20, 24);
        this.setLong(this.mOctetCount, 24, 28);
    }

    protected boolean updateSend(int length) {
        ++this.mPacketCount;
        this.mOctetCount += length;
        this.setLong(this.mPacketCount, 20, 24);
        this.setLong(this.mOctetCount, 24, 28);
        this.now = System.currentTimeMillis();
        this.delta += this.old != 0L ? this.now - this.old : 0L;
        this.old = this.now;
        if (this.interval > 0L && this.delta >= this.interval) {
            this.delta = 0L;
            return true;
        }
        return false;
    }

    public void reset() {
        this.mPacketCount = 0;
        this.mOctetCount = 0;
        this.setLong(this.mPacketCount, 20, 24);
        this.setLong(this.mOctetCount, 24, 28);
        this.old = 0L;
        this.now = 0L;
        this.delta = 0L;
    }

    protected void setLong(long n, int begin, int end) {
        --end;
        while (end >= begin) {
            this.mBuffer[end] = (byte)(n % 256L);
            n >>= 8;
            --end;
        }
    }

    protected void setData(long ntpts, long rtpts) {
        long hb = ntpts / 1000000000L;
        long lb = (ntpts - hb * 1000000000L) * 0x100000000L / 1000000000L;
        this.setLong(hb, 8, 12);
        this.setLong(lb, 12, 16);
        this.setLong(rtpts, 16, 20);
    }
}

