/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportUdp;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class RtpSocketUdp
extends BaseRtpSocket
implements Runnable {
    private SenderReportUdp senderReportUdp;
    private MulticastSocket mSocket;
    private DatagramPacket[] mPackets;
    private int mPort = -1;
    private ConnectCheckerRtsp connectCheckerRtsp;

    public RtpSocketUdp(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.senderReportUdp = new SenderReportUdp(connectCheckerRtsp);
        this.senderReportUdp.reset();
        this.mPackets = new DatagramPacket[this.mBufferCount];
        for (int i = 0; i < this.mBufferCount; ++i) {
            this.mPackets[i] = new DatagramPacket(this.mBuffers[i], 1);
        }
        try {
            this.mSocket = new MulticastSocket();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.mSocket.close();
        this.senderReportUdp.close();
    }

    @Override
    public void setSSRC(int ssrc) {
        for (int i = 0; i < this.mBufferCount; ++i) {
            this.setLong(this.mBuffers[i], ssrc, 8, 12);
        }
        this.senderReportUdp.setSSRC(ssrc);
    }

    public void setTimeToLive(int ttl) throws IOException {
        this.mSocket.setTimeToLive(ttl);
    }

    public void setDestination(String dest, int dport, int rtcpPort) {
        try {
            if (dport != 0 && rtcpPort != 0) {
                this.mPort = dport;
                for (int i = 0; i < this.mBufferCount; ++i) {
                    this.mPackets[i].setPort(dport);
                    this.mPackets[i].setAddress(InetAddress.getByName(dest));
                }
                this.senderReportUdp.setDestination(InetAddress.getByName(dest), rtcpPort);
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void commitBuffer(int length) throws IOException {
        this.updateSequence();
        this.mPackets[this.mBufferIn].setLength(length);
        if (++this.mBufferIn >= this.mBufferCount) {
            this.mBufferIn = 0;
        }
        this.mBufferCommitted.release();
        if (this.mThread == null) {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (this.mBufferCommitted.tryAcquire(4L, TimeUnit.SECONDS)) {
                this.senderReportUdp.update(this.mPackets[this.mBufferOut].getLength(), this.mTimestamps[this.mBufferOut], this.mPort);
                this.mSocket.send(this.mPackets[this.mBufferOut]);
                Log.i((String)"RtpSocket", (String)("send packet, " + this.mPackets[this.mBufferOut].getLength() + " Size, " + this.mPackets[this.mBufferOut].getPort() + " Port"));
                if (++this.mBufferOut >= this.mBufferCount) {
                    this.mBufferOut = 0;
                }
                this.mBufferRequested.release();
            }
        }
        catch (IOException | InterruptedException e) {
            Log.e((String)"RtpSocket", (String)"UDP send error: ", (Throwable)e);
            this.connectCheckerRtsp.onConnectionFailedRtsp();
        }
        this.mThread = null;
        this.resetFifo();
        this.senderReportUdp.reset();
    }
}

