/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class SenderReportUdp
extends BaseSenderReport {
    private MulticastSocket socket;
    private DatagramPacket datagramPacket;
    private ConnectCheckerRtsp connectCheckerRtsp;

    public SenderReportUdp(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        try {
            this.socket = new MulticastSocket();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.datagramPacket = new DatagramPacket(this.mBuffer, 1);
    }

    public void close() {
        this.socket.close();
    }

    public void update(int length, long rtpts, int port) {
        if (this.updateSend(length)) {
            this.send(System.nanoTime(), rtpts, port);
        }
    }

    public void setDestination(InetAddress dest, int dport) {
        this.datagramPacket.setPort(dport);
        this.datagramPacket.setAddress(dest);
    }

    private void send(final long ntpts, final long rtpts, final int port) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                long hb = ntpts / 1000000000L;
                long lb = (ntpts - hb * 1000000000L) * 0x100000000L / 1000000000L;
                SenderReportUdp.this.setLong(hb, 8, 12);
                SenderReportUdp.this.setLong(lb, 12, 16);
                SenderReportUdp.this.setLong(rtpts, 16, 20);
                SenderReportUdp.this.datagramPacket.setLength(28);
                SenderReportUdp.this.datagramPacket.setPort(port);
                try {
                    SenderReportUdp.this.socket.send(SenderReportUdp.this.datagramPacket);
                    Log.i((String)"SenderReport", (String)("send report, " + SenderReportUdp.this.datagramPacket.getPort() + " Port"));
                }
                catch (IOException e) {
                    Log.e((String)"SenderReport", (String)"send UDP report error", (Throwable)e);
                    SenderReportUdp.this.connectCheckerRtsp.onConnectionFailedRtsp();
                }
            }
        }).start();
    }
}

