/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.io.OutputStream;

public class SenderReportTcp
extends BaseSenderReport {
    private final byte[] mTcpHeader;
    private OutputStream mOutputStream = null;
    private ConnectCheckerRtsp connectCheckerRtsp;

    public SenderReportTcp(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.mTcpHeader = new byte[]{36, 0, 0, 28};
    }

    public void update(int length, long rtpts) {
        if (this.updateSend(length)) {
            this.send(System.nanoTime(), rtpts);
        }
    }

    private void send(final long ntpts, final long rtpts) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long hb = ntpts / 1000000000L;
                long lb = (ntpts - hb * 1000000000L) * 0x100000000L / 1000000000L;
                SenderReportTcp.this.setLong(hb, 8, 12);
                SenderReportTcp.this.setLong(lb, 12, 16);
                SenderReportTcp.this.setLong(rtpts, 16, 20);
                OutputStream outputStream = SenderReportTcp.this.mOutputStream;
                synchronized (outputStream) {
                    try {
                        SenderReportTcp.this.mOutputStream.write(SenderReportTcp.this.mTcpHeader);
                        SenderReportTcp.this.mOutputStream.write(SenderReportTcp.this.mBuffer, 0, 28);
                        Log.i((String)"SenderReport", (String)"send report");
                    }
                    catch (IOException e) {
                        Log.e((String)"SenderReport", (String)"send TCP report error", (Throwable)e);
                        SenderReportTcp.this.connectCheckerRtsp.onConnectionFailedRtsp();
                    }
                }
            }
        }).start();
    }

    public void setOutputStream(OutputStream os, byte channelIdentifier) {
        this.mOutputStream = os;
        this.mTcpHeader[1] = channelIdentifier;
    }
}

