package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportTcp;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

/**
 * Created by pedro on 24/02/17.
 */
public class RtpSocketTcp extends BaseRtpSocket implements Runnable {

  private SenderReportTcp senderReportTcp;
  private byte mTcpHeader[];
  private int[] lengths;
  private OutputStream mOutputStream = null;
  private ConnectCheckerRtsp connectCheckerRtsp;

  public RtpSocketTcp(ConnectCheckerRtsp connectCheckerRtsp) {
    super();
    this.connectCheckerRtsp = connectCheckerRtsp;
    lengths = new int[mBufferCount];
    senderReportTcp = new SenderReportTcp(connectCheckerRtsp);
    senderReportTcp.reset();
    mTcpHeader = new byte[] { '$', 0, 0, 0 };
  }

  @Override
  public void setSSRC(int ssrc) {
    for (int i = 0; i < mBufferCount; i++) {
      setLong(mBuffers[i], ssrc, 8, 12);
    }
    senderReportTcp.setSSRC(ssrc);
  }

  public void setOutputStream(OutputStream outputStream, byte channelIdentifier) {
    if (outputStream != null) {
      mOutputStream = outputStream;
      mTcpHeader[1] = channelIdentifier;
      senderReportTcp.setOutputStream(outputStream, (byte) (channelIdentifier + 1));
    }
  }

  /** Sends the RTP packet over the network. */
  @Override
  public void commitBuffer(int length) throws IOException {
    updateSequence();
    lengths[mBufferIn] = length;
    if (++mBufferIn >= mBufferCount) mBufferIn = 0;
    mBufferCommitted.release();
    if (mThread == null) {
      mThread = new Thread(this);
      mThread.start();
    }
  }

  /** The Thread sends the packets in the FIFO one by one at a constant rate. */
  @Override
  public void run() {
    try {
      while (mBufferCommitted.tryAcquire(4, TimeUnit.SECONDS)) {
        senderReportTcp.update(lengths[mBufferOut], mTimestamps[mBufferOut]);
        sendTCP();
        if (++mBufferOut >= mBufferCount) mBufferOut = 0;
        mBufferRequested.release();
      }
    } catch (IOException | InterruptedException e) {
      Log.e(TAG, "TCP send error: ", e);
      connectCheckerRtsp.onConnectionFailedRtsp();
    }

    mThread = null;
    resetFifo();
    senderReportTcp.reset();
  }

  private void sendTCP() throws IOException {
    synchronized (mOutputStream) {
      int len = lengths[mBufferOut];
      mTcpHeader[2] = (byte) (len >> 8);
      mTcpHeader[3] = (byte) (len & 0xFF);
      mOutputStream.write(mTcpHeader);
      mOutputStream.write(mBuffers[mBufferOut], 0, len);
      mOutputStream.flush();
      Log.i(TAG, "send packet, " + len + " Size");
    }
  }
}