/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.audio.packet;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.audio.AudioObjectType;
import com.pedro.rtmp.flv.audio.AudioSize;
import com.pedro.rtmp.flv.audio.AudioSoundRate;
import com.pedro.rtmp.flv.audio.AudioSoundType;
import com.pedro.rtmp.flv.audio.config.AacAudioSpecificConfig;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fJ:\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\"\u0010\u0014\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pedro/rtmp/flv/audio/packet/AacPacket;", "Lcom/pedro/rtmp/flv/BasePacket;", "<init>", "()V", "header", "", "configSend", "", "sampleRate", "", "isStereo", "audioSize", "Lcom/pedro/rtmp/flv/audio/AudioSize;", "objectType", "Lcom/pedro/rtmp/flv/audio/AudioObjectType;", "sendAudioInfo", "", "createFlvPacket", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "Lcom/pedro/rtmp/flv/FlvPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "resetInfo", "Type", "rtmp_release"})
public final class AacPacket
extends BasePacket {
    @NotNull
    private final byte[] header = new byte[2];
    private boolean configSend;
    private int sampleRate = 44100;
    private boolean isStereo = true;
    @NotNull
    private AudioSize audioSize = AudioSize.SND_16_BIT;
    @NotNull
    private final AudioObjectType objectType = AudioObjectType.AAC_LC;

    public final void sendAudioInfo(int sampleRate, boolean isStereo, @NotNull AudioSize audioSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioSize), (String)"audioSize");
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
        this.audioSize = audioSize;
    }

    public static /* synthetic */ void sendAudioInfo$default(AacPacket aacPacket, int n, boolean bl, AudioSize audioSize, int n2, Object object) {
        if ((n2 & 4) != 0) {
            audioSize = AudioSize.SND_16_BIT;
        }
        aacPacket.sendAudioInfo(n, bl, audioSize);
    }

    @Override
    @Nullable
    public Object createFlvPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super FlvPacket, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        byte type = this.isStereo ? AudioSoundType.STEREO.getValue() : AudioSoundType.MONO.getValue();
        AudioSoundRate soundRate = switch (this.sampleRate) {
            case 44100 -> AudioSoundRate.SR_44_1K;
            case 22050 -> AudioSoundRate.SR_22K;
            case 11025 -> AudioSoundRate.SR_11K;
            case 5500 -> AudioSoundRate.SR_5_5K;
            default -> AudioSoundRate.SR_44_1K;
        };
        this.header[0] = (byte)((byte)((byte)(type | (byte)(this.audioSize.getValue() << 1)) | (byte)(soundRate.getValue() << 2)) | (byte)(AudioFormat.AAC.getValue() << 4));
        byte[] buffer = null;
        if (!this.configSend) {
            AacAudioSpecificConfig config = new AacAudioSpecificConfig(this.objectType.getValue(), this.sampleRate, this.isStereo ? 2 : 1);
            buffer = new byte[config.getSize() + this.header.length];
            this.header[1] = Type.SEQUENCE.getMark();
            config.write(buffer, this.header.length);
            this.configSend = true;
        } else {
            this.header[1] = Type.RAW.getMark();
            buffer = new byte[fixedBuffer.remaining() + this.header.length];
            fixedBuffer.get(buffer, this.header.length, fixedBuffer.remaining());
        }
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        long ts = mediaFrame.getInfo().getTimestamp() / (long)1000;
        Object object = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.AUDIO), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void reset(boolean resetInfo) {
        this.configSend = false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/pedro/rtmp/flv/audio/packet/AacPacket$Type;", "", "mark", "", "<init>", "(Ljava/lang/String;IB)V", "getMark", "()B", "SEQUENCE", "RAW", "rtmp_release"})
    public static final class Type
    extends Enum<Type> {
        private final byte mark;
        public static final /* enum */ Type SEQUENCE = new Type(0);
        public static final /* enum */ Type RAW = new Type(1);
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(byte mark) {
            this.mark = mark;
        }

        public final byte getMark() {
            return this.mark;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SEQUENCE, Type.RAW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

