/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message.control;

import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.rtmp.message.control.Event;
import com.pedro.rtmp.rtmp.message.control.Type;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/pedro/rtmp/rtmp/message/control/UserControl;", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "type", "Lcom/pedro/rtmp/rtmp/message/control/Type;", "event", "Lcom/pedro/rtmp/rtmp/message/control/Event;", "(Lcom/pedro/rtmp/rtmp/message/control/Type;Lcom/pedro/rtmp/rtmp/message/control/Event;)V", "TAG", "", "bodySize", "", "getEvent", "()Lcom/pedro/rtmp/rtmp/message/control/Event;", "setEvent", "(Lcom/pedro/rtmp/rtmp/message/control/Event;)V", "getType", "()Lcom/pedro/rtmp/rtmp/message/control/Type;", "setType", "(Lcom/pedro/rtmp/rtmp/message/control/Type;)V", "getSize", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "readBody", "", "input", "Ljava/io/InputStream;", "storeBody", "", "toString", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nUserControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserControl.kt\ncom/pedro/rtmp/rtmp/message/control/UserControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class UserControl
extends RtmpMessage {
    @NotNull
    private Type type;
    @NotNull
    private Event event;
    @NotNull
    private final String TAG;
    private int bodySize;

    public UserControl(@NotNull Type type, @NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super(new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.PROTOCOL_CONTROL.getMark()));
        this.type = type;
        this.event = event;
        this.TAG = "UserControl";
        this.bodySize = 6;
    }

    public /* synthetic */ UserControl(Type type, Event event, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            type = Type.PING_REQUEST;
        }
        if ((n & 2) != 0) {
            event = new Event(-1, -1);
        }
        this(type, event);
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    @NotNull
    public final Event getEvent() {
        return this.event;
    }

    public final void setEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"<set-?>");
        this.event = event;
    }

    @Override
    public void readBody(@NotNull InputStream input) {
        Event event;
        Type type;
        int t;
        block4: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.bodySize = 0;
            t = UtilsKt.readUInt16(input);
            Type[] typeArray = Type.values();
            UserControl userControl = this;
            Type[] typeArray2 = typeArray;
            int n = typeArray2.length;
            for (int i = 0; i < n; ++i) {
                Type type2;
                Type it = type2 = typeArray2[i];
                boolean bl = false;
                if (!(it.getMark() == t)) continue;
                type = type2;
                break block4;
            }
            type = null;
        }
        if (type == null) {
            throw new IOException("unknown user control type: " + t);
        }
        userControl.type = type;
        this.bodySize += 2;
        int data = UtilsKt.readUInt32(input);
        this.bodySize += 4;
        if (this.type == Type.SET_BUFFER_LENGTH) {
            int bufferLength = UtilsKt.readUInt32(input);
            event = new Event(data, bufferLength);
        } else {
            event = new Event(data, 0, 2, null);
        }
        this.event = event;
    }

    @Override
    @NotNull
    public byte[] storeBody() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        UtilsKt.writeUInt16(byteArrayOutputStream, this.type.getMark());
        UtilsKt.writeUInt32(byteArrayOutputStream, this.event.getData());
        if (this.event.getBufferLength() != -1) {
            UtilsKt.writeUInt32(byteArrayOutputStream, this.event.getBufferLength());
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.USER_CONTROL;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        return "UserControl(type=" + this.type + ", event=" + this.event + ", bodySize=" + this.bodySize + ")";
    }

    public UserControl() {
        this(null, null, 3, null);
    }
}

