/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message.command;

import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfNumber;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pedro/rtmp/rtmp/message/command/Command;", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "name", "", "commandId", "", "timeStamp", "streamId", "basicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "(Ljava/lang/String;IIILcom/pedro/rtmp/rtmp/message/BasicHeader;)V", "bodySize", "getCommandId", "()I", "setCommandId", "(I)V", "data", "", "Lcom/pedro/rtmp/amf/v0/AmfData;", "getData", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "addData", "", "amfData", "getSize", "readBody", "input", "Ljava/io/InputStream;", "storeBody", "", "toString", "rtmp_release"})
public abstract class Command
extends RtmpMessage {
    @NotNull
    private String name;
    private int commandId;
    private final int timeStamp;
    private final int streamId;
    @NotNull
    private final List<AmfData> data;
    private int bodySize;

    public Command(@NotNull String name, int commandId, int timeStamp, int streamId, @NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        super(basicHeader);
        this.name = name;
        this.commandId = commandId;
        this.timeStamp = timeStamp;
        this.streamId = streamId;
        boolean bl = false;
        this.data = new ArrayList();
        AmfString amfString = new AmfString(this.name);
        this.data.add(amfString);
        Command command = this;
        command.bodySize += amfString.getSize() + 1;
        AmfNumber amfNumber = new AmfNumber(this.commandId);
        Command command2 = this;
        command2.bodySize += amfNumber.getSize() + 1;
        this.data.add(amfNumber);
        this.getHeader().setMessageLength(this.bodySize);
        this.getHeader().setTimeStamp(this.timeStamp);
        this.getHeader().setMessageStreamId(this.streamId);
    }

    public /* synthetic */ Command(String string, int n, int n2, int n3, BasicHeader basicHeader, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "";
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        this(string, n, n2, n3, basicHeader);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final int getCommandId() {
        return this.commandId;
    }

    public final void setCommandId(int n) {
        this.commandId = n;
    }

    @NotNull
    public final List<AmfData> getData() {
        return this.data;
    }

    public final void addData(@NotNull AmfData amfData) {
        Intrinsics.checkNotNullParameter((Object)amfData, (String)"amfData");
        this.data.add(amfData);
        Command command = this;
        command.bodySize += amfData.getSize() + 1;
        this.getHeader().setMessageLength(this.bodySize);
    }

    @Override
    public void readBody(@NotNull InputStream input) {
        int bytesRead;
        AmfData amfData;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.data.clear();
        for (bytesRead = 0; bytesRead < this.getHeader().getMessageLength(); bytesRead += amfData.getSize() + 1) {
            amfData = AmfData.Companion.getAmfData(input);
            this.data.add(amfData);
        }
        Collection collection = this.data;
        boolean bl = false;
        if (!collection.isEmpty()) {
            if (this.data.get(0) instanceof AmfString) {
                this.name = ((AmfString)this.data.get(0)).getValue();
            }
            if (this.data.size() >= 2 && this.data.get(1) instanceof AmfNumber) {
                this.commandId = (int)((AmfNumber)this.data.get(1)).getValue();
            }
        }
        this.bodySize = bytesRead;
        this.getHeader().setMessageLength(this.bodySize);
    }

    @Override
    @NotNull
    public byte[] storeBody() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterable $this$forEach$iv = this.data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmfData it = (AmfData)element$iv;
            boolean bl = false;
            it.writeHeader(byteArrayOutputStream);
            it.writeBody(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        return "Command(name='" + this.name + "', transactionId=" + this.commandId + ", timeStamp=" + this.timeStamp + ", streamId=" + this.streamId + ", data=" + this.data + ", bodySize=" + this.bodySize + ')';
    }
}

