/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.R;
import com.pedro.library.util.Filter;
import com.pedro.library.view.ForceRenderer;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.RenderErrorCallback;
import com.pedro.library.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0013\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010?\u001a\u00020:H\u0016J\u0010\u0010@\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001cH\u0016J\u0010\u0010@\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010A\u001a\u00020\u001cH\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020\u001cH\u0016J\u0010\u0010D\u001a\u00020:2\u0006\u0010E\u001a\u00020\u001cH\u0016J\u000e\u0010F\u001a\u00020:2\u0006\u0010+\u001a\u00020,J\u0016\u0010G\u001a\u00020:2\u0006\u0010H\u001a\u00020&2\u0006\u0010I\u001a\u00020&J\u0010\u0010J\u001a\u00020:2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0010\u0010K\u001a\u00020:2\u0006\u0010L\u001a\u00020&H\u0016J\u0010\u0010M\u001a\u00020:2\u0006\u0010L\u001a\u00020&H\u0016J\u0010\u0010N\u001a\u00020:2\u0006\u0010L\u001a\u00020&H\u0016J\u0010\u0010O\u001a\u00020:2\u0006\u0010L\u001a\u00020&H\u0016J\b\u0010%\u001a\u00020:H\u0016J\b\u0010P\u001a\u00020:H\u0016J\b\u0010Q\u001a\u00020&H\u0016J\u0018\u0010R\u001a\u00020:2\u0006\u0010S\u001a\u00020&2\u0006\u0010E\u001a\u00020\u001cH\u0016J\u0010\u0010R\u001a\u00020:2\u0006\u0010S\u001a\u00020&H\u0016J\b\u0010T\u001a\u00020&H\u0016J\u0010\u0010U\u001a\u00020:2\u0006\u0010V\u001a\u000204H\u0016J\u0018\u0010W\u001a\u00020:2\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u001cH\u0016J\u0018\u0010Z\u001a\u00020:2\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u001cH\u0016J\b\u0010[\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020:2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010^\u001a\u00020:2\u0006\u0010_\u001a\u00020&H\u0002J\u0010\u0010`\u001a\u00020:2\u0006\u0010a\u001a\u000208H\u0016J\b\u0010b\u001a\u00020:H\u0016J\u0010\u0010c\u001a\u00020:2\u0006\u0010a\u001a\u000208H\u0016J\b\u0010d\u001a\u00020:H\u0016J\b\u0010e\u001a\u00020:H\u0016J\b\u0010f\u001a\u00020:H\u0016J\u0010\u0010g\u001a\u00020:2\u0006\u0010h\u001a\u000206H\u0016J\u0010\u0010i\u001a\u00020:2\u0006\u0010j\u001a\u00020kH\u0016J(\u0010l\u001a\u00020:2\u0006\u0010j\u001a\u00020k2\u0006\u0010m\u001a\u00020\u001c2\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u001cH\u0016J\u0010\u0010n\u001a\u00020:2\u0006\u0010j\u001a\u00020kH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/pedro/library/view/OpenGlView;", "Landroid/view/SurfaceView;", "Lcom/pedro/library/view/GlInterface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Landroid/view/SurfaceHolder$Callback;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mainRender", "Lcom/pedro/encoder/input/gl/render/MainRender;", "surfaceManagerPhoto", "Lcom/pedro/encoder/input/gl/SurfaceManager;", "surfaceManager", "surfaceManagerEncoder", "surfaceManagerEncoderRecord", "filterQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/library/util/Filter;", "threadQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/lang/Runnable;", "previewWidth", "", "previewHeight", "encoderWidth", "encoderHeight", "encoderRecordWidth", "encoderRecordHeight", "takePhotoCallback", "Lcom/pedro/library/view/TakePhotoCallback;", "streamRotation", "muteVideo", "", "isPreviewHorizontalFlip", "isPreviewVerticalFlip", "isStreamHorizontalFlip", "isStreamVerticalFlip", "aspectRatioMode", "Lcom/pedro/encoder/utils/gl/AspectRatioMode;", "executor", "Ljava/util/concurrent/ExecutorService;", "fpsLimiter", "Lcom/pedro/encoder/input/video/FpsLimiter;", "forceRenderer", "Lcom/pedro/library/view/ForceRenderer;", "renderErrorCallback", "Lcom/pedro/library/view/RenderErrorCallback;", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "getSurface", "Landroid/view/Surface;", "setFilter", "", "filterPosition", "baseFilterRender", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "addFilter", "clearFilters", "removeFilter", "filtersCount", "setRotation", "rotation", "forceFpsLimit", "fps", "setAspectRatioMode", "setCameraFlip", "isFlipHorizontal", "isFlipVertical", "setStreamRotation", "setIsStreamHorizontalFlip", "flip", "setIsStreamVerticalFlip", "setIsPreviewHorizontalFlip", "setIsPreviewVerticalFlip", "unMuteVideo", "isVideoMuted", "setForceRender", "enabled", "isRunning", "setRenderErrorCallback", "callback", "setEncoderSize", "width", "height", "setEncoderRecordSize", "getEncoderSize", "Landroid/graphics/Point;", "takePhoto", "draw", "forced", "addMediaCodecSurface", "surface", "removeMediaCodecSurface", "addMediaCodecRecordSurface", "removeMediaCodecRecordSurface", "start", "stop", "onFrameAvailable", "surfaceTexture", "surfaceCreated", "holder", "Landroid/view/SurfaceHolder;", "surfaceChanged", "format", "surfaceDestroyed", "library_release"})
@RequiresApi(api=18)
public class OpenGlView
extends SurfaceView
implements GlInterface,
SurfaceTexture.OnFrameAvailableListener,
SurfaceHolder.Callback {
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final MainRender mainRender;
    @NotNull
    private final SurfaceManager surfaceManagerPhoto;
    @NotNull
    private final SurfaceManager surfaceManager;
    @NotNull
    private final SurfaceManager surfaceManagerEncoder;
    @NotNull
    private final SurfaceManager surfaceManagerEncoderRecord;
    @NotNull
    private final BlockingQueue<Filter> filterQueue;
    @NotNull
    private final LinkedBlockingQueue<Runnable> threadQueue;
    private int previewWidth;
    private int previewHeight;
    private int encoderWidth;
    private int encoderHeight;
    private int encoderRecordWidth;
    private int encoderRecordHeight;
    @Nullable
    private TakePhotoCallback takePhotoCallback;
    private int streamRotation;
    private boolean muteVideo;
    private boolean isPreviewHorizontalFlip;
    private boolean isPreviewVerticalFlip;
    private boolean isStreamHorizontalFlip;
    private boolean isStreamVerticalFlip;
    @NotNull
    private AspectRatioMode aspectRatioMode;
    @Nullable
    private ExecutorService executor;
    @NotNull
    private final FpsLimiter fpsLimiter;
    @NotNull
    private final ForceRenderer forceRenderer;
    @Nullable
    private RenderErrorCallback renderErrorCallback;

    public OpenGlView(@Nullable Context context) {
        super(context);
        this.running = new AtomicBoolean(false);
        this.mainRender = new MainRender();
        this.surfaceManagerPhoto = new SurfaceManager();
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerEncoderRecord = new SurfaceManager();
        this.filterQueue = new LinkedBlockingQueue();
        this.threadQueue = new LinkedBlockingQueue();
        this.aspectRatioMode = AspectRatioMode.Adjust;
        this.fpsLimiter = new FpsLimiter();
        this.forceRenderer = new ForceRenderer();
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenGlView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.running = new AtomicBoolean(false);
        this.mainRender = new MainRender();
        this.surfaceManagerPhoto = new SurfaceManager();
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerEncoderRecord = new SurfaceManager();
        this.filterQueue = new LinkedBlockingQueue();
        this.threadQueue = new LinkedBlockingQueue();
        this.aspectRatioMode = AspectRatioMode.Adjust;
        this.fpsLimiter = new FpsLimiter();
        this.forceRenderer = new ForceRenderer();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OpenGlView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        try {
            this.aspectRatioMode = AspectRatioMode.Companion.fromId(typedArray2.getInt(R.styleable.OpenGlView_aspectRatioMode, AspectRatioMode.NONE.ordinal()));
            boolean isFlipHorizontal = typedArray2.getBoolean(R.styleable.OpenGlView_isFlipHorizontal, false);
            boolean isFlipVertical = typedArray2.getBoolean(R.styleable.OpenGlView_isFlipVertical, false);
            this.mainRender.setCameraFlip(isFlipHorizontal, isFlipVertical);
        }
        finally {
            typedArray2.recycle();
        }
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    @Override
    @NotNull
    public SurfaceTexture getSurfaceTexture() {
        return this.mainRender.getSurfaceTexture();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        return this.mainRender.getSurface();
    }

    @Override
    public void setFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.mainRender.filtersCount();
    }

    @Override
    public void setFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    @Override
    public void setRotation(int rotation) {
        this.mainRender.setCameraRotation(rotation);
    }

    @Override
    public void forceFpsLimit(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    public final void setAspectRatioMode(@NotNull AspectRatioMode aspectRatioMode) {
        Intrinsics.checkNotNullParameter((Object)aspectRatioMode, (String)"aspectRatioMode");
        this.aspectRatioMode = aspectRatioMode;
    }

    public final void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.mainRender.setCameraFlip(isFlipHorizontal, isFlipVertical);
    }

    @Override
    public void setStreamRotation(int streamRotation) {
        this.streamRotation = streamRotation;
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setForceRender(boolean enabled, int fps) {
        this.forceRenderer.setEnabled(enabled, fps);
    }

    @Override
    public void setForceRender(boolean enabled) {
        this.setForceRender(enabled, 5);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void setRenderErrorCallback(@NotNull RenderErrorCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.renderErrorCallback = callback;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    public void setEncoderRecordSize(int width, int height) {
        this.encoderRecordWidth = width;
        this.encoderRecordHeight = height;
    }

    @Override
    @NotNull
    public Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    @Override
    public void takePhoto(@NotNull TakePhotoCallback takePhotoCallback) {
        Intrinsics.checkNotNullParameter((Object)takePhotoCallback, (String)"takePhotoCallback");
        this.takePhotoCallback = takePhotoCallback;
    }

    private final void draw(boolean forced) {
        int h;
        if (!this.isRunning()) {
            return;
        }
        boolean limitFps = this.fpsLimiter.limitFPS();
        if (!forced) {
            this.forceRenderer.frameAvailable();
        }
        if (!this.filterQueue.isEmpty() && this.mainRender.isReady()) {
            try {
                if (this.surfaceManager.makeCurrent()) {
                    Filter filter = this.filterQueue.take();
                    this.mainRender.setFilterAction(filter.filterAction, filter.position, filter.baseFilterRender);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (this.surfaceManager.isReady() && this.mainRender.isReady()) {
            if (!this.surfaceManager.makeCurrent()) {
                return;
            }
            this.mainRender.updateFrame();
            this.mainRender.drawSource();
            if (!limitFps) {
                this.mainRender.drawFilters(true);
                this.mainRender.drawScreen(this.previewWidth, this.previewHeight, this.aspectRatioMode, 0, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip, null);
            }
            this.surfaceManager.swapBuffer();
        }
        if (this.surfaceManagerEncoder.isReady() || this.surfaceManagerEncoderRecord.isReady() || this.surfaceManagerPhoto.isReady()) {
            this.mainRender.drawFilters(false);
        }
        if (this.surfaceManagerEncoder.isReady() && this.mainRender.isReady() && !limitFps) {
            int w = this.muteVideo ? 0 : this.encoderWidth;
            int n = h = this.muteVideo ? 0 : this.encoderHeight;
            if (this.surfaceManagerEncoder.makeCurrent()) {
                this.mainRender.drawScreen(w, h, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, null);
                this.surfaceManagerEncoder.swapBuffer();
            }
        }
        if (this.surfaceManagerEncoderRecord.isReady() && this.mainRender.isReady() && !limitFps) {
            int w = this.muteVideo ? 0 : this.encoderRecordWidth;
            int n = h = this.muteVideo ? 0 : this.encoderRecordHeight;
            if (this.surfaceManagerEncoderRecord.makeCurrent()) {
                this.mainRender.drawScreen(w, h, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, null);
                this.surfaceManagerEncoderRecord.swapBuffer();
            }
        }
        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady() && this.mainRender.isReady() && this.surfaceManagerPhoto.makeCurrent()) {
            this.mainRender.drawScreen(this.encoderWidth, this.encoderHeight, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, null);
            TakePhotoCallback takePhotoCallback = this.takePhotoCallback;
            if (takePhotoCallback != null) {
                takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
            }
            this.takePhotoCallback = null;
            this.surfaceManagerPhoto.swapBuffer();
        }
    }

    @Override
    public void addMediaCodecSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerEncoder.release();
            this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
        }
    }

    @Override
    public void removeMediaCodecSurface() {
        this.threadQueue.clear();
        this.surfaceManagerEncoder.release();
    }

    @Override
    public void addMediaCodecRecordSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerEncoderRecord.release();
            this.surfaceManagerEncoderRecord.eglSetup(surface, this.surfaceManager);
        }
    }

    @Override
    public void removeMediaCodecRecordSurface() {
        this.threadQueue.clear();
        this.surfaceManagerEncoderRecord.release();
    }

    @Override
    public void start() {
        block1: {
            this.threadQueue.clear();
            ExecutorService executorService = this.executor;
            if (executorService != null) {
                executorService.shutdownNow();
            }
            this.executor = null;
            ExecutorService executorService2 = this.executor = ExtensionsKt.newSingleThreadExecutor(this.threadQueue);
            if (executorService2 == null) break block1;
            ExtensionsKt.secureSubmit$default((ExecutorService)executorService2, (long)0L, () -> OpenGlView.start$lambda$0(this), (int)1, null);
        }
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.threadQueue.clear();
        ExecutorService executorService = this.executor;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        this.executor = null;
        this.forceRenderer.stop();
        this.surfaceManagerPhoto.release();
        this.surfaceManagerEncoder.release();
        this.surfaceManagerEncoderRecord.release();
        this.surfaceManager.release();
        this.mainRender.release();
    }

    public void onFrameAvailable(@NotNull SurfaceTexture surfaceTexture) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            if (!this.isRunning()) {
                return;
            }
            ExecutorService executorService = this.executor;
            if (executorService == null) break block1;
            executorService.execute(() -> OpenGlView.onFrameAvailable$lambda$0(this));
        }
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.previewWidth = width;
        this.previewHeight = height;
        this.mainRender.setPreviewSize(this.previewWidth, this.previewHeight);
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.stop();
    }

    private static final Unit start$lambda$0(OpenGlView this$0) {
        this$0.surfaceManager.release();
        this$0.surfaceManager.eglSetup(this$0.getHolder().getSurface());
        this$0.surfaceManagerPhoto.release();
        this$0.surfaceManagerPhoto.eglSetup(this$0.encoderWidth, this$0.encoderHeight, this$0.surfaceManager);
        this$0.surfaceManager.makeCurrent();
        MainRender mainRender = this$0.mainRender;
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        mainRender.initGl(context, this$0.encoderWidth, this$0.encoderHeight, this$0.encoderWidth, this$0.encoderHeight);
        this$0.running.set(true);
        this$0.mainRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this$0);
        this$0.forceRenderer.start((Function0<Unit>)((Function0)() -> OpenGlView.start$lambda$0$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$0$0(OpenGlView this$0) {
        block0: {
            ExecutorService executorService = this$0.executor;
            if (executorService == null) break block0;
            executorService.execute(() -> OpenGlView.start$lambda$0$0$0(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final void start$lambda$0$0$0(OpenGlView this$0) {
        try {
            this$0.draw(true);
        }
        catch (RuntimeException e) {
            RenderErrorCallback renderErrorCallback = this$0.renderErrorCallback;
            if (renderErrorCallback != null) {
                renderErrorCallback.onRenderError(e);
            }
            throw e;
        }
    }

    private static final void onFrameAvailable$lambda$0(OpenGlView this$0) {
        try {
            this$0.draw(false);
        }
        catch (RuntimeException e) {
            RenderErrorCallback renderErrorCallback = this$0.renderErrorCallback;
            if (renderErrorCallback != null) {
                renderErrorCallback.onRenderError(e);
            }
            throw e;
        }
    }
}

