/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.util.Pair;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.video.VideoEncoderHelper;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.FlvMuxerRecordController;
import com.pedro.rtmp.amf.v0.AmfEcmaArray;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.audio.packet.AacPacket;
import com.pedro.rtmp.flv.audio.packet.G711Packet;
import com.pedro.rtmp.flv.audio.packet.OpusPacket;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.packet.Av1Packet;
import com.pedro.rtmp.flv.video.packet.H264Packet;
import com.pedro.rtmp.flv.video.packet.H265Packet;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010 \u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010!\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020&H\u0016J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020/H\u0016J\b\u00102\u001a\u00020\u0017H\u0016J\b\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u00106\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00107\u001a\u000208H\u0002J \u00109\u001a\u0002042\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/pedro/library/util/FlvMuxerRecordController;", "Lcom/pedro/library/base/recording/BaseRecordController;", "<init>", "()V", "outputStream", "Ljava/io/OutputStream;", "videoPacket", "Lcom/pedro/rtmp/flv/BasePacket;", "audioPacket", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pedro/common/frame/MediaFrame;", "job", "Lkotlinx/coroutines/Job;", "width", "", "height", "fps", "sampleRate", "isStereo", "", "sendInfo", "startRecord", "", "path", "", "listener", "Lcom/pedro/library/base/recording/RecordController$Listener;", "tracks", "Lcom/pedro/library/base/recording/RecordController$RecordTracks;", "fd", "Ljava/io/FileDescriptor;", "start", "stopRecord", "recordVideo", "videoBuffer", "Ljava/nio/ByteBuffer;", "videoInfo", "Landroid/media/MediaCodec$BufferInfo;", "recordAudio", "audioBuffer", "audioInfo", "getVideoInfo", "buffer", "info", "setVideoFormat", "videoFormat", "Landroid/media/MediaFormat;", "setAudioFormat", "audioFormat", "resetFormats", "createFlvFileHeader", "", "writeFlvFileMetadata", "writeFlvPacket", "flvPacket", "Lcom/pedro/rtmp/flv/FlvPacket;", "createHeaderTag", "type", "", "length", "timeStamp", "", "library_release"})
@SourceDebugExtension(value={"SMAP\nFlvMuxerRecordController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlvMuxerRecordController.kt\ncom/pedro/library/util/FlvMuxerRecordController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,341:1\n1#2:342\n80#3,5:343\n80#3,5:348\n*S KotlinDebug\n*F\n+ 1 FlvMuxerRecordController.kt\ncom/pedro/library/util/FlvMuxerRecordController\n*L\n146#1:343,5\n154#1:348,5\n*E\n"})
public final class FlvMuxerRecordController
extends BaseRecordController {
    @Nullable
    private OutputStream outputStream;
    @Nullable
    private BasePacket videoPacket;
    @Nullable
    private BasePacket audioPacket;
    @NotNull
    private final LinkedBlockingQueue<MediaFrame> queue = new LinkedBlockingQueue(200);
    @Nullable
    private Job job;
    private int width;
    private int height;
    private int fps;
    private int sampleRate;
    private boolean isStereo = true;
    private boolean sendInfo;

    @Override
    public void startRecord(@NotNull String path, @Nullable RecordController.Listener listener, @NotNull RecordController.RecordTracks tracks) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)tracks), (String)"tracks");
        this.tracks = tracks;
        this.outputStream = new FileOutputStream(path);
        this.start(listener);
    }

    @Override
    public void startRecord(@NotNull FileDescriptor fd, @Nullable RecordController.Listener listener, @NotNull RecordController.RecordTracks tracks) {
        Intrinsics.checkNotNullParameter((Object)fd, (String)"fd");
        Intrinsics.checkNotNullParameter((Object)((Object)tracks), (String)"tracks");
        this.tracks = tracks;
        this.outputStream = new FileOutputStream(fd);
        this.start(listener);
    }

    private final void start(RecordController.Listener listener) {
        FlvMuxerRecordController flvMuxerRecordController = this;
        AudioCodec audioCodec = this.audioCodec;
        flvMuxerRecordController.audioPacket = switch (audioCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$0[audioCodec.ordinal()]) {
            case 1 -> (BasePacket)new G711Packet();
            case 2 -> {
                void $this$start_u24lambda_u240;
                AacPacket var2_2;
                AacPacket var3_3 = var2_2 = new AacPacket();
                FlvMuxerRecordController var5_6 = flvMuxerRecordController;
                boolean $i$a$-apply-FlvMuxerRecordController$start$1 = false;
                AacPacket.sendAudioInfo$default((AacPacket)$this$start_u24lambda_u240, (int)this.sampleRate, (boolean)this.isStereo, null, (int)4, null);
                flvMuxerRecordController = var5_6;
                yield (BasePacket)var2_2;
            }
            case 3 -> {
                void $this$start_u24lambda_u241;
                AacPacket var2_2;
                AacPacket $this$start_u24lambda_u240 = var2_2 = new OpusPacket();
                FlvMuxerRecordController var5_7 = flvMuxerRecordController;
                boolean $i$a$-apply-FlvMuxerRecordController$start$2 = false;
                $this$start_u24lambda_u241.sendAudioInfo(this.sampleRate, this.isStereo);
                flvMuxerRecordController = var5_7;
                yield (BasePacket)var2_2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        VideoCodec videoCodec = this.videoCodec;
        this.videoPacket = switch (videoCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$1[videoCodec.ordinal()]) {
            case 1 -> (BasePacket)new H264Packet();
            case 2 -> (BasePacket)new H265Packet();
            case 3 -> (BasePacket)new Av1Packet();
            default -> throw new NoWhenBranchMatchedException();
        };
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        this.queue.clear();
        OutputStream outputStream = this.outputStream;
        if (outputStream != null) {
            OutputStream it = outputStream;
            boolean bl = false;
            try {
                it.write(this.createFlvFileHeader());
                this.writeFlvFileMetadata(it);
            }
            catch (Exception exception) {
            }
        }
        if (this.tracks == RecordController.RecordTracks.AUDIO) {
            this.status = RecordController.Status.RECORDING;
        }
        RecordController.Listener listener2 = listener;
        if (listener2 != null) {
            listener2.onStatusChange(this.status);
        }
        this.job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FlvMuxerRecordController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Unable to fully structure code
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl30
                    }
                    case 2: {
                        mediaFrame = (MediaFrame)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        break;
                    }
                    case 3: {
                        mediaFrame = (MediaFrame)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                block10: while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                    this.L$0 = $this$launch;
                    this.L$1 = null;
                    this.label = 1;
                    v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.pedro.library.util.FlvMuxerRecordController ), ()Lcom/pedro/common/frame/MediaFrame;)((FlvMuxerRecordController)this.this$0), (Continuation)((Continuation)this), (int)1, null);
                    if (v0 == var4_3) {
                        return var4_3;
                    }
lbl30:
                    // 3 sources

                    mediaFrame = (MediaFrame)v0;
                    switch (start.WhenMappings.$EnumSwitchMapping$0[mediaFrame.getType().ordinal()]) {
                        case 1: {
                            v3 = FlvMuxerRecordController.access$getVideoPacket$p(this.this$0);
                            if (v3 == null) continue block10;
                            Intrinsics.checkNotNull((Object)mediaFrame);
                            this.L$0 = $this$launch;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)mediaFrame);
                            this.label = 2;
                            v1 = v3.createFlvPacket(mediaFrame, (Function2)new Function2<FlvPacket, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ FlvMuxerRecordController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    FlvPacket flvPacket = (FlvPacket)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            OutputStream outputStream = FlvMuxerRecordController.access$getOutputStream$p(this.this$0);
                                            if (outputStream != null) {
                                                void packet;
                                                OutputStream outputStream2 = outputStream;
                                                FlvMuxerRecordController flvMuxerRecordController = this.this$0;
                                                OutputStream it = outputStream2;
                                                boolean bl = false;
                                                FlvMuxerRecordController.access$writeFlvPacket(flvMuxerRecordController, it, (FlvPacket)packet);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(FlvPacket p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (v1 != var4_3) continue block10;
                            return var4_3;
                        }
                        case 2: {
                            v4 = FlvMuxerRecordController.access$getAudioPacket$p(this.this$0);
                            if (v4 == null) continue block10;
                            Intrinsics.checkNotNull((Object)mediaFrame);
                            this.L$0 = $this$launch;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)mediaFrame);
                            this.label = 3;
                            v2 = v4.createFlvPacket(mediaFrame, (Function2)new Function2<FlvPacket, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ FlvMuxerRecordController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    FlvPacket flvPacket = (FlvPacket)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            OutputStream outputStream = FlvMuxerRecordController.access$getOutputStream$p(this.this$0);
                                            if (outputStream != null) {
                                                void packet;
                                                OutputStream outputStream2 = outputStream;
                                                FlvMuxerRecordController flvMuxerRecordController = this.this$0;
                                                OutputStream it = outputStream2;
                                                boolean bl = false;
                                                FlvMuxerRecordController.access$writeFlvPacket(flvMuxerRecordController, it, (FlvPacket)packet);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(FlvPacket p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (v2 != var4_3) continue block10;
                            return var4_3;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final MediaFrame invokeSuspend$lambda$0(FlvMuxerRecordController this$0) {
                return (MediaFrame)FlvMuxerRecordController.access$getQueue$p(this$0).take();
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecord() {
        this.status = RecordController.Status.STOPPED;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FlvMuxerRecordController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block5: {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = FlvMuxerRecordController.access$getJob$p(this.this$0);
                            if (v0 == null) break;
                            this.label = 1;
                            v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            v2 = Unit.INSTANCE;
                            break block5;
                        }
                    }
                    v2 = null;
                }
                return v2;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.startTs = 0L;
        this.queue.clear();
        BasePacket basePacket = this.videoPacket;
        if (basePacket != null) {
            basePacket.reset(false);
        }
        BasePacket basePacket2 = this.audioPacket;
        if (basePacket2 != null) {
            basePacket2.reset(false);
        }
        try {
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.outputStream = null;
        }
        this.requestKeyFrame = null;
        this.sendInfo = false;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recordVideo(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo videoInfo) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)videoInfo, (String)"videoInfo");
        if (this.tracks != RecordController.RecordTracks.AUDIO) {
            if (this.status == RecordController.Status.STARTED) {
                this.getVideoInfo(videoBuffer, videoInfo);
            } else if (this.status == RecordController.Status.RECORDING) {
                MediaFrame frame = new MediaFrame(ExtensionsKt.clone((ByteBuffer)videoBuffer), ExtensionsKt.toMediaFrameInfo((MediaCodec.BufferInfo)videoInfo), MediaFrame.Type.VIDEO);
                BlockingQueue blockingQueue = this.queue;
                MediaFrame item$iv = frame;
                boolean $i$f$trySend = false;
                try {
                    void $this$trySend$iv;
                    $this$trySend$iv.add(item$iv);
                    boolean bl = true;
                }
                catch (IllegalStateException illegalStateException) {
                    boolean bl = false;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recordAudio(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo audioInfo) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)audioInfo, (String)"audioInfo");
        if (this.status == RecordController.Status.RECORDING && this.tracks != RecordController.RecordTracks.VIDEO) {
            MediaFrame frame = new MediaFrame(ExtensionsKt.clone((ByteBuffer)audioBuffer), ExtensionsKt.toMediaFrameInfo((MediaCodec.BufferInfo)audioInfo), MediaFrame.Type.AUDIO);
            BlockingQueue blockingQueue = this.queue;
            MediaFrame item$iv = frame;
            boolean $i$f$trySend = false;
            try {
                void $this$trySend$iv;
                $this$trySend$iv.add(item$iv);
                boolean bl = true;
            }
            catch (IllegalStateException illegalStateException) {
                boolean bl = false;
            }
        }
    }

    private final void getVideoInfo(ByteBuffer buffer, MediaCodec.BufferInfo info) {
        if (info.flags == 1 || this.isKeyFrame(buffer)) {
            if (!this.sendInfo) {
                BasePacket basePacket = this.videoPacket;
                if (basePacket instanceof H264Packet) {
                    Pair buffers = VideoEncoderHelper.decodeSpsPpsFromBuffer((ByteBuffer)buffer.duplicate(), (int)info.size);
                    if (buffers != null) {
                        Log.i((String)"RecordController", (String)"manual sps/pps extraction success");
                        ByteBuffer oldSps = (ByteBuffer)buffers.first;
                        ByteBuffer oldPps = (ByteBuffer)buffers.second;
                        BasePacket basePacket2 = this.videoPacket;
                        Intrinsics.checkNotNull((Object)basePacket2, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.H264Packet");
                        H264Packet h264Packet = (H264Packet)basePacket2;
                        Intrinsics.checkNotNull((Object)oldSps);
                        Intrinsics.checkNotNull((Object)oldPps);
                        h264Packet.sendVideoInfo(oldSps, oldPps);
                        this.sendInfo = true;
                    } else {
                        Log.e((String)"RecordController", (String)"manual sps/pps extraction failed");
                    }
                } else if (basePacket instanceof H265Packet) {
                    List byteBufferList = VideoEncoderHelper.extractVpsSpsPpsFromH265((ByteBuffer)buffer.duplicate());
                    if (byteBufferList.size() == 3) {
                        Log.i((String)"RecordController", (String)"manual vps/sps/pps extraction success");
                        ByteBuffer oldSps = (ByteBuffer)byteBufferList.get(1);
                        ByteBuffer oldPps = (ByteBuffer)byteBufferList.get(2);
                        ByteBuffer oldVps = (ByteBuffer)byteBufferList.get(0);
                        BasePacket basePacket3 = this.videoPacket;
                        Intrinsics.checkNotNull((Object)basePacket3, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.H265Packet");
                        H265Packet h265Packet = (H265Packet)basePacket3;
                        Intrinsics.checkNotNull((Object)oldSps);
                        Intrinsics.checkNotNull((Object)oldPps);
                        Intrinsics.checkNotNull((Object)oldVps);
                        h265Packet.sendVideoInfo(oldSps, oldPps, oldVps);
                        this.sendInfo = true;
                    } else {
                        Log.e((String)"RecordController", (String)"manual vps/sps/pps extraction failed");
                    }
                } else if (basePacket instanceof Av1Packet) {
                    ByteBuffer obuSequence = VideoEncoderHelper.extractObuSequence((ByteBuffer)buffer.duplicate(), (MediaCodec.BufferInfo)info);
                    if (obuSequence != null) {
                        BasePacket basePacket4 = this.videoPacket;
                        Intrinsics.checkNotNull((Object)basePacket4, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.Av1Packet");
                        ((Av1Packet)basePacket4).sendVideoInfo(obuSequence);
                        this.sendInfo = true;
                    } else {
                        Log.e((String)"RecordController", (String)"manual av1 extraction failed");
                    }
                } else {
                    Object object = this.videoPacket;
                    if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getName()) == null) {
                        object = "null";
                    }
                    Log.e((String)"RecordController", (String)("Unsupported codec: " + (String)object));
                }
            }
            if (this.sendInfo && this.status == RecordController.Status.STARTED) {
                this.requestKeyFrame = null;
                this.status = RecordController.Status.RECORDING;
                RecordController.Listener listener = this.listener;
                if (listener != null) {
                    listener.onStatusChange(this.status);
                }
            }
        } else if (this.requestKeyFrame != null) {
            this.requestKeyFrame.onRequestKeyFrame();
            this.requestKeyFrame = null;
        }
    }

    @Override
    public void setVideoFormat(@NotNull MediaFormat videoFormat) {
        block8: {
            ByteBuffer bufferInfo;
            Intrinsics.checkNotNullParameter((Object)videoFormat, (String)"videoFormat");
            int width = videoFormat.getInteger("width");
            int height = videoFormat.getInteger("height");
            int fps = videoFormat.getInteger("frame-rate");
            this.width = width;
            this.height = height;
            this.fps = fps;
            BasePacket basePacket = this.videoPacket;
            if (basePacket instanceof H264Packet) {
                ByteBuffer sps = videoFormat.getByteBuffer("csd-0");
                ByteBuffer pps = videoFormat.getByteBuffer("csd-1");
                if (sps != null && pps != null) {
                    BasePacket basePacket2 = this.videoPacket;
                    Intrinsics.checkNotNull((Object)basePacket2, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.H264Packet");
                    H264Packet h264Packet = (H264Packet)basePacket2;
                    ByteBuffer byteBuffer = sps.duplicate();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
                    ByteBuffer byteBuffer2 = pps.duplicate();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"duplicate(...)");
                    h264Packet.sendVideoInfo(byteBuffer, byteBuffer2);
                    this.sendInfo = true;
                }
            } else if (basePacket instanceof H265Packet) {
                List byteBufferList;
                ByteBuffer bufferInfo2 = videoFormat.getByteBuffer("csd-0");
                if (bufferInfo2 != null && (byteBufferList = VideoEncoderHelper.extractVpsSpsPpsFromH265((ByteBuffer)bufferInfo2.duplicate())).size() == 3) {
                    ByteBuffer sps = (ByteBuffer)byteBufferList.get(1);
                    ByteBuffer pps = (ByteBuffer)byteBufferList.get(2);
                    ByteBuffer vps = (ByteBuffer)byteBufferList.get(0);
                    BasePacket basePacket3 = this.videoPacket;
                    Intrinsics.checkNotNull((Object)basePacket3, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.H265Packet");
                    H265Packet h265Packet = (H265Packet)basePacket3;
                    Intrinsics.checkNotNull((Object)sps);
                    Intrinsics.checkNotNull((Object)pps);
                    Intrinsics.checkNotNull((Object)vps);
                    h265Packet.sendVideoInfo(sps, pps, vps);
                    this.sendInfo = true;
                }
            } else if (basePacket instanceof Av1Packet && (bufferInfo = videoFormat.getByteBuffer("csd-0")) != null && bufferInfo.remaining() > 4) {
                BasePacket basePacket4 = this.videoPacket;
                Intrinsics.checkNotNull((Object)basePacket4, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.Av1Packet");
                Av1Packet av1Packet = (Av1Packet)basePacket4;
                ByteBuffer byteBuffer = bufferInfo.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
                av1Packet.sendVideoInfo(byteBuffer);
                this.sendInfo = true;
            }
            if (!this.sendInfo || this.status != RecordController.Status.STARTED) break block8;
            this.requestKeyFrame = null;
            this.status = RecordController.Status.RECORDING;
            RecordController.Listener listener = this.listener;
            if (listener != null) {
                listener.onStatusChange(this.status);
            }
        }
    }

    @Override
    public void setAudioFormat(@NotNull MediaFormat audioFormat) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)audioFormat, (String)"audioFormat");
            int sampleRate = audioFormat.getInteger("sample-rate");
            int channels = audioFormat.getInteger("channel-count");
            this.sampleRate = sampleRate;
            this.isStereo = channels > 1;
            BasePacket basePacket = this.audioPacket;
            AacPacket aacPacket = basePacket instanceof AacPacket ? (AacPacket)basePacket : null;
            if (aacPacket == null) break block0;
            AacPacket.sendAudioInfo$default((AacPacket)aacPacket, (int)sampleRate, (boolean)this.isStereo, null, (int)4, null);
        }
    }

    @Override
    public void resetFormats() {
    }

    private final byte[] createFlvFileHeader() {
        byte flag = this.tracks == RecordController.RecordTracks.AUDIO ? (byte)4 : (this.tracks == RecordController.RecordTracks.VIDEO ? (byte)1 : 5);
        byte[] byArray = new byte[]{70, 76, 86, 1, flag, 0, 0, 0, 9, 0, 0, 0, 0};
        return byArray;
    }

    private final void writeFlvFileMetadata(OutputStream outputStream) {
        AmfString head = new AmfString("onMetaData");
        AmfEcmaArray info = new AmfEcmaArray(null, 1, null);
        info.setProperty("width", (double)this.width);
        info.setProperty("height", (double)this.height);
        VideoCodec videoCodec = this.videoCodec;
        int videoCodecValue = switch (videoCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$1[videoCodec.ordinal()]) {
            case 1 -> VideoFormat.AVC.getValue();
            case 2 -> VideoFormat.HEVC.getValue();
            case 3 -> VideoFormat.AV1.getValue();
            default -> throw new IllegalArgumentException("unsupported null codec");
        };
        info.setProperty("videocodecid", (double)videoCodecValue);
        info.setProperty("framerate", (double)this.fps);
        AudioCodec audioCodec = this.audioCodec;
        int audioCodecValue = switch (audioCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$0[audioCodec.ordinal()]) {
            case 2 -> AudioFormat.AAC.getValue();
            case 1 -> AudioFormat.G711_A.getValue();
            case 3 -> AudioFormat.OPUS.getValue();
            default -> throw new NoWhenBranchMatchedException();
        };
        info.setProperty("audiocodecid", (double)audioCodecValue);
        info.setProperty("audiosamplerate", (double)this.sampleRate);
        info.setProperty("audiosamplesize", 16.0);
        info.setProperty("stereo", this.isStereo);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        head.writeHeader((OutputStream)output);
        head.writeBody((OutputStream)output);
        info.writeHeader((OutputStream)output);
        info.writeBody((OutputStream)output);
        byte[] data = output.toByteArray();
        byte[] flvHeaderTag = this.createHeaderTag((byte)18, data.length, 0L);
        byte[] flvTagSize = ExtensionsKt.toUInt32((int)(flvHeaderTag.length + data.length));
        try {
            outputStream.write(flvHeaderTag);
            outputStream.write(data);
            outputStream.write(flvTagSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void writeFlvPacket(OutputStream outputStream, FlvPacket flvPacket) {
        byte type = switch (WhenMappings.$EnumSwitchMapping$2[flvPacket.getType().ordinal()]) {
            case 1 -> 8;
            case 2 -> 9;
            default -> throw new NoWhenBranchMatchedException();
        };
        byte[] flvHeaderTag = this.createHeaderTag(type, flvPacket.getLength(), flvPacket.getTimeStamp());
        byte[] flvTagSize = ExtensionsKt.toUInt32((int)(flvHeaderTag.length + flvPacket.getLength()));
        try {
            outputStream.write(flvHeaderTag);
            outputStream.write(flvPacket.getBuffer());
            outputStream.write(flvTagSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final byte[] createHeaderTag(byte type, int length, long timeStamp) {
        byte[] byArray = new byte[]{type};
        byte[] byArray2 = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])byArray, (byte[])ExtensionsKt.toUInt24((int)length)), (byte[])ExtensionsKt.toUInt24((int)((int)timeStamp))), (byte)((byte)(timeStamp >> 24)));
        byArray = new byte[]{0, 0, 0};
        return ArraysKt.plus((byte[])byArray2, (byte[])byArray);
    }

    public static final /* synthetic */ BasePacket access$getVideoPacket$p(FlvMuxerRecordController $this) {
        return $this.videoPacket;
    }

    public static final /* synthetic */ OutputStream access$getOutputStream$p(FlvMuxerRecordController $this) {
        return $this.outputStream;
    }

    public static final /* synthetic */ void access$writeFlvPacket(FlvMuxerRecordController $this, OutputStream outputStream, FlvPacket flvPacket) {
        $this.writeFlvPacket(outputStream, flvPacket);
    }

    public static final /* synthetic */ BasePacket access$getAudioPacket$p(FlvMuxerRecordController $this) {
        return $this.audioPacket;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(FlvMuxerRecordController $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Job access$getJob$p(FlvMuxerRecordController $this) {
        return $this.job;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[FlvType.values().length];
            try {
                nArray[FlvType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FlvType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

