/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base.recording;

import android.media.MediaCodec;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateManager;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.recording.RecordController;
import java.nio.ByteBuffer;

public abstract class BaseRecordController
implements RecordController {
    protected static final String TAG = "RecordController";
    protected RecordController.Status status = RecordController.Status.STOPPED;
    protected VideoCodec videoCodec = VideoCodec.H264;
    protected AudioCodec audioCodec = AudioCodec.AAC;
    protected long pauseMoment = 0L;
    protected long pauseTime = 0L;
    protected RecordController.Listener listener;
    protected int videoTrack = -1;
    protected int audioTrack = -1;
    protected BitrateManager bitrateManager;
    protected volatile long startTs = 0L;
    protected RecordController.RecordTracks tracks = RecordController.RecordTracks.ALL;
    protected RecordController.RequestKeyFrame requestKeyFrame = null;

    public void updateInfo(BaseRecordController recordController) {
        this.videoCodec = recordController.videoCodec;
        this.audioCodec = recordController.audioCodec;
    }

    public void setRequestKeyFrame(RecordController.RequestKeyFrame requestKeyFrame) {
        this.requestKeyFrame = requestKeyFrame;
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.videoCodec = videoCodec;
    }

    public void setAudioCodec(AudioCodec audioCodec) {
        this.audioCodec = audioCodec;
    }

    public boolean isRunning() {
        return this.status == RecordController.Status.STARTED || this.status == RecordController.Status.RECORDING || this.status == RecordController.Status.RESUMED || this.status == RecordController.Status.PAUSED;
    }

    public boolean isRecording() {
        return this.status == RecordController.Status.RECORDING;
    }

    public RecordController.Status getStatus() {
        return this.status;
    }

    public void pauseRecord() {
        if (this.status == RecordController.Status.RECORDING) {
            this.pauseMoment = TimeUtils.getCurrentTimeMicro();
            this.status = RecordController.Status.PAUSED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    public void resumeRecord() {
        if (this.status == RecordController.Status.PAUSED) {
            this.pauseTime += TimeUtils.getCurrentTimeMicro() - this.pauseMoment;
            this.status = RecordController.Status.RESUMED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    protected boolean isKeyFrame(ByteBuffer videoBuffer) {
        byte[] header = new byte[5];
        if (videoBuffer.remaining() < header.length) {
            return false;
        }
        videoBuffer.duplicate().get(header, 0, header.length);
        if (this.videoCodec == VideoCodec.AV1) {
            return false;
        }
        if (this.videoCodec == VideoCodec.H264 && (header[4] & 0x1F) == 5) {
            return true;
        }
        return this.videoCodec == VideoCodec.H265 && (header[4] >> 1 & 0x3F) == 19 || (header[4] >> 1 & 0x3F) == 20;
    }

    protected MediaCodec.BufferInfo updateFormat(MediaCodec.BufferInfo oldInfo) {
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        if (this.startTs <= 0L) {
            this.startTs = oldInfo.presentationTimeUs;
        }
        long ts = Math.max(0L, oldInfo.presentationTimeUs - this.startTs - this.pauseTime);
        info.set(oldInfo.offset, oldInfo.size, ts, oldInfo.flags);
        return info;
    }
}

