/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import com.pedro.encoder.input.sources.OrientationConfig;
import com.pedro.encoder.input.sources.OrientationForced;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.ViewPort;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.util.Filter;
import com.pedro.library.util.SensorRotationManager;
import com.pedro.library.view.ForceRenderer;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.RenderErrorCallback;
import com.pedro.library.view.TakePhotoCallback;
import com.pedro.library.view.preview.MultiPreviewConfig;
import com.pedro.library.view.preview.PreviewSurfaceInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0018H\u0016J\u0018\u0010H\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0018H\u0016J\b\u0010I\u001a\u00020JH\u0016J\b\u0010*\u001a\u00020EH\u0016J\b\u0010K\u001a\u00020EH\u0016J\b\u0010L\u001a\u00020 H\u0016J\u0018\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020 2\u0006\u0010O\u001a\u00020\u0018H\u0016J\u0010\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020 H\u0016J\b\u0010P\u001a\u00020 H\u0016J\u0012\u0010Q\u001a\u00020E2\b\u0010R\u001a\u0004\u0018\u00010>H\u0016J\b\u0010S\u001a\u00020TH\u0016J\b\u0010U\u001a\u00020\u0013H\u0016J\u0010\u0010V\u001a\u00020E2\u0006\u0010W\u001a\u00020\u0013H\u0016J\b\u0010X\u001a\u00020EH\u0016J\u0010\u0010Y\u001a\u00020E2\u0006\u0010W\u001a\u00020\u0013H\u0016J\b\u0010Z\u001a\u00020EH\u0016J\u0012\u0010[\u001a\u00020E2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\\\u001a\u00020EH\u0016J\b\u0010]\u001a\u00020EH\u0016J\u0010\u0010^\u001a\u00020E2\u0006\u0010_\u001a\u00020 H\u0002J\u0012\u0010`\u001a\u00020E2\b\u0010a\u001a\u0004\u0018\u00010TH\u0016J\u000e\u0010b\u001a\u00020E2\u0006\u0010c\u001a\u00020dJ\u000e\u0010e\u001a\u00020E2\u0006\u0010_\u001a\u00020#J\u000e\u0010f\u001a\u00020E2\u0006\u0010W\u001a\u00020\u0013J\u0006\u0010g\u001a\u00020EJ\u0016\u0010h\u001a\u00020E2\u0006\u0010W\u001a\u00020\u00132\u0006\u0010i\u001a\u00020jJ\u000e\u0010k\u001a\u00020E2\u0006\u0010W\u001a\u00020\u0013J\u0006\u0010l\u001a\u00020EJ\u0016\u0010m\u001a\u00020 2\u0006\u0010W\u001a\u00020\u00132\u0006\u0010i\u001a\u00020jJ\u000e\u0010n\u001a\u00020 2\u0006\u0010W\u001a\u00020\u0013J\u0006\u0010o\u001a\u00020\u0018J\u0010\u0010p\u001a\u00020E2\u0006\u0010q\u001a\u00020\u0018H\u0016J\u0016\u0010r\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0018J\u000e\u0010s\u001a\u00020E2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010t\u001a\u00020E2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010u\u001a\u00020E2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010v\u001a\u00020E2\u0006\u0010q\u001a\u00020\u0018J\u0018\u0010w\u001a\u00020E2\u0006\u0010x\u001a\u00020\u00182\u0006\u0010y\u001a\u00020zH\u0016J\u0010\u0010{\u001a\u00020E2\u0006\u0010y\u001a\u00020zH\u0016J\u0018\u0010{\u001a\u00020E2\u0006\u0010x\u001a\u00020\u00182\u0006\u0010y\u001a\u00020zH\u0016J\b\u0010|\u001a\u00020EH\u0016J\u0010\u0010}\u001a\u00020E2\u0006\u0010x\u001a\u00020\u0018H\u0016J\u0010\u0010}\u001a\u00020E2\u0006\u0010y\u001a\u00020zH\u0016J\b\u0010~\u001a\u00020\u0018H\u0016J\u0011\u0010\u007f\u001a\u00020E2\u0007\u0010\u0080\u0001\u001a\u00020\u0018H\u0016J\u0011\u0010\u0081\u0001\u001a\u00020E2\u0006\u0010O\u001a\u00020\u0018H\u0016J\u0012\u0010\u0082\u0001\u001a\u00020E2\u0007\u0010\u0083\u0001\u001a\u00020 H\u0016J\u0012\u0010\u0084\u0001\u001a\u00020E2\u0007\u0010\u0083\u0001\u001a\u00020 H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020E2\u0007\u0010\u0083\u0001\u001a\u00020 H\u0016J\u0012\u0010\u0086\u0001\u001a\u00020E2\u0007\u0010\u0083\u0001\u001a\u00020 H\u0016J\u0010\u0010w\u001a\u00020E2\u0006\u0010y\u001a\u00020zH\u0016J\u000f\u0010\u0087\u0001\u001a\u00020E2\u0006\u0010/\u001a\u000200J\u0012\u0010\u0088\u0001\u001a\u00020E2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010@J\u0012\u0010\u008a\u0001\u001a\u00020E2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010@R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lcom/pedro/library/view/GlStreamInterface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Lcom/pedro/library/view/GlInterface;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "takePhotoCallback", "Lcom/pedro/library/view/TakePhotoCallback;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "surfaceManager", "Lcom/pedro/encoder/input/gl/SurfaceManager;", "surfaceManagerEncoder", "surfaceManagerEncoderRecord", "surfaceManagerPhoto", "surfaceManagerPreview", "multiPreviewSurfaceManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Landroid/view/Surface;", "Lcom/pedro/library/view/preview/PreviewSurfaceInfo;", "mainRender", "Lcom/pedro/encoder/input/gl/render/MainRender;", "encoderWidth", "", "encoderHeight", "encoderRecordWidth", "encoderRecordHeight", "streamOrientation", "previewWidth", "previewHeight", "isPortrait", "", "isPortraitPreview", "orientationForced", "Lcom/pedro/encoder/input/sources/OrientationForced;", "filterQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/library/util/Filter;", "threadQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/lang/Runnable;", "muteVideo", "isPreviewHorizontalFlip", "isPreviewVerticalFlip", "isStreamHorizontalFlip", "isStreamVerticalFlip", "aspectRatioMode", "Lcom/pedro/encoder/utils/gl/AspectRatioMode;", "executor", "Ljava/util/concurrent/ExecutorService;", "fpsLimiter", "Lcom/pedro/encoder/input/video/FpsLimiter;", "forceRender", "Lcom/pedro/library/view/ForceRenderer;", "autoHandleOrientation", "getAutoHandleOrientation", "()Z", "setAutoHandleOrientation", "(Z)V", "shouldHandleOrientation", "renderErrorCallback", "Lcom/pedro/library/view/RenderErrorCallback;", "previewViewPort", "Lcom/pedro/encoder/utils/ViewPort;", "streamViewPort", "sensorRotationManager", "Lcom/pedro/library/util/SensorRotationManager;", "setEncoderSize", "", "width", "height", "setEncoderRecordSize", "getEncoderSize", "Landroid/graphics/Point;", "unMuteVideo", "isVideoMuted", "setForceRender", "enabled", "fps", "isRunning", "setRenderErrorCallback", "callback", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "getSurface", "addMediaCodecSurface", "surface", "removeMediaCodecSurface", "addMediaCodecRecordSurface", "removeMediaCodecRecordSurface", "takePhoto", "start", "stop", "draw", "forced", "onFrameAvailable", "surfaceTexture", "setOrientationConfig", "orientationConfig", "Lcom/pedro/encoder/input/sources/OrientationConfig;", "forceOrientation", "attachPreview", "deAttachPreview", "addMultiPreviewSurface", "config", "Lcom/pedro/library/view/preview/MultiPreviewConfig;", "removeMultiPreviewSurface", "removeAllMultiPreviewSurfaces", "updateMultiPreviewConfig", "hasMultiPreviewSurface", "getMultiPreviewSurfaceCount", "setStreamRotation", "orientation", "setPreviewResolution", "setIsPortrait", "setPreviewIsPortrait", "setStreamIsPortrait", "setCameraOrientation", "setFilter", "filterPosition", "baseFilterRender", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "addFilter", "clearFilters", "removeFilter", "filtersCount", "setRotation", "rotation", "forceFpsLimit", "setIsStreamHorizontalFlip", "flip", "setIsStreamVerticalFlip", "setIsPreviewHorizontalFlip", "setIsPreviewVerticalFlip", "setAspectRatioMode", "setPreviewViewPort", "viewPort", "setStreamViewPort", "library_release"})
@RequiresApi(api=18)
@SourceDebugExtension(value={"SMAP\nGlStreamInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlStreamInterface.kt\ncom/pedro/library/view/GlStreamInterface\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1869#2,2:538\n1869#2,2:540\n1869#2,2:543\n1#3:542\n*S KotlinDebug\n*F\n+ 1 GlStreamInterface.kt\ncom/pedro/library/view/GlStreamInterface\n*L\n215#1:538,2\n314#1:540,2\n418#1:543,2\n*E\n"})
public final class GlStreamInterface
implements SurfaceTexture.OnFrameAvailableListener,
GlInterface {
    @NotNull
    private final Context context;
    @Nullable
    private TakePhotoCallback takePhotoCallback;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final SurfaceManager surfaceManager;
    @NotNull
    private final SurfaceManager surfaceManagerEncoder;
    @NotNull
    private final SurfaceManager surfaceManagerEncoderRecord;
    @NotNull
    private final SurfaceManager surfaceManagerPhoto;
    @NotNull
    private final SurfaceManager surfaceManagerPreview;
    @NotNull
    private final ConcurrentHashMap<Surface, PreviewSurfaceInfo> multiPreviewSurfaceManagers;
    @NotNull
    private final MainRender mainRender;
    private int encoderWidth;
    private int encoderHeight;
    private int encoderRecordWidth;
    private int encoderRecordHeight;
    private int streamOrientation;
    private int previewWidth;
    private int previewHeight;
    private boolean isPortrait;
    private boolean isPortraitPreview;
    @NotNull
    private OrientationForced orientationForced;
    @NotNull
    private final BlockingQueue<Filter> filterQueue;
    @NotNull
    private final LinkedBlockingQueue<Runnable> threadQueue;
    private boolean muteVideo;
    private boolean isPreviewHorizontalFlip;
    private boolean isPreviewVerticalFlip;
    private boolean isStreamHorizontalFlip;
    private boolean isStreamVerticalFlip;
    @NotNull
    private AspectRatioMode aspectRatioMode;
    @Nullable
    private ExecutorService executor;
    @NotNull
    private final FpsLimiter fpsLimiter;
    @NotNull
    private final ForceRenderer forceRender;
    private boolean autoHandleOrientation;
    private boolean shouldHandleOrientation;
    @Nullable
    private RenderErrorCallback renderErrorCallback;
    @Nullable
    private ViewPort previewViewPort;
    @Nullable
    private ViewPort streamViewPort;
    @NotNull
    private final SensorRotationManager sensorRotationManager;

    public GlStreamInterface(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.running = new AtomicBoolean(false);
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerEncoderRecord = new SurfaceManager();
        this.surfaceManagerPhoto = new SurfaceManager();
        this.surfaceManagerPreview = new SurfaceManager();
        this.multiPreviewSurfaceManagers = new ConcurrentHashMap();
        this.mainRender = new MainRender();
        this.orientationForced = OrientationForced.NONE;
        this.filterQueue = new LinkedBlockingQueue();
        this.threadQueue = new LinkedBlockingQueue();
        this.aspectRatioMode = AspectRatioMode.Adjust;
        this.fpsLimiter = new FpsLimiter();
        this.forceRender = new ForceRenderer();
        this.shouldHandleOrientation = true;
        this.sensorRotationManager = new SensorRotationManager(this.context, true, true, (arg_0, arg_1) -> GlStreamInterface.sensorRotationManager$lambda$0(this, arg_0, arg_1));
    }

    public final boolean getAutoHandleOrientation() {
        return this.autoHandleOrientation;
    }

    public final void setAutoHandleOrientation(boolean bl) {
        this.autoHandleOrientation = bl;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    public void setEncoderRecordSize(int width, int height) {
        this.encoderRecordWidth = width;
        this.encoderRecordHeight = height;
    }

    @Override
    @NotNull
    public Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setForceRender(boolean enabled, int fps) {
        this.forceRender.setEnabled(enabled, fps);
    }

    @Override
    public void setForceRender(boolean enabled) {
        this.setForceRender(enabled, 5);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void setRenderErrorCallback(@Nullable RenderErrorCallback callback) {
        this.renderErrorCallback = callback;
    }

    @Override
    @NotNull
    public SurfaceTexture getSurfaceTexture() {
        return this.mainRender.getSurfaceTexture();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        return this.mainRender.getSurface();
    }

    @Override
    public void addMediaCodecSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerEncoder.release();
            this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
        }
    }

    @Override
    public void removeMediaCodecSurface() {
        this.threadQueue.clear();
        this.surfaceManagerEncoder.release();
    }

    @Override
    public void addMediaCodecRecordSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerEncoderRecord.release();
            this.surfaceManagerEncoderRecord.eglSetup(surface, this.surfaceManager);
        }
    }

    @Override
    public void removeMediaCodecRecordSurface() {
        this.threadQueue.clear();
        this.surfaceManagerEncoderRecord.release();
    }

    @Override
    public void takePhoto(@Nullable TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    @Override
    public void start() {
        block1: {
            this.threadQueue.clear();
            ExecutorService executorService = this.executor;
            if (executorService != null) {
                executorService.shutdownNow();
            }
            this.executor = null;
            this.executor = ExtensionsKt.newSingleThreadExecutor(this.threadQueue);
            int width = Math.max(this.encoderWidth, this.encoderRecordWidth);
            int height = Math.max(this.encoderHeight, this.encoderRecordHeight);
            this.surfaceManager.release();
            this.surfaceManager.eglSetup();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerPhoto.eglSetup(width, height, this.surfaceManager);
            this.sensorRotationManager.start();
            ExecutorService executorService2 = this.executor;
            if (executorService2 == null) break block1;
            ExtensionsKt.secureSubmit$default((ExecutorService)executorService2, (long)0L, () -> GlStreamInterface.start$lambda$0(this, width, height), (int)1, null);
        }
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.threadQueue.clear();
        ExecutorService executorService = this.executor;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        this.executor = null;
        this.forceRender.stop();
        this.sensorRotationManager.stop();
        this.surfaceManagerPhoto.release();
        this.surfaceManagerEncoder.release();
        this.surfaceManagerEncoderRecord.release();
        Collection<PreviewSurfaceInfo> collection = this.multiPreviewSurfaceManagers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreviewSurfaceInfo info = (PreviewSurfaceInfo)element$iv;
            boolean bl = false;
            info.getSurfaceManager().release();
        }
        this.multiPreviewSurfaceManagers.clear();
        this.surfaceManager.release();
        this.mainRender.release();
    }

    private final void draw(boolean forced) {
        int h;
        int w;
        if (!this.isRunning()) {
            return;
        }
        boolean limitFps = this.fpsLimiter.limitFPS();
        if (!forced) {
            this.forceRender.frameAvailable();
        }
        if (!this.filterQueue.isEmpty() && this.mainRender.isReady()) {
            try {
                if (this.surfaceManager.makeCurrent()) {
                    Filter filter = this.filterQueue.take();
                    this.mainRender.setFilterAction(filter.filterAction, filter.position, filter.baseFilterRender);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (this.surfaceManager.isReady() && this.mainRender.isReady()) {
            if (!this.surfaceManager.makeCurrent()) {
                return;
            }
            this.mainRender.updateFrame();
            this.mainRender.drawSource();
            this.surfaceManager.swapBuffer();
        }
        boolean orientation = switch (WhenMappings.$EnumSwitchMapping$0[this.orientationForced.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> this.isPortrait;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean orientationPreview = switch (WhenMappings.$EnumSwitchMapping$0[this.orientationForced.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> this.isPortraitPreview;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (this.surfaceManagerEncoder.isReady() || this.surfaceManagerEncoderRecord.isReady() || this.surfaceManagerPhoto.isReady()) {
            this.mainRender.drawFilters(false);
        }
        if (this.surfaceManagerEncoder.isReady() && this.mainRender.isReady() && !limitFps) {
            w = this.muteVideo ? 0 : this.encoderWidth;
            int n = h = this.muteVideo ? 0 : this.encoderHeight;
            if (this.surfaceManagerEncoder.makeCurrent()) {
                this.mainRender.drawScreenEncoder(w, h, orientation, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, this.streamViewPort);
                this.surfaceManagerEncoder.swapBuffer();
            }
        }
        if (this.surfaceManagerEncoderRecord.isReady() && this.mainRender.isReady() && !limitFps) {
            w = this.muteVideo ? 0 : this.encoderRecordWidth;
            int n = h = this.muteVideo ? 0 : this.encoderRecordHeight;
            if (this.surfaceManagerEncoderRecord.makeCurrent()) {
                this.mainRender.drawScreenEncoder(w, h, orientation, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, this.streamViewPort);
                this.surfaceManagerEncoderRecord.swapBuffer();
            }
        }
        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady() && this.mainRender.isReady() && this.surfaceManagerPhoto.makeCurrent()) {
            this.mainRender.drawScreen(this.encoderWidth, this.encoderHeight, AspectRatioMode.NONE, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, this.streamViewPort);
            TakePhotoCallback takePhotoCallback = this.takePhotoCallback;
            if (takePhotoCallback != null) {
                takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
            }
            this.takePhotoCallback = null;
            this.surfaceManagerPhoto.swapBuffer();
        }
        if (this.surfaceManagerPreview.isReady() && this.mainRender.isReady() && !limitFps) {
            w = this.previewWidth == 0 ? this.encoderWidth : this.previewWidth;
            int n = h = this.previewHeight == 0 ? this.encoderHeight : this.previewHeight;
            if (this.surfaceManager.makeCurrent()) {
                this.mainRender.drawFilters(true);
                this.surfaceManager.swapBuffer();
            }
            if (this.surfaceManagerPreview.makeCurrent()) {
                this.mainRender.drawScreenPreview(w, h, orientationPreview, this.aspectRatioMode, 0, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip, this.previewViewPort);
                this.surfaceManagerPreview.swapBuffer();
            }
        }
        if (!((Map)this.multiPreviewSurfaceManagers).isEmpty() && this.mainRender.isReady() && !limitFps) {
            if (!this.surfaceManagerPreview.isReady() && this.surfaceManager.makeCurrent()) {
                this.mainRender.drawFilters(true);
                this.surfaceManager.swapBuffer();
            }
            Collection<PreviewSurfaceInfo> collection = this.multiPreviewSurfaceManagers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List previewSnapshot = CollectionsKt.toList((Iterable)collection);
            Iterable $this$forEach$iv = previewSnapshot;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreviewSurfaceInfo info = (PreviewSurfaceInfo)element$iv;
                boolean bl = false;
                if (!info.getSurfaceManager().isReady() || !info.getSurfaceManager().makeCurrent()) continue;
                this.mainRender.drawScreenPreview(info.getConfig().getWidth(), info.getConfig().getHeight(), info.getConfig().isPortrait(), info.getConfig().getAspectRatioMode(), 0, info.getConfig().getVerticalFlip(), info.getConfig().getHorizontalFlip(), info.getConfig().getViewPort());
                info.getSurfaceManager().swapBuffer();
            }
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        block1: {
            if (!this.isRunning()) {
                return;
            }
            ExecutorService executorService = this.executor;
            if (executorService == null) break block1;
            executorService.execute(() -> GlStreamInterface.onFrameAvailable$lambda$0(this));
        }
    }

    public final void setOrientationConfig(@NotNull OrientationConfig orientationConfig) {
        Intrinsics.checkNotNullParameter((Object)orientationConfig, (String)"orientationConfig");
        switch (WhenMappings.$EnumSwitchMapping$0[orientationConfig.getForced().ordinal()]) {
            case 1: 
            case 2: {
                this.forceOrientation(orientationConfig.getForced());
                break;
            }
            case 3: {
                int it;
                if (orientationConfig.isPortrait() == null && orientationConfig.getCameraOrientation() == null) {
                    this.forceOrientation(orientationConfig.getForced());
                    break;
                }
                Boolean bl = orientationConfig.isPortrait();
                if (bl != null) {
                    it = bl.booleanValue();
                    boolean bl2 = false;
                    this.setIsPortrait(it != 0);
                }
                Integer n = orientationConfig.getCameraOrientation();
                if (n != null) {
                    it = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.setCameraOrientation(it);
                }
                this.shouldHandleOrientation = false;
                this.orientationForced = orientationConfig.getForced();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void forceOrientation(@NotNull OrientationForced forced) {
        Intrinsics.checkNotNullParameter((Object)forced, (String)"forced");
        switch (WhenMappings.$EnumSwitchMapping$0[forced.ordinal()]) {
            case 1: {
                this.setCameraOrientation(90);
                this.shouldHandleOrientation = false;
                break;
            }
            case 2: {
                this.setCameraOrientation(0);
                this.shouldHandleOrientation = false;
                break;
            }
            case 3: {
                int orientation = CameraHelper.getCameraOrientation((Context)this.context);
                this.setCameraOrientation(orientation == 0 ? 270 : orientation - 90);
                this.shouldHandleOrientation = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.orientationForced = forced;
    }

    public final void attachPreview(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerPreview.release();
            this.surfaceManagerPreview.eglSetup(surface, this.surfaceManager);
        }
    }

    public final void deAttachPreview() {
        this.surfaceManagerPreview.release();
    }

    public final void addMultiPreviewSurface(@NotNull Surface surface, @NotNull MultiPreviewConfig config) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.surfaceManager.isReady()) {
            int w;
            PreviewSurfaceInfo previewSurfaceInfo = this.multiPreviewSurfaceManagers.remove(surface);
            if (previewSurfaceInfo != null && (previewSurfaceInfo = previewSurfaceInfo.getSurfaceManager()) != null) {
                previewSurfaceInfo.release();
            }
            int n = config.getWidth() > 0 ? config.getWidth() : (w = this.previewWidth == 0 ? this.encoderWidth : this.previewWidth);
            int h = config.getHeight() > 0 ? config.getHeight() : (this.previewHeight == 0 ? this.encoderHeight : this.previewHeight);
            SurfaceManager surfaceManager = new SurfaceManager();
            surfaceManager.eglSetup(surface, this.surfaceManager);
            MultiPreviewConfig finalConfig = new MultiPreviewConfig(w, h, config.getHorizontalFlip(), config.getVerticalFlip(), config.getAspectRatioMode(), config.isPortrait(), config.getViewPort());
            ((Map)this.multiPreviewSurfaceManagers).put(surface, new PreviewSurfaceInfo(surfaceManager, finalConfig));
        }
    }

    public final void removeMultiPreviewSurface(@NotNull Surface surface) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            PreviewSurfaceInfo previewSurfaceInfo = this.multiPreviewSurfaceManagers.remove(surface);
            if (previewSurfaceInfo == null || (previewSurfaceInfo = previewSurfaceInfo.getSurfaceManager()) == null) break block0;
            previewSurfaceInfo.release();
        }
    }

    public final void removeAllMultiPreviewSurfaces() {
        Collection<PreviewSurfaceInfo> collection = this.multiPreviewSurfaceManagers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreviewSurfaceInfo info = (PreviewSurfaceInfo)element$iv;
            boolean bl = false;
            info.getSurfaceManager().release();
        }
        this.multiPreviewSurfaceManagers.clear();
    }

    public final boolean updateMultiPreviewConfig(@NotNull Surface surface, @NotNull MultiPreviewConfig config) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        PreviewSurfaceInfo previewSurfaceInfo = this.multiPreviewSurfaceManagers.get(surface);
        if (previewSurfaceInfo == null) {
            return false;
        }
        PreviewSurfaceInfo info = previewSurfaceInfo;
        info.getConfig().setWidth(config.getWidth() > 0 ? config.getWidth() : (this.previewWidth == 0 ? this.encoderWidth : this.previewWidth));
        info.getConfig().setHeight(config.getHeight() > 0 ? config.getHeight() : (this.previewHeight == 0 ? this.encoderHeight : this.previewHeight));
        info.getConfig().setHorizontalFlip(config.getHorizontalFlip());
        info.getConfig().setVerticalFlip(config.getVerticalFlip());
        info.getConfig().setAspectRatioMode(config.getAspectRatioMode());
        info.getConfig().setPortrait(config.isPortrait());
        info.getConfig().setViewPort(config.getViewPort());
        return true;
    }

    public final boolean hasMultiPreviewSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        return this.multiPreviewSurfaceManagers.containsKey(surface);
    }

    public final int getMultiPreviewSurfaceCount() {
        return this.multiPreviewSurfaceManagers.size();
    }

    @Override
    public void setStreamRotation(int orientation) {
        this.streamOrientation = orientation;
    }

    public final void setPreviewResolution(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public final void setIsPortrait(boolean isPortrait) {
        this.setPreviewIsPortrait(isPortrait);
        this.setStreamIsPortrait(isPortrait);
    }

    public final void setPreviewIsPortrait(boolean isPortrait) {
        this.isPortraitPreview = isPortrait;
    }

    public final void setStreamIsPortrait(boolean isPortrait) {
        this.isPortrait = isPortrait;
    }

    public final void setCameraOrientation(int orientation) {
        this.mainRender.setCameraRotation(orientation);
    }

    @Override
    public void setFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.mainRender.filtersCount();
    }

    @Override
    public void setRotation(int rotation) {
        this.setCameraOrientation(rotation);
    }

    @Override
    public void forceFpsLimit(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public void setFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    public final void setAspectRatioMode(@NotNull AspectRatioMode aspectRatioMode) {
        Intrinsics.checkNotNullParameter((Object)aspectRatioMode, (String)"aspectRatioMode");
        this.aspectRatioMode = aspectRatioMode;
    }

    public final void setPreviewViewPort(@Nullable ViewPort viewPort) {
        this.previewViewPort = viewPort;
    }

    public final void setStreamViewPort(@Nullable ViewPort viewPort) {
        this.streamViewPort = viewPort;
    }

    private static final void sensorRotationManager$lambda$0(GlStreamInterface this$0, int orientation, boolean isPortrait) {
        if (this$0.autoHandleOrientation && this$0.shouldHandleOrientation) {
            this$0.setCameraOrientation(orientation);
            this$0.setIsPortrait(isPortrait);
        }
    }

    private static final Unit start$lambda$0(GlStreamInterface this$0, int $width, int $height) {
        this$0.surfaceManager.makeCurrent();
        this$0.mainRender.initGl(this$0.context, $width, $height, $width, $height);
        this$0.running.set(true);
        this$0.mainRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this$0);
        this$0.forceRender.start((Function0<Unit>)((Function0)() -> GlStreamInterface.start$lambda$0$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$0$0(GlStreamInterface this$0) {
        block0: {
            ExecutorService executorService = this$0.executor;
            if (executorService == null) break block0;
            executorService.execute(() -> GlStreamInterface.start$lambda$0$0$0(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final void start$lambda$0$0$0(GlStreamInterface this$0) {
        try {
            this$0.draw(true);
        }
        catch (RuntimeException e) {
            RenderErrorCallback renderErrorCallback = this$0.renderErrorCallback;
            if (renderErrorCallback != null) {
                renderErrorCallback.onRenderError(e);
            }
            throw e;
        }
    }

    private static final void onFrameAvailable$lambda$0(GlStreamInterface this$0) {
        try {
            this$0.draw(false);
        }
        catch (RuntimeException e) {
            RenderErrorCallback renderErrorCallback = this$0.renderErrorCallback;
            if (renderErrorCallback != null) {
                renderErrorCallback.onRenderError(e);
            }
            throw e;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrientationForced.values().length];
            try {
                nArray[OrientationForced.PORTRAIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrientationForced.LANDSCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrientationForced.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

