/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.AudioUtils;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ExtensionsKt;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class AacMuxerRecordController
extends BaseRecordController {
    private OutputStream outputStream;
    private int sampleRate = -1;
    private int channels = -1;

    @Override
    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener, RecordController.RecordTracks tracks) throws IOException {
        this.tracks = RecordController.RecordTracks.AUDIO;
        if (tracks != RecordController.RecordTracks.AUDIO) {
            throw new IllegalArgumentException("This record controller only support record audio");
        }
        this.outputStream = new FileOutputStream(path);
        this.start(listener);
    }

    @Override
    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener, RecordController.RecordTracks tracks) throws IOException {
        this.tracks = RecordController.RecordTracks.AUDIO;
        if (tracks != RecordController.RecordTracks.AUDIO) {
            throw new IllegalArgumentException("This record controller only support record audio");
        }
        this.outputStream = new FileOutputStream(fd);
        this.start(listener);
    }

    @RequiresApi(api=18)
    private void start(@Nullable RecordController.Listener listener) throws IOException {
        if (this.audioCodec != AudioCodec.AAC) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        if (this.sampleRate != -1 && this.channels != -1) {
            this.init();
        }
    }

    @Override
    @RequiresApi(api=18)
    public void stopRecord() {
        this.status = RecordController.Status.STOPPED;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.sampleRate = -1;
        this.channels = -1;
        this.startTs = 0L;
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.outputStream = null;
        }
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @Override
    @RequiresApi(api=18)
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
    }

    @Override
    @RequiresApi(api=18)
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == RecordController.Status.RECORDING) {
            this.write(audioBuffer.duplicate(), this.updateFormat(audioInfo));
        }
    }

    @Override
    public void setVideoFormat(MediaFormat videoFormat) {
    }

    @Override
    public void setAudioFormat(MediaFormat audioFormat) {
        this.sampleRate = audioFormat.getInteger("sample-rate");
        this.channels = audioFormat.getInteger("channel-count");
        if (this.status == RecordController.Status.STARTED && Build.VERSION.SDK_INT >= 18) {
            this.init();
        }
    }

    @Override
    public void resetFormats() {
    }

    @RequiresApi(api=18)
    private void init() {
        this.status = RecordController.Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @RequiresApi(api=18)
    private void write(ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        block4: {
            try {
                if ((info.flags & 2) != 2) {
                    byte[] header = AudioUtils.INSTANCE.createAdtsHeader(2, info.size - info.offset, this.sampleRate, this.channels).array();
                    this.outputStream.write(header);
                    byte[] data = new byte[byteBuffer.remaining()];
                    byteBuffer.get(data);
                    this.outputStream.write(data);
                    if (this.bitrateManager != null) {
                        this.bitrateManager.calculateBitrate((long)info.size * 8L, ExtensionsKt.getSuspendContext());
                    }
                }
            }
            catch (Exception e) {
                if (this.listener == null) break block4;
                this.listener.onError(e);
            }
        }
    }
}

