/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.TimestampMode;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.GlStreamInterface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public abstract class DisplayBase {
    private GlInterface glInterface;
    private MediaProjection mediaProjection;
    private final MediaProjectionManager mediaProjectionManager;
    protected VideoEncoder videoEncoder;
    private final MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private VirtualDisplay virtualDisplay;
    private int dpi = 320;
    private int resultCode = -1;
    private Intent data;
    private MediaProjection.Callback mediaProjectionCallback = new MediaProjection.Callback(){};
    protected BaseRecordController recordController;
    private final FpsListener fpsListener = new FpsListener();
    private boolean videoInitialized = false;
    private boolean audioInitialized = false;
    private final GetMicrophoneData getMicrophoneData = frame -> this.audioEncoder.inputPCMData(frame);
    private final GetAudioData getAudioData = new GetAudioData(){

        public void getAudioData(@NonNull ByteBuffer audioBuffer, @NonNull MediaCodec.BufferInfo info) {
            DisplayBase.this.recordController.recordAudio(audioBuffer, info);
            if (DisplayBase.this.streaming) {
                DisplayBase.this.getAudioDataImp(audioBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            DisplayBase.this.recordController.setAudioFormat(mediaFormat);
        }
    };
    private final GetVideoData getVideoData = new GetVideoData(){

        public void onVideoInfo(@NonNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
            DisplayBase.this.onVideoInfoImp(sps.duplicate(), pps != null ? pps.duplicate() : null, vps != null ? vps.duplicate() : null);
        }

        public void getVideoData(@NonNull ByteBuffer videoBuffer, @NonNull MediaCodec.BufferInfo info) {
            DisplayBase.this.fpsListener.calculateFps();
            DisplayBase.this.recordController.recordVideo(videoBuffer, info);
            if (DisplayBase.this.streaming) {
                DisplayBase.this.getVideoDataImp(videoBuffer, info);
            }
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            DisplayBase.this.recordController.setVideoFormat(mediaFormat, !DisplayBase.this.audioInitialized);
        }
    };

    public DisplayBase(Context context, boolean useOpengl) {
        if (useOpengl) {
            this.glInterface = new GlStreamInterface(context);
        }
        this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
        this.videoEncoder = new VideoEncoder(this.getVideoData);
        this.audioEncoder = new AudioEncoder(this.getAudioData);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setTimestampMode(TimestampMode timestampModeVideo, TimestampMode timestampModeAudio) {
        this.videoEncoder.setTimestampMode(timestampModeVideo);
        this.audioEncoder.setTimestampMode(timestampModeAudio);
    }

    public void setEncoderErrorCallback(EncoderErrorCallback encoderErrorCallback) {
        this.videoEncoder.setEncoderErrorCallback(encoderErrorCallback);
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation, int dpi, int profile, int level, int iFrameInterval) {
        this.dpi = dpi;
        this.videoInitialized = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level);
        if (this.glInterface != null) {
            int w = width;
            int h = height;
            boolean isPortrait = false;
            if (rotation == 90 || rotation == 270) {
                h = width;
                w = height;
                isPortrait = true;
            }
            this.glInterface.setEncoderSize(w, h);
            GlInterface glInterface = this.glInterface;
            if (glInterface instanceof GlStreamInterface) {
                GlStreamInterface glStreamInterface = (GlStreamInterface)glInterface;
                glStreamInterface.setPreviewResolution(w, h);
                glStreamInterface.setIsPortrait(isPortrait);
            }
        }
        return this.videoInitialized;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation, int dpi) {
        return this.prepareVideo(width, height, fps, bitrate, rotation, dpi, -1, -1, 2);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        return this.prepareVideo(width, height, 30, bitrate, 0, 320);
    }

    protected abstract void onAudioInfoImp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.onAudioInfoImp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    @RequiresApi(api=29)
    public boolean prepareInternalAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (this.mediaProjection == null) {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(this.resultCode, this.data);
        }
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, null);
        AudioPlaybackCaptureConfiguration config = new AudioPlaybackCaptureConfiguration.Builder(this.mediaProjection).addMatchingUsage(1).addMatchingUsage(14).addMatchingUsage(0).build();
        if (!this.microphoneManager.createInternalMicrophone(config, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.onAudioInfoImp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
        return this.audioInitialized;
    }

    @RequiresApi(api=29)
    public boolean prepareInternalAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareInternalAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        return this.prepareVideo(640, 480, 30, 1228800, 0, 320);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    @RequiresApi(api=29)
    public boolean prepareInternalAudio() {
        return this.prepareInternalAudio(65536, 32000, true);
    }

    public void forceCodecType(CodecUtil.CodecType codecTypeVideo, CodecUtil.CodecType codecTypeAudio) {
        this.videoEncoder.forceCodecType(codecTypeVideo);
        this.audioEncoder.forceCodecType(codecTypeAudio);
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders(this.resultCode, this.data, this.mediaProjectionCallback);
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders(this.resultCode, this.data, this.mediaProjectionCallback);
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamImp(String var1);

    public Intent sendIntent() {
        return this.mediaProjectionManager.createScreenCaptureIntent();
    }

    public void setIntentResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.data = data;
    }

    public void setMediaProjectionCallback(MediaProjection.Callback mediaProjectionCallback) {
        if (this.videoInitialized || this.audioInitialized) {
            throw new RuntimeException("You need to set MediaProjection callback before prepareVideo and prepareAudio");
        }
        this.mediaProjectionCallback = mediaProjectionCallback != null ? mediaProjectionCallback : new MediaProjection.Callback(){};
    }

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders(this.resultCode, this.data, this.mediaProjectionCallback);
        } else {
            this.requestKeyFrame();
        }
        this.startStreamImp(url);
    }

    private void startEncoders(int resultCode, Intent data, MediaProjection.Callback mediaProjectionCallback) {
        Surface surface;
        if (data == null) {
            throw new RuntimeException("You need send intent data before startRecord or startStream");
        }
        long startTs = TimeUtils.getCurrentTimeMicro();
        this.videoEncoder.start(startTs);
        if (this.audioInitialized) {
            this.audioEncoder.start(startTs);
        }
        if (this.glInterface != null) {
            this.glInterface.start();
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        }
        Surface surface2 = surface = this.glInterface != null ? this.glInterface.getSurface() : this.videoEncoder.getInputSurface();
        if (this.mediaProjection == null) {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(resultCode, data);
        }
        this.mediaProjection.registerCallback(mediaProjectionCallback, null);
        VirtualDisplay.Callback callback = new VirtualDisplay.Callback(){};
        this.virtualDisplay = this.glInterface != null && this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270 ? this.mediaProjection.createVirtualDisplay("Stream Display", this.videoEncoder.getHeight(), this.videoEncoder.getWidth(), this.dpi, 0, surface, callback, null) : this.mediaProjection.createVirtualDisplay("Stream Display", this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.dpi, 0, surface, callback, null);
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            this.videoEncoder.requestKeyframe();
        }
    }

    protected abstract void stopStreamImp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamImp();
        }
        if (!this.recordController.isRecording()) {
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            if (this.mediaProjection != null) {
                this.mediaProjection.stop();
                this.mediaProjection = null;
            }
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            if (this.virtualDisplay != null) {
                this.virtualDisplay.release();
            }
            this.videoEncoder.stop();
            this.audioEncoder.stop();
            this.data = null;
            this.recordController.resetFormats();
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.videoEncoder.getFps() : 0;
        this.videoEncoder.setForceFps(fps);
        if (this.glInterface != null) {
            this.glInterface.forceFpsLimit(fps);
        }
    }

    public boolean resetVideoEncoder() {
        if (this.glInterface != null) {
            this.glInterface.removeMediaCodecSurface();
            boolean result = this.videoEncoder.reset();
            if (!result) {
                return false;
            }
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        } else {
            boolean result = this.videoEncoder.reset();
            if (!result) {
                return false;
            }
            if (this.virtualDisplay != null) {
                this.virtualDisplay.setSurface(this.videoEncoder.getInputSurface());
            }
        }
        return true;
    }

    public boolean resetAudioEncoder() {
        return this.audioEncoder.reset();
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    protected abstract void getAudioDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    protected abstract void onVideoInfoImp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract void getVideoDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract StreamBaseClient getStreamClient();

    public void setVideoCodec(VideoCodec codec) {
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case VideoCodec.H264 -> "video/avc";
            case VideoCodec.H265 -> "video/hevc";
            case VideoCodec.AV1 -> "video/av01";
        };
        this.videoEncoder.setType(type);
    }

    public void setAudioCodec(AudioCodec codec) {
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case AudioCodec.G711 -> "audio/g711-alaw";
            case AudioCodec.AAC -> "audio/mp4a-latm";
            case AudioCodec.OPUS -> "audio/opus";
        };
        this.audioEncoder.setType(type);
    }

    protected abstract void setVideoCodecImp(VideoCodec var1);

    protected abstract void setAudioCodecImp(AudioCodec var1);
}

