/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.Frame;
import com.pedro.encoder.TimestampMode;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.sources.audio.AudioSource;
import com.pedro.encoder.input.sources.audio.NoAudioSource;
import com.pedro.encoder.input.sources.video.NoVideoSource;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.StreamBase;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlStreamInterface;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e5\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u000b\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJp\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u0002002\b\b\u0002\u00103\u001a\u0002002\b\b\u0002\u00104\u001a\u0002002\b\b\u0002\u00105\u001a\u0002002\b\b\u0002\u00106\u001a\u0002002\b\b\u0002\u00107\u001a\u0002002\b\b\u0002\u00108\u001a\u0002002\b\b\u0002\u00109\u001a\u0002002\b\b\u0002\u0010:\u001a\u000200H\u0007J4\u0010;\u001a\u00020\"2\u0006\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020\"2\u0006\u00102\u001a\u0002002\b\b\u0002\u0010>\u001a\u00020\"2\b\b\u0002\u0010?\u001a\u00020\"H\u0007J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020AJ\u000e\u0010E\u001a\u00020A2\u0006\u00102\u001a\u000200J\u000e\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020\"J\u0016\u0010H\u001a\u00020A2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JJ\u0006\u0010L\u001a\u00020\"J\u0016\u0010M\u001a\u00020A2\u0006\u0010N\u001a\u00020C2\u0006\u0010O\u001a\u00020PJ\u0006\u0010Q\u001a\u00020\"J\u0006\u0010R\u001a\u00020AJ\u0006\u0010S\u001a\u00020AJ\u001a\u0010T\u001a\u00020A2\u0006\u0010U\u001a\u00020V2\b\b\u0002\u0010W\u001a\u00020\"H\u0007J\u001a\u0010T\u001a\u00020A2\u0006\u0010X\u001a\u00020Y2\b\b\u0002\u0010W\u001a\u00020\"H\u0007J\u001e\u0010T\u001a\u00020A2\u0006\u0010Z\u001a\u00020[2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J\u001e\u0010T\u001a\u00020A2\u0006\u0010\\\u001a\u00020]2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J\u0006\u0010^\u001a\u00020AJ\u000e\u0010_\u001a\u00020A2\u0006\u0010`\u001a\u00020\u0005J\u000e\u0010a\u001a\u00020A2\u0006\u0010`\u001a\u00020\u0007J\u0016\u0010b\u001a\u00020A2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020dJ\u0010\u0010f\u001a\u00020A2\b\u0010g\u001a\u0004\u0018\u00010hJ\u0010\u0010i\u001a\u00020A2\b\u0010j\u001a\u0004\u0018\u00010kJ\u000e\u0010l\u001a\u00020A2\u0006\u0010m\u001a\u000200J\u0006\u0010n\u001a\u00020\u001cJ\u000e\u0010o\u001a\u00020A2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010p\u001a\u00020[J\b\u0010q\u001a\u00020rH\u0004J\b\u0010s\u001a\u000200H\u0004J\b\u0010t\u001a\u00020AH\u0002J\b\u0010u\u001a\u00020AH\u0002J\u0006\u0010v\u001a\u00020AJ\u0006\u0010w\u001a\u00020\"J\u0006\u0010x\u001a\u00020\"J\b\u0010y\u001a\u00020\"H\u0002J\u0018\u0010\u007f\u001a\u00020A2\u0006\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020\"H$J\u0011\u0010\u0080\u0001\u001a\u00020A2\u0006\u0010B\u001a\u00020CH$J\t\u0010\u0081\u0001\u001a\u00020AH$J+\u0010\u0082\u0001\u001a\u00020A2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0084\u00012\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0084\u0001H$J\u001d\u0010\u0087\u0001\u001a\u00020A2\b\u0010\u0088\u0001\u001a\u00030\u0084\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H$J\u001d\u0010\u008b\u0001\u001a\u00020A2\b\u0010\u008c\u0001\u001a\u00030\u0084\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H$J\n\u0010\u008d\u0001\u001a\u00030\u008e\u0001H&J\u0011\u0010\u008f\u0001\u001a\u00020A2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001J\u0011\u0010\u0092\u0001\u001a\u00020A2\b\u0010\u0090\u0001\u001a\u00030\u0093\u0001J\u0013\u0010\u0094\u0001\u001a\u00020A2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H$J\u0013\u0010\u0095\u0001\u001a\u00020A2\b\u0010\u0090\u0001\u001a\u00030\u0093\u0001H$R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0014\u0010\u0010R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0011\u0010&\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u001e\u0010'\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001e\u0010*\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010z\u001a\u00020{X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010|\u001a\u00020}X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020}X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0096\u0001"}, d2={"Lcom/pedro/library/base/StreamBase;", "", "context", "Landroid/content/Context;", "vSource", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "aSource", "Lcom/pedro/encoder/input/sources/audio/AudioSource;", "<init>", "(Landroid/content/Context;Lcom/pedro/encoder/input/sources/video/VideoSource;Lcom/pedro/encoder/input/sources/audio/AudioSource;)V", "getMicrophoneData", "com/pedro/library/base/StreamBase$getMicrophoneData$1", "Lcom/pedro/library/base/StreamBase$getMicrophoneData$1;", "videoEncoder", "Lcom/pedro/encoder/video/VideoEncoder;", "getVideoEncoder", "()Lcom/pedro/encoder/video/VideoEncoder;", "videoEncoder$delegate", "Lkotlin/Lazy;", "videoEncoderRecord", "getVideoEncoderRecord", "videoEncoderRecord$delegate", "audioEncoder", "Lcom/pedro/encoder/audio/AudioEncoder;", "getAudioEncoder", "()Lcom/pedro/encoder/audio/AudioEncoder;", "audioEncoder$delegate", "glInterface", "Lcom/pedro/library/view/GlStreamInterface;", "recordController", "Lcom/pedro/library/base/recording/BaseRecordController;", "fpsListener", "Lcom/pedro/library/util/FpsListener;", "value", "", "isStreaming", "()Z", "isOnPreview", "isRecording", "videoSource", "getVideoSource", "()Lcom/pedro/encoder/input/sources/video/VideoSource;", "audioSource", "getAudioSource", "()Lcom/pedro/encoder/input/sources/audio/AudioSource;", "differentRecordResolution", "prepareVideo", "width", "", "height", "bitrate", "fps", "iFrameInterval", "rotation", "profile", "level", "recordWidth", "recordHeight", "recordBitrate", "prepareAudio", "sampleRate", "isStereo", "echoCanceler", "noiseSuppressor", "startStream", "", "endPoint", "", "requestKeyframe", "setVideoBitrateOnFly", "forceFpsLimit", "enabled", "forceCodecType", "codecTypeVideo", "Lcom/pedro/encoder/utils/CodecUtil$CodecType;", "codecTypeAudio", "stopStream", "startRecord", "path", "listener", "Lcom/pedro/library/base/recording/RecordController$Listener;", "stopRecord", "pauseRecord", "resumeRecord", "startPreview", "textureView", "Landroid/view/TextureView;", "autoHandle", "surfaceView", "Landroid/view/SurfaceView;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "surface", "Landroid/view/Surface;", "stopPreview", "changeVideoSource", "source", "changeAudioSource", "setTimestampMode", "timestampModeVideo", "Lcom/pedro/encoder/TimestampMode;", "timestampModeAudio", "setEncoderErrorCallback", "encoderErrorCallback", "Lcom/pedro/encoder/EncoderErrorCallback;", "setFpsListener", "callback", "Lcom/pedro/library/util/FpsListener$Callback;", "setOrientation", "orientation", "getGlInterface", "setRecordController", "getSurfaceTexture", "getVideoResolution", "Landroid/util/Size;", "getVideoFps", "startSources", "stopSources", "release", "resetVideoEncoder", "resetAudioEncoder", "prepareEncoders", "getAacData", "Lcom/pedro/encoder/audio/GetAudioData;", "getVideoData", "Lcom/pedro/encoder/video/GetVideoData;", "getVideoDataRecord", "onAudioInfoImp", "startStreamImp", "stopStreamImp", "onVideoInfoImp", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "getVideoDataImp", "videoBuffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "getAudioDataImp", "audioBuffer", "getStreamClient", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "setVideoCodec", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "setAudioCodecImp", "library_release"})
@RequiresApi(value=21)
public abstract class StreamBase {
    @NotNull
    private final getMicrophoneData.1 getMicrophoneData;
    @NotNull
    private final Lazy videoEncoder$delegate;
    @NotNull
    private final Lazy videoEncoderRecord$delegate;
    @NotNull
    private final Lazy audioEncoder$delegate;
    @NotNull
    private final GlStreamInterface glInterface;
    @NotNull
    private BaseRecordController recordController;
    @NotNull
    private final FpsListener fpsListener;
    private boolean isStreaming;
    private boolean isOnPreview;
    @NotNull
    private VideoSource videoSource;
    @NotNull
    private AudioSource audioSource;
    private boolean differentRecordResolution;
    @NotNull
    private final GetAudioData getAacData;
    @NotNull
    private final GetVideoData getVideoData;
    @NotNull
    private final GetVideoData getVideoDataRecord;

    public StreamBase(@NotNull Context context, @NotNull VideoSource vSource, @NotNull AudioSource aSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vSource, (String)"vSource");
        Intrinsics.checkNotNullParameter((Object)aSource, (String)"aSource");
        this.getMicrophoneData = new GetMicrophoneData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputPCMData(Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                StreamBase.access$getAudioEncoder(this.this$0).inputPCMData(frame);
            }
        };
        this.videoEncoder$delegate = LazyKt.lazy(() -> StreamBase.videoEncoder_delegate$lambda$0(this));
        this.videoEncoderRecord$delegate = LazyKt.lazy(() -> StreamBase.videoEncoderRecord_delegate$lambda$1(this));
        this.audioEncoder$delegate = LazyKt.lazy(() -> StreamBase.audioEncoder_delegate$lambda$2(this));
        this.glInterface = new GlStreamInterface(context);
        this.recordController = new AndroidMuxerRecordController();
        this.fpsListener = new FpsListener();
        this.videoSource = vSource;
        this.audioSource = aSource;
        this.getAacData = new GetAudioData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void getAudioData(ByteBuffer audioBuffer, MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.this$0.getAudioDataImp(audioBuffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordAudio(audioBuffer, info);
            }

            public void onAudioFormat(MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                boolean isOnlyAudio = this.this$0.getVideoSource() instanceof NoVideoSource;
                StreamBase.access$getRecordController$p(this.this$0).setAudioFormat(mediaFormat, isOnlyAudio);
            }
        };
        this.getVideoData = new GetVideoData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVideoInfo(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
                Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
                ByteBuffer byteBuffer = sps.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
                ByteBuffer byteBuffer2 = pps;
                ByteBuffer byteBuffer3 = vps;
                this.this$0.onVideoInfoImp(byteBuffer, byteBuffer2 != null ? byteBuffer2.duplicate() : null, byteBuffer3 != null ? byteBuffer3.duplicate() : null);
            }

            public void getVideoData(ByteBuffer videoBuffer, MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                StreamBase.access$getFpsListener$p(this.this$0).calculateFps();
                this.this$0.getVideoDataImp(videoBuffer, info);
                if (!StreamBase.access$getDifferentRecordResolution$p(this.this$0)) {
                    StreamBase.access$getRecordController$p(this.this$0).recordVideo(videoBuffer, info);
                }
            }

            public void onVideoFormat(MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                if (!StreamBase.access$getDifferentRecordResolution$p(this.this$0)) {
                    boolean isOnlyVideo = this.this$0.getAudioSource() instanceof NoAudioSource;
                    StreamBase.access$getRecordController$p(this.this$0).setVideoFormat(mediaFormat, isOnlyVideo);
                }
            }
        };
        this.getVideoDataRecord = new GetVideoData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVideoInfo(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
                Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            }

            public void getVideoData(ByteBuffer videoBuffer, MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                StreamBase.access$getRecordController$p(this.this$0).recordVideo(videoBuffer, info);
            }

            public void onVideoFormat(MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                boolean isOnlyVideo = this.this$0.getAudioSource() instanceof NoAudioSource;
                StreamBase.access$getRecordController$p(this.this$0).setVideoFormat(mediaFormat, isOnlyVideo);
            }
        };
    }

    private final VideoEncoder getVideoEncoder() {
        Lazy lazy = this.videoEncoder$delegate;
        return (VideoEncoder)lazy.getValue();
    }

    private final VideoEncoder getVideoEncoderRecord() {
        Lazy lazy = this.videoEncoderRecord$delegate;
        return (VideoEncoder)lazy.getValue();
    }

    private final AudioEncoder getAudioEncoder() {
        Lazy lazy = this.audioEncoder$delegate;
        return (AudioEncoder)lazy.getValue();
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final boolean isOnPreview() {
        return this.isOnPreview;
    }

    public final boolean isRecording() {
        return this.recordController.isRunning();
    }

    @NotNull
    public final VideoSource getVideoSource() {
        return this.videoSource;
    }

    @NotNull
    public final AudioSource getAudioSource() {
        return this.audioSource;
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile, int level, int recordWidth, int recordHeight, int recordBitrate) throws IllegalArgumentException {
        boolean videoResult;
        if (this.isStreaming || this.isRecording() || this.isOnPreview) {
            throw new IllegalStateException("Stream, record and preview must be stopped before prepareVideo");
        }
        this.differentRecordResolution = false;
        if (recordWidth > 0 && recordHeight > 0) {
            if (!((double)recordWidth / (double)recordHeight == (double)width / (double)height)) {
                throw new IllegalArgumentException("The aspect ratio of record and stream resolution must be the same");
            }
            this.differentRecordResolution = true;
        }
        if (videoResult = this.videoSource.init(Math.max(width, recordWidth), Math.max(height, recordHeight), fps, rotation)) {
            boolean result;
            if (this.differentRecordResolution) {
                switch (rotation) {
                    case 90: 
                    case 270: {
                        this.glInterface.setEncoderRecordSize(recordHeight, recordWidth);
                        break;
                    }
                    default: {
                        this.glInterface.setEncoderRecordSize(recordWidth, recordHeight);
                    }
                }
            }
            switch (rotation) {
                case 90: 
                case 270: {
                    this.glInterface.setEncoderSize(height, width);
                    break;
                }
                default: {
                    this.glInterface.setEncoderSize(width, height);
                }
            }
            boolean isPortrait = rotation == 90 || rotation == 270;
            this.glInterface.setIsPortrait(isPortrait);
            this.glInterface.setCameraOrientation(rotation == 0 ? 270 : rotation - 90);
            this.glInterface.forceOrientation(this.videoSource.getOrientationConfig());
            if (this.differentRecordResolution && !(result = this.getVideoEncoderRecord().prepareVideoEncoder(recordWidth, recordHeight, fps, recordBitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level))) {
                return false;
            }
            result = this.getVideoEncoder().prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level);
            this.forceFpsLimit(true);
            return result;
        }
        return false;
    }

    public static /* synthetic */ boolean prepareVideo$default(StreamBase streamBase, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object) throws IllegalArgumentException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareVideo");
        }
        if ((n12 & 8) != 0) {
            n4 = 30;
        }
        if ((n12 & 0x10) != 0) {
            n5 = 2;
        }
        if ((n12 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n12 & 0x40) != 0) {
            n7 = -1;
        }
        if ((n12 & 0x80) != 0) {
            n8 = -1;
        }
        if ((n12 & 0x100) != 0) {
            n9 = 0;
        }
        if ((n12 & 0x200) != 0) {
            n10 = 0;
        }
        if ((n12 & 0x400) != 0) {
            n11 = n3;
        }
        return streamBase.prepareVideo(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler, boolean noiseSuppressor) throws IllegalArgumentException {
        if (this.isStreaming || this.isRecording()) {
            throw new IllegalStateException("Stream and record must be stopped before prepareAudio");
        }
        boolean audioResult = this.audioSource.init(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (audioResult) {
            this.onAudioInfoImp(sampleRate, isStereo);
            return this.getAudioEncoder().prepareAudioEncoder(bitrate, sampleRate, isStereo);
        }
        return false;
    }

    public static /* synthetic */ boolean prepareAudio$default(StreamBase streamBase, int n, boolean bl, int n2, boolean bl2, boolean bl3, int n3, Object object) throws IllegalArgumentException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareAudio");
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        return streamBase.prepareAudio(n, bl, n2, bl2, bl3);
    }

    public final void startStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        if (this.isStreaming) {
            throw new IllegalStateException("Stream already started, stopStream before startStream again");
        }
        this.isStreaming = true;
        this.startStreamImp(endPoint);
        if (!this.isRecording()) {
            this.startSources();
        } else {
            this.requestKeyframe();
        }
    }

    public final void requestKeyframe() {
        if (this.getVideoEncoder().isRunning()) {
            this.getVideoEncoder().requestKeyframe();
        }
        if (this.getVideoEncoderRecord().isRunning()) {
            this.getVideoEncoderRecord().requestKeyframe();
        }
    }

    public final void setVideoBitrateOnFly(int bitrate) {
        this.getVideoEncoder().setVideoBitrateOnFly(bitrate);
    }

    public final void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.getVideoEncoder().getFps() : 0;
        this.getVideoEncoder().setForceFps(fps);
        this.getVideoEncoderRecord().setForceFps(fps);
        this.glInterface.forceFpsLimit(fps);
    }

    public final void forceCodecType(@NotNull CodecUtil.CodecType codecTypeVideo, @NotNull CodecUtil.CodecType codecTypeAudio) {
        Intrinsics.checkNotNullParameter((Object)codecTypeVideo, (String)"codecTypeVideo");
        Intrinsics.checkNotNullParameter((Object)codecTypeAudio, (String)"codecTypeAudio");
        this.getVideoEncoder().forceCodecType(codecTypeVideo);
        this.getVideoEncoderRecord().forceCodecType(codecTypeVideo);
        this.getAudioEncoder().forceCodecType(codecTypeAudio);
    }

    public final boolean stopStream() {
        this.isStreaming = false;
        this.stopStreamImp();
        if (!this.isRecording()) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void startRecord(@NotNull String path, @NotNull RecordController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.isRecording()) {
            throw new IllegalStateException("Record already started, stopRecord before startRecord again");
        }
        this.recordController.startRecord(path, listener);
        if (!this.isStreaming) {
            this.startSources();
        } else {
            this.getVideoEncoder().requestKeyframe();
            this.getVideoEncoderRecord().requestKeyframe();
        }
    }

    public final boolean stopRecord() {
        this.recordController.stopRecord();
        if (!this.isStreaming) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public final void resumeRecord() {
        this.recordController.resumeRecord();
    }

    @JvmOverloads
    public final void startPreview(@NotNull TextureView textureView, boolean autoHandle) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        if (autoHandle) {
            textureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(this, textureView){
                final /* synthetic */ StreamBase this$0;
                final /* synthetic */ TextureView $textureView;
                {
                    this.this$0 = $receiver;
                    this.$textureView = $textureView;
                }

                public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                    if (!this.this$0.isOnPreview()) {
                        StreamBase.startPreview$default(this.this$0, this.$textureView, false, 2, null);
                    }
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                    this.this$0.getGlInterface().setPreviewResolution(width, height);
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
                    Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                    if (this.this$0.isOnPreview()) {
                        this.this$0.stopPreview();
                    }
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture texture) {
                    Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                }
            });
            if (textureView.isAvailable() && !this.isOnPreview) {
                StreamBase.startPreview$default(this, textureView, false, 2, null);
            }
        } else {
            this.startPreview(new Surface(textureView.getSurfaceTexture()), textureView.getWidth(), textureView.getHeight());
        }
    }

    public static /* synthetic */ void startPreview$default(StreamBase streamBase, TextureView textureView, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startPreview");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        streamBase.startPreview(textureView, bl);
    }

    @JvmOverloads
    public final void startPreview(@NotNull SurfaceView surfaceView, boolean autoHandle) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        if (autoHandle) {
            surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(this, surfaceView){
                final /* synthetic */ StreamBase this$0;
                final /* synthetic */ SurfaceView $surfaceView;
                {
                    this.this$0 = $receiver;
                    this.$surfaceView = $surfaceView;
                }

                public void surfaceCreated(SurfaceHolder holder) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    if (!this.this$0.isOnPreview()) {
                        StreamBase.startPreview$default(this.this$0, this.$surfaceView, false, 2, null);
                    }
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    this.this$0.getGlInterface().setPreviewResolution(width, height);
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    if (this.this$0.isOnPreview()) {
                        this.this$0.stopPreview();
                    }
                }
            });
            if (surfaceView.getHolder().getSurface().isValid() && !this.isOnPreview) {
                StreamBase.startPreview$default(this, surfaceView, false, 2, null);
            }
        } else {
            Surface surface = surfaceView.getHolder().getSurface();
            Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
            this.startPreview(surface, surfaceView.getWidth(), surfaceView.getHeight());
        }
    }

    public static /* synthetic */ void startPreview$default(StreamBase streamBase, SurfaceView surfaceView, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startPreview");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        streamBase.startPreview(surfaceView, bl);
    }

    public final void startPreview(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.startPreview(new Surface(surfaceTexture), width, height);
    }

    public final void startPreview(@NotNull Surface surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (!surface.isValid()) {
            throw new IllegalArgumentException("Make sure the Surface is valid");
        }
        if (this.isOnPreview) {
            throw new IllegalStateException("Preview already started, stopPreview before startPreview again");
        }
        this.isOnPreview = true;
        if (!this.glInterface.isRunning()) {
            this.glInterface.start();
        }
        if (!this.videoSource.isRunning()) {
            this.videoSource.start(this.glInterface.getSurfaceTexture());
        }
        this.glInterface.attachPreview(surface);
        this.glInterface.setPreviewResolution(width, height);
    }

    public final void stopPreview() {
        this.isOnPreview = false;
        if (!this.isStreaming && !this.isRecording()) {
            this.videoSource.stop();
        }
        this.glInterface.deAttachPreview();
        if (!this.isStreaming && !this.isRecording()) {
            this.glInterface.stop();
        }
    }

    public final void changeVideoSource(@NotNull VideoSource source) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean wasRunning = this.videoSource.isRunning();
        boolean wasCreated = this.videoSource.getCreated();
        if (wasCreated) {
            int width = this.getVideoEncoder().getWidth();
            int height = this.getVideoEncoder().getHeight();
            if (this.differentRecordResolution) {
                width = Math.max(width, this.getVideoEncoderRecord().getWidth());
                height = Math.max(height, this.getVideoEncoderRecord().getHeight());
            }
            source.init(width, height, this.getVideoEncoder().getFps(), this.getVideoEncoder().getRotation());
        }
        this.videoSource.stop();
        this.videoSource.release();
        if (wasRunning) {
            source.start(this.glInterface.getSurfaceTexture());
        }
        this.glInterface.forceOrientation(source.getOrientationConfig());
        this.videoSource = source;
    }

    public final void changeAudioSource(@NotNull AudioSource source) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean wasRunning = this.audioSource.isRunning();
        boolean wasCreated = this.audioSource.getCreated();
        if (wasCreated) {
            source.init(this.audioSource.getSampleRate(), this.audioSource.isStereo(), this.audioSource.getEchoCanceler(), this.audioSource.getNoiseSuppressor());
        }
        this.audioSource.stop();
        this.audioSource.release();
        if (wasRunning) {
            source.start((GetMicrophoneData)this.getMicrophoneData);
        }
        this.audioSource = source;
    }

    public final void setTimestampMode(@NotNull TimestampMode timestampModeVideo, @NotNull TimestampMode timestampModeAudio) {
        Intrinsics.checkNotNullParameter((Object)timestampModeVideo, (String)"timestampModeVideo");
        Intrinsics.checkNotNullParameter((Object)timestampModeAudio, (String)"timestampModeAudio");
        this.getVideoEncoder().setTimestampMode(timestampModeVideo);
        this.getVideoEncoderRecord().setTimestampMode(timestampModeVideo);
        this.getAudioEncoder().setTimestampMode(timestampModeAudio);
    }

    public final void setEncoderErrorCallback(@Nullable EncoderErrorCallback encoderErrorCallback) {
        this.getVideoEncoder().setEncoderErrorCallback(encoderErrorCallback);
        this.getVideoEncoderRecord().setEncoderErrorCallback(encoderErrorCallback);
        this.getAudioEncoder().setEncoderErrorCallback(encoderErrorCallback);
    }

    public final void setFpsListener(@Nullable FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public final void setOrientation(int orientation) {
        this.glInterface.setCameraOrientation(orientation);
    }

    @NotNull
    public final GlStreamInterface getGlInterface() {
        return this.glInterface;
    }

    public final void setRecordController(@NotNull BaseRecordController recordController) {
        Intrinsics.checkNotNullParameter((Object)recordController, (String)"recordController");
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        if (!(this.videoSource instanceof NoVideoSource)) {
            throw new IllegalStateException("getSurfaceTexture only available with VideoManager.Source.DISABLED");
        }
        return this.glInterface.getSurfaceTexture();
    }

    @NotNull
    protected final Size getVideoResolution() {
        return new Size(this.getVideoEncoder().getWidth(), this.getVideoEncoder().getHeight());
    }

    protected final int getVideoFps() {
        return this.getVideoEncoder().getFps();
    }

    private final void startSources() {
        if (!this.glInterface.isRunning()) {
            this.glInterface.start();
        }
        if (!this.videoSource.isRunning()) {
            this.videoSource.start(this.glInterface.getSurfaceTexture());
        }
        this.audioSource.start((GetMicrophoneData)this.getMicrophoneData);
        long startTs = TimeUtils.getCurrentTimeMicro();
        this.getVideoEncoder().start(startTs);
        if (this.differentRecordResolution) {
            this.getVideoEncoderRecord().start(startTs);
        }
        this.getAudioEncoder().start(startTs);
        Surface surface = this.getVideoEncoder().getInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
        this.glInterface.addMediaCodecSurface(surface);
        if (this.differentRecordResolution) {
            Surface surface2 = this.getVideoEncoderRecord().getInputSurface();
            Intrinsics.checkNotNullExpressionValue((Object)surface2, (String)"getInputSurface(...)");
            this.glInterface.addMediaCodecRecordSurface(surface2);
        }
    }

    private final void stopSources() {
        if (!this.isOnPreview) {
            this.videoSource.stop();
        }
        this.audioSource.stop();
        this.glInterface.removeMediaCodecSurface();
        this.glInterface.removeMediaCodecRecordSurface();
        if (!this.isOnPreview) {
            this.glInterface.stop();
        }
        this.getVideoEncoder().stop();
        this.getVideoEncoderRecord().stop();
        this.getAudioEncoder().stop();
        if (!this.isRecording()) {
            this.recordController.resetFormats();
        }
    }

    public final void release() {
        if (this.isStreaming) {
            this.stopStream();
        }
        if (this.isRecording()) {
            this.stopRecord();
        }
        if (this.isOnPreview) {
            this.stopPreview();
        }
        this.stopSources();
        this.videoSource.release();
        this.audioSource.release();
    }

    public final boolean resetVideoEncoder() {
        boolean result;
        if (this.differentRecordResolution) {
            this.glInterface.removeMediaCodecRecordSurface();
            result = this.getVideoEncoderRecord().reset();
            if (!result) {
                return false;
            }
            Surface surface = this.getVideoEncoderRecord().getInputSurface();
            Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
            this.glInterface.addMediaCodecRecordSurface(surface);
        }
        this.glInterface.removeMediaCodecSurface();
        result = this.getVideoEncoder().reset();
        if (!result) {
            return false;
        }
        Surface surface = this.getVideoEncoder().getInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
        this.glInterface.addMediaCodecSurface(surface);
        return true;
    }

    public final boolean resetAudioEncoder() {
        return this.getAudioEncoder().reset();
    }

    private final boolean prepareEncoders() {
        boolean result;
        if (this.differentRecordResolution && !(result = this.getVideoEncoderRecord().prepareVideoEncoder())) {
            return false;
        }
        return this.getVideoEncoder().prepareVideoEncoder() && this.getAudioEncoder().prepareAudioEncoder();
    }

    protected abstract void onAudioInfoImp(int var1, boolean var2);

    protected abstract void startStreamImp(@NotNull String var1);

    protected abstract void stopStreamImp();

    protected abstract void onVideoInfoImp(@NotNull ByteBuffer var1, @Nullable ByteBuffer var2, @Nullable ByteBuffer var3);

    protected abstract void getVideoDataImp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    protected abstract void getAudioDataImp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    @NotNull
    public abstract StreamBaseClient getStreamClient();

    public final void setVideoCodec(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (WhenMappings.$EnumSwitchMapping$0[codec.ordinal()]) {
            case 1 -> "video/avc";
            case 2 -> "video/hevc";
            case 3 -> "video/av01";
            default -> throw new NoWhenBranchMatchedException();
        };
        this.getVideoEncoder().setType(type);
        this.getVideoEncoderRecord().setType(type);
    }

    public final void setAudioCodec(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (WhenMappings.$EnumSwitchMapping$1[codec.ordinal()]) {
            case 1 -> "audio/g711-alaw";
            case 2 -> "audio/mp4a-latm";
            case 3 -> "audio/opus";
            default -> throw new NoWhenBranchMatchedException();
        };
        this.getAudioEncoder().setType(type);
    }

    protected abstract void setVideoCodecImp(@NotNull VideoCodec var1);

    protected abstract void setAudioCodecImp(@NotNull AudioCodec var1);

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile, int level, int recordWidth, int recordHeight) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, profile, level, recordWidth, recordHeight, 0, 1024, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile, int level, int recordWidth) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, profile, level, recordWidth, 0, 0, 1536, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile, int level) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, profile, level, 0, 0, 0, 1792, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, profile, 0, 0, 0, 0, 1920, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, 0, 0, 0, 0, 0, 1984, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, 0, 0, 0, 0, 0, 0, 2016, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, 0, 0, 0, 0, 0, 0, 0, 2032, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, 0, 0, 0, 0, 0, 0, 0, 0, 2040, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler) throws IllegalArgumentException {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, echoCanceler, false, 16, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate) throws IllegalArgumentException {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, false, false, 24, null);
    }

    @JvmOverloads
    public final void startPreview(@NotNull TextureView textureView) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        StreamBase.startPreview$default(this, textureView, false, 2, null);
    }

    @JvmOverloads
    public final void startPreview(@NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        StreamBase.startPreview$default(this, surfaceView, false, 2, null);
    }

    private static final VideoEncoder videoEncoder_delegate$lambda$0(StreamBase this$0) {
        return new VideoEncoder(this$0.getVideoData);
    }

    private static final VideoEncoder videoEncoderRecord_delegate$lambda$1(StreamBase this$0) {
        return new VideoEncoder(this$0.getVideoDataRecord);
    }

    private static final AudioEncoder audioEncoder_delegate$lambda$2(StreamBase this$0) {
        return new AudioEncoder(this$0.getAacData);
    }

    public static final /* synthetic */ AudioEncoder access$getAudioEncoder(StreamBase $this) {
        return $this.getAudioEncoder();
    }

    public static final /* synthetic */ BaseRecordController access$getRecordController$p(StreamBase $this) {
        return $this.recordController;
    }

    public static final /* synthetic */ FpsListener access$getFpsListener$p(StreamBase $this) {
        return $this.fpsListener;
    }

    public static final /* synthetic */ boolean access$getDifferentRecordResolution$p(StreamBase $this) {
        return $this.differentRecordResolution;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

