/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.DisplayBase;
import com.pedro.library.rtsp.RtspDisplay;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u000b\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0014J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J$\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\"2\b\u0010(\u001a\u0004\u0018\u00010\"H\u0014J\u0018\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/pedro/library/rtsp/RtspDisplay;", "Lcom/pedro/library/base/DisplayBase;", "context", "Landroid/content/Context;", "useOpengl", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "<init>", "(Landroid/content/Context;ZLcom/pedro/common/ConnectChecker;)V", "streamClientListener", "com/pedro/library/rtsp/RtspDisplay$streamClientListener$1", "Lcom/pedro/library/rtsp/RtspDisplay$streamClientListener$1;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "streamClient", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "setVideoCodecImp", "", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodecImp", "Lcom/pedro/common/AudioCodec;", "getStreamClient", "onAudioInfoImp", "isStereo", "sampleRate", "", "startStreamImp", "url", "", "stopStreamImp", "getAudioDataImp", "audioBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "onVideoInfoImp", "sps", "pps", "vps", "getVideoDataImp", "videoBuffer", "library_release"})
@RequiresApi(api=21)
public final class RtspDisplay
extends DisplayBase {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    @NotNull
    private final RtspClient rtspClient;
    @NotNull
    private final RtspStreamClient streamClient;

    public RtspDisplay(@NotNull Context context, boolean useOpengl, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(context, useOpengl);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtspDisplay this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.rtspClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.rtspClient.setAudioCodec(codec);
    }

    @Override
    @NotNull
    public RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void onAudioInfoImp(boolean isStereo, int sampleRate) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamImp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.rtspClient.connect(url);
    }

    @Override
    protected void stopStreamImp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void getAudioDataImp(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspClient.sendAudio(audioBuffer, info);
    }

    @Override
    protected void onVideoInfoImp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getVideoDataImp(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspClient.sendVideo(videoBuffer, info);
    }
}

