/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.Point;
import android.hardware.camera2.CameraCharacteristics;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.TimestampMode;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.GlStreamInterface;
import com.pedro.library.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public abstract class Camera2Base {
    private static final String TAG = "Camera2Base";
    private final Context context;
    private Camera2ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    protected VideoEncoder videoEncoderRecord;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private GlInterface glInterface;
    private boolean differentRecordResolution = false;
    protected boolean audioInitialized = false;
    private boolean onPreview = false;
    private boolean isBackground = false;
    protected BaseRecordController recordController;
    private int previewWidth;
    private int previewHeight;
    private final FpsListener fpsListener = new FpsListener();
    private final GetMicrophoneData getMicrophoneData = frame -> this.audioEncoder.inputPCMData(frame);
    private final GetAudioData getAudioData = new GetAudioData(){

        public void getAudioData(@NonNull ByteBuffer audioBuffer, @NonNull MediaCodec.BufferInfo info) {
            Camera2Base.this.recordController.recordAudio(audioBuffer, info);
            if (Camera2Base.this.streaming) {
                Camera2Base.this.getAudioDataImp(audioBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            Camera2Base.this.recordController.setAudioFormat(mediaFormat);
        }
    };
    private final GetVideoData getVideoData = new GetVideoData(){

        public void onVideoInfo(@NonNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
            Camera2Base.this.onVideoInfoImp(sps.duplicate(), pps != null ? pps.duplicate() : null, vps != null ? vps.duplicate() : null);
        }

        public void getVideoData(@NonNull ByteBuffer videoBuffer, @NonNull MediaCodec.BufferInfo info) {
            Camera2Base.this.fpsListener.calculateFps();
            if (!Camera2Base.this.differentRecordResolution) {
                Camera2Base.this.recordController.recordVideo(videoBuffer, info);
            }
            if (Camera2Base.this.streaming) {
                Camera2Base.this.getVideoDataImp(videoBuffer, info);
            }
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            if (!Camera2Base.this.differentRecordResolution) {
                Camera2Base.this.recordController.setVideoFormat(mediaFormat, !Camera2Base.this.audioInitialized);
            }
        }
    };
    private final GetVideoData getVideoDataRecord = new GetVideoData(){

        public void onVideoInfo(@NonNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        }

        public void getVideoData(@NonNull ByteBuffer videoBuffer, @NonNull MediaCodec.BufferInfo info) {
            Camera2Base.this.recordController.recordVideo(videoBuffer, info);
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            Camera2Base.this.recordController.setVideoFormat(mediaFormat, !Camera2Base.this.audioInitialized);
        }
    };

    public Camera2Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.init(this.context);
    }

    public Camera2Base(Context context) {
        this.context = context;
        this.glInterface = new GlStreamInterface(context);
        this.isBackground = true;
        this.init(context);
    }

    private void init(Context context) {
        this.cameraManager = new Camera2ApiManager(context);
        this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
        this.videoEncoder = new VideoEncoder(this.getVideoData);
        this.videoEncoderRecord = new VideoEncoder(this.getVideoDataRecord);
        this.audioEncoder = new AudioEncoder(this.getAudioData);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setCameraCallbacks(CameraCallbacks callbacks) {
        this.cameraManager.setCameraCallbacks(callbacks);
    }

    public void setTimestampMode(TimestampMode timestampModeVideo, TimestampMode timestampModeAudio) {
        this.videoEncoder.setTimestampMode(timestampModeVideo);
        this.videoEncoderRecord.setTimestampMode(timestampModeVideo);
        this.audioEncoder.setTimestampMode(timestampModeAudio);
    }

    public void setEncoderErrorCallback(EncoderErrorCallback encoderErrorCallback) {
        this.videoEncoder.setEncoderErrorCallback(encoderErrorCallback);
        this.videoEncoderRecord.setEncoderErrorCallback(encoderErrorCallback);
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public boolean enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        return this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean enableAutoExposure() {
        return this.cameraManager.enableAutoExposure();
    }

    public void disableAutoExposure() {
        this.cameraManager.disableAutoExposure();
    }

    public boolean isAutoExposureEnabled() {
        return this.cameraManager.isAutoExposureEnabled();
    }

    public boolean enableVideoStabilization() {
        return this.cameraManager.enableVideoStabilization();
    }

    public void disableVideoStabilization() {
        this.cameraManager.disableVideoStabilization();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.cameraManager.isVideoStabilizationEnabled();
    }

    public boolean enableOpticalVideoStabilization() {
        return this.cameraManager.enableOpticalVideoStabilization();
    }

    public void disableOpticalVideoStabilization() {
        this.cameraManager.disableOpticalVideoStabilization();
    }

    public boolean isOpticalVideoStabilizationEnabled() {
        return this.cameraManager.isOpticalStabilizationEnabled();
    }

    @Deprecated
    public boolean isFrontCamera() {
        return this.cameraManager.getCameraFacing() == CameraHelper.Facing.FRONT;
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.cameraManager.getCameraFacing();
    }

    public void enableLantern() throws Exception {
        this.cameraManager.enableLantern();
    }

    public void disableLantern() {
        this.cameraManager.disableLantern();
    }

    public boolean isLanternEnabled() {
        return this.cameraManager.isLanternEnabled();
    }

    public boolean isLanternSupported() {
        return this.cameraManager.isLanternSupported();
    }

    public boolean enableAutoFocus() {
        return this.cameraManager.enableAutoFocus();
    }

    public boolean disableAutoFocus() {
        return this.cameraManager.disableAutoFocus();
    }

    public boolean isAutoFocusEnabled() {
        return this.cameraManager.isAutoFocusEnabled();
    }

    public void setFocusDistance(float distance) {
        this.cameraManager.setFocusDistance(distance);
    }

    public String getCurrentCameraId() {
        return this.cameraManager.getCurrentCameraId();
    }

    public boolean resetVideoEncoder() {
        boolean result;
        if (this.differentRecordResolution) {
            this.glInterface.removeMediaCodecRecordSurface();
            result = this.videoEncoderRecord.reset();
            if (!result) {
                return false;
            }
            this.glInterface.addMediaCodecRecordSurface(this.videoEncoderRecord.getInputSurface());
        }
        this.glInterface.removeMediaCodecSurface();
        result = this.videoEncoder.reset();
        if (!result) {
            return false;
        }
        this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        return true;
    }

    public boolean resetAudioEncoder() {
        return this.audioEncoder.reset();
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int profile, int level, int recordWidth, int recordHeight, int recordBitrate) {
        boolean result;
        if (this.onPreview && (width != this.previewWidth || height != this.previewHeight || fps != this.videoEncoder.getFps() || rotation != this.videoEncoder.getRotation())) {
            this.stopPreview();
        }
        this.differentRecordResolution = false;
        if (recordWidth != width && recordHeight != height) {
            if ((double)recordWidth / (double)recordHeight != (double)width / (double)height) {
                Log.e((String)TAG, (String)"The aspect ratio of record and stream resolution must be the same");
                return false;
            }
            this.differentRecordResolution = true;
        }
        if (this.differentRecordResolution && !(result = this.videoEncoderRecord.prepareVideoEncoder(recordWidth, recordHeight, fps, recordBitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level))) {
            return false;
        }
        return this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int profile, int level) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, profile, level, width, height, bitrate);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(width, height, 30, bitrate, 2, rotation);
    }

    protected abstract void onAudioInfoImp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.onAudioInfoImp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(640, 480, 30, 1228800, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void forceCodecType(CodecUtil.CodecType codecTypeVideo, CodecUtil.CodecType codecTypeAudio) {
        this.videoEncoder.forceCodecType(codecTypeVideo);
        this.videoEncoderRecord.forceCodecType(codecTypeVideo);
        this.audioEncoder.forceCodecType(codecTypeAudio);
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning() || this.videoEncoderRecord.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning() || this.videoEncoderRecord.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    public void replaceView(Context context) {
        this.isBackground = true;
        this.replaceGlInterface(new GlStreamInterface(context));
    }

    public void replaceView(OpenGlView openGlView) {
        this.isBackground = false;
        this.replaceGlInterface(openGlView);
    }

    private void replaceGlInterface(GlInterface glInterface) {
        if (this.isStreaming() || this.isRecording() || this.isOnPreview()) {
            Point size = this.glInterface.getEncoderSize();
            Point sizeRecord = this.glInterface.getEncoderSize();
            this.cameraManager.closeCamera();
            this.glInterface.removeMediaCodecSurface();
            this.glInterface.removeMediaCodecRecordSurface();
            this.glInterface.stop();
            this.glInterface = glInterface;
            int w = size.x;
            int h = size.y;
            int recordW = sizeRecord.x;
            int recordH = sizeRecord.y;
            int rotation = this.videoEncoder.getRotation();
            if (rotation == 90 || rotation == 270) {
                h = size.x;
                w = size.y;
                recordH = sizeRecord.x;
                recordW = sizeRecord.y;
            }
            this.prepareGlView(w, h, recordW, recordH, rotation);
            this.cameraManager.openLastCamera();
        } else {
            this.glInterface = glInterface;
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int fps, int rotation) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), width, height, fps, rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int rotation) {
        this.startPreview(cameraFacing, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(String cameraId, int width, int height, int rotation) {
        this.startPreview(cameraId, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(String cameraId, int width, int height, int fps, int rotation) {
        if (!this.onPreview && !this.isBackground) {
            this.previewWidth = width;
            this.previewHeight = height;
            this.videoEncoder.setFps(fps);
            this.videoEncoder.setRotation(rotation);
            this.videoEncoderRecord.setFps(fps);
            this.videoEncoderRecord.setRotation(rotation);
            this.prepareGlView(width, height, width, height, rotation);
            this.cameraManager.openCameraId(cameraId);
            this.onPreview = true;
        } else if (!this.isStreaming() && !this.onPreview && this.isBackground) {
            this.cameraManager.setCameraId(cameraId);
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(String cameraId, int width, int height) {
        this.startPreview(cameraId, width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(String cameraId, int rotation) {
        this.startPreview(cameraId, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(String cameraId) {
        this.startPreview(cameraId, this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(int width, int height) {
        this.startPreview(this.getCameraFacing(), width, height);
    }

    public void startPreview() {
        this.startPreview(this.getCameraFacing());
    }

    public void stopPreview() {
        if (!(this.isStreaming() || this.isRecording() || this.isBackground)) {
            this.stopCamera();
        } else {
            Log.e((String)TAG, (String)"Streaming or preview stopped, ignored");
        }
    }

    public void stopCamera() {
        if (this.onPreview) {
            this.glInterface.stop();
            this.cameraManager.closeCamera();
            this.onPreview = false;
            this.previewWidth = 0;
            this.previewHeight = 0;
        } else {
            Log.e((String)TAG, (String)"Preview stopped, ignored");
        }
    }

    public void startStreamAndRecord(String url, String path, RecordController.Listener listener) throws IOException {
        this.startStream(url);
        this.recordController.startRecord(path, listener);
    }

    public void startStreamAndRecord(String url, String path) throws IOException {
        this.startStreamAndRecord(url, path, null);
    }

    protected abstract void startStreamImp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.requestKeyFrame();
        }
        this.startStreamImp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        long startTs = System.nanoTime() / 1000L;
        this.videoEncoder.start(startTs);
        if (this.differentRecordResolution) {
            this.videoEncoderRecord.start(startTs);
        }
        if (this.audioInitialized) {
            this.audioEncoder.start(startTs);
        }
        this.prepareGlView(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoderRecord.getWidth(), this.videoEncoderRecord.getHeight(), this.videoEncoder.getRotation());
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
        if (!this.cameraManager.isRunning()) {
            this.cameraManager.openLastCamera();
        }
        this.onPreview = true;
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            this.videoEncoder.requestKeyframe();
        }
        if (this.videoEncoderRecord.isRunning()) {
            this.videoEncoderRecord.requestKeyframe();
        }
    }

    private void prepareGlView(int width, int height, int recordWidth, int recordHeight, int rotation) {
        GlInterface glInterface;
        int w = width;
        int h = height;
        int recordW = recordWidth;
        int recordH = recordHeight;
        boolean isPortrait = false;
        if (rotation == 90 || rotation == 270) {
            h = width;
            w = height;
            recordH = recordWidth;
            recordW = recordHeight;
            isPortrait = true;
        }
        this.glInterface.setEncoderSize(w, h);
        if (this.differentRecordResolution) {
            this.glInterface.setEncoderRecordSize(recordW, recordH);
        }
        if ((glInterface = this.glInterface) instanceof GlStreamInterface) {
            GlStreamInterface glStreamInterface = (GlStreamInterface)glInterface;
            glStreamInterface.setPreviewResolution(w, h);
            glStreamInterface.setIsPortrait(isPortrait);
        }
        this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
        if (!this.glInterface.isRunning()) {
            this.glInterface.start();
        }
        if (this.videoEncoder.getInputSurface() != null && this.videoEncoder.isRunning()) {
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        }
        if (this.videoEncoderRecord.getInputSurface() != null && this.videoEncoderRecord.isRunning()) {
            this.glInterface.addMediaCodecRecordSurface(this.videoEncoderRecord.getInputSurface());
        }
        int cameraWidth = Math.max(this.videoEncoder.getWidth(), this.videoEncoderRecord.getWidth());
        int cameraHeight = Math.max(this.videoEncoder.getHeight(), this.videoEncoderRecord.getHeight());
        this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), cameraWidth, cameraHeight, this.videoEncoder.getFps());
    }

    protected abstract void stopStreamImp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamImp();
        }
        if (!this.recordController.isRecording()) {
            boolean bl = this.onPreview = !this.isBackground;
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            this.glInterface.removeMediaCodecSurface();
            this.glInterface.removeMediaCodecRecordSurface();
            if (this.glInterface instanceof GlStreamInterface) {
                this.glInterface.stop();
                this.cameraManager.closeCamera();
            }
            this.videoEncoder.stop();
            if (this.differentRecordResolution) {
                this.videoEncoderRecord.stop();
            }
            if (this.audioInitialized) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
        }
    }

    public List<Size> getResolutionsBack() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsBack());
    }

    public List<Size> getResolutionsFront() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsFront());
    }

    public List<Size> getResolutions(String cameraId) {
        return Arrays.asList(this.cameraManager.getCameraResolutions(cameraId));
    }

    public List<Range<Integer>> getSupportedFps() {
        return this.cameraManager.getSupportedFps(null, CameraHelper.Facing.BACK);
    }

    public List<Range<Integer>> getSupportedFps(Size size, CameraHelper.Facing facing) {
        return this.cameraManager.getSupportedFps(size, facing);
    }

    public CameraCharacteristics getCameraCharacteristics() {
        return this.cameraManager.getCameraCharacteristics();
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public Range<Float> getZoomRange() {
        return this.cameraManager.getZoomRange();
    }

    public float getZoom() {
        return this.cameraManager.getZoom();
    }

    public void setZoom(float level) {
        this.cameraManager.setZoom(level);
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public void setZoom(MotionEvent event, float delta) {
        this.cameraManager.setZoom(event, delta);
    }

    public Float[] getOpticalZooms() {
        return this.cameraManager.getOpticalZooms();
    }

    public void setOpticalZoom(float level) {
        this.cameraManager.setOpticalZoom(level);
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    @RequiresApi(value=28)
    public List<String> physicalCamerasAvailable() {
        return this.cameraManager.getPhysicalCamerasAvailable();
    }

    @RequiresApi(value=28)
    public void openPhysicalCamera(String id) {
        this.cameraManager.openPhysicalCamera(id);
    }

    public String[] getCamerasAvailable() {
        return this.cameraManager.getCamerasAvailable();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.isRecording() || this.onPreview) {
            this.cameraManager.switchCamera();
        } else {
            this.cameraManager.setCameraFacing(this.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT);
        }
    }

    public void switchCamera(String cameraId) throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.reOpenCamera(cameraId);
        } else {
            this.cameraManager.setCameraId(cameraId);
        }
    }

    public void setExposure(int value) {
        this.cameraManager.setExposure(value);
    }

    public int getExposure() {
        return this.cameraManager.getExposure();
    }

    public int getMaxExposure() {
        return this.cameraManager.getMaxExposure();
    }

    public int getMinExposure() {
        return this.cameraManager.getMinExposure();
    }

    public boolean tapToFocus(MotionEvent event) {
        return this.cameraManager.tapToFocus(event);
    }

    public GlInterface getGlInterface() {
        return this.glInterface;
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.videoEncoder.getFps() : 0;
        this.videoEncoder.setForceFps(fps);
        this.videoEncoderRecord.setForceFps(fps);
        this.glInterface.forceFpsLimit(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public void addImageListener(int width, int height, int format, int maxImages, Camera2ApiManager.ImageCallback listener) {
        this.cameraManager.addImageListener(width, height, format, maxImages, true, listener);
    }

    public void addImageListener(int width, int height, int format, int maxImages, boolean autoClose, Camera2ApiManager.ImageCallback listener) {
        this.cameraManager.addImageListener(width, height, format, maxImages, autoClose, listener);
    }

    public void addImageListener(int format, int maxImages, Camera2ApiManager.ImageCallback listener) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.addImageListener(this.videoEncoder.getHeight(), this.videoEncoder.getWidth(), format, maxImages, listener);
        } else {
            this.addImageListener(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), format, maxImages, listener);
        }
    }

    public void removeImageListener() {
        this.cameraManager.removeImageListener();
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    protected abstract void getAudioDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    protected abstract void onVideoInfoImp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract void getVideoDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract StreamBaseClient getStreamClient();

    public void setVideoCodec(VideoCodec codec) {
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case VideoCodec.H264 -> "video/avc";
            case VideoCodec.H265 -> "video/hevc";
            case VideoCodec.AV1 -> "video/av01";
        };
        this.videoEncoder.setType(type);
    }

    public void setAudioCodec(AudioCodec codec) {
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case AudioCodec.G711 -> "audio/g711-alaw";
            case AudioCodec.AAC -> "audio/mp4a-latm";
            case AudioCodec.OPUS -> "audio/opus";
        };
        this.audioEncoder.setType(type);
    }

    protected abstract void setVideoCodecImp(VideoCodec var1);

    protected abstract void setAudioCodecImp(AudioCodec var1);
}

