/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.R;
import com.pedro.library.util.Filter;
import com.pedro.library.view.ForceRenderer;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

@RequiresApi(api=18)
public class OpenGlView
extends SurfaceView
implements GlInterface,
SurfaceTexture.OnFrameAvailableListener,
SurfaceHolder.Callback {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final MainRender mainRender = new MainRender();
    private final SurfaceManager surfaceManagerPhoto = new SurfaceManager();
    private final SurfaceManager surfaceManager = new SurfaceManager();
    private final SurfaceManager surfaceManagerEncoder = new SurfaceManager();
    private final SurfaceManager surfaceManagerEncoderRecord = new SurfaceManager();
    private final BlockingQueue<Filter> filterQueue = new LinkedBlockingQueue<Filter>();
    private final LinkedBlockingQueue<Runnable> threadQueue = new LinkedBlockingQueue();
    private int previewWidth;
    private int previewHeight;
    private int encoderWidth;
    private int encoderHeight;
    private int encoderRecordWidth;
    private int encoderRecordHeight;
    private TakePhotoCallback takePhotoCallback;
    private int streamRotation;
    private boolean muteVideo = false;
    private boolean isPreviewHorizontalFlip = false;
    private boolean isPreviewVerticalFlip = false;
    private boolean isStreamHorizontalFlip = false;
    private boolean isStreamVerticalFlip = false;
    private AspectRatioMode aspectRatioMode = AspectRatioMode.Adjust;
    private ExecutorService executor = null;
    private final FpsLimiter fpsLimiter = new FpsLimiter();
    private final ForceRenderer forceRenderer = new ForceRenderer();

    public OpenGlView(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OpenGlView);
        try {
            this.aspectRatioMode = AspectRatioMode.Companion.fromId(typedArray.getInt(R.styleable.OpenGlView_aspectRatioMode, AspectRatioMode.NONE.ordinal()));
            boolean isFlipHorizontal = typedArray.getBoolean(R.styleable.OpenGlView_isFlipHorizontal, false);
            boolean isFlipVertical = typedArray.getBoolean(R.styleable.OpenGlView_isFlipVertical, false);
            this.mainRender.setCameraFlip(isFlipHorizontal, isFlipVertical);
        }
        finally {
            typedArray.recycle();
        }
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mainRender.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.mainRender.getSurface();
    }

    @Override
    public void setFilter(int filterPosition, @NonNull BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(@NonNull BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, @NonNull BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(@NonNull BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.mainRender.filtersCount();
    }

    @Override
    public void setFilter(@NonNull BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    @Override
    public void setRotation(int rotation) {
        this.mainRender.setCameraRotation(rotation);
    }

    @Override
    public void forceFpsLimit(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    public void setAspectRatioMode(AspectRatioMode aspectRatioMode) {
        this.aspectRatioMode = aspectRatioMode;
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.mainRender.setCameraFlip(isFlipHorizontal, isFlipVertical);
    }

    @Override
    public void setStreamRotation(int streamRotation) {
        this.streamRotation = streamRotation;
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setForceRender(boolean enabled, int fps) {
        this.forceRenderer.setEnabled(enabled, fps);
    }

    @Override
    public void setForceRender(boolean enabled) {
        this.setForceRender(enabled, 5);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    public void setEncoderRecordSize(int width, int height) {
        this.encoderRecordWidth = width;
        this.encoderRecordHeight = height;
    }

    @Override
    public Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    @Override
    public void takePhoto(TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    private void draw(boolean forced) {
        int h;
        if (!this.isRunning()) {
            return;
        }
        boolean limitFps = this.fpsLimiter.limitFPS();
        if (!forced) {
            this.forceRenderer.frameAvailable();
        }
        if (this.surfaceManager.isReady() && this.mainRender.isReady()) {
            this.surfaceManager.makeCurrent();
            this.mainRender.updateFrame();
            this.mainRender.drawOffScreen();
            if (!limitFps) {
                this.mainRender.drawScreen(this.previewWidth, this.previewHeight, this.aspectRatioMode, 0, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
                this.surfaceManager.swapBuffer();
            }
        }
        if (!this.filterQueue.isEmpty() && this.mainRender.isReady()) {
            try {
                Filter filter = this.filterQueue.take();
                this.mainRender.setFilterAction(filter.filterAction, filter.position, filter.baseFilterRender);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (this.surfaceManagerEncoder.isReady() && this.mainRender.isReady() && !limitFps) {
            int w = this.muteVideo ? 0 : this.encoderWidth;
            h = this.muteVideo ? 0 : this.encoderHeight;
            this.surfaceManagerEncoder.makeCurrent();
            this.mainRender.drawScreen(w, h, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
            this.surfaceManagerEncoder.swapBuffer();
        }
        if (this.surfaceManagerEncoderRecord.isReady() && this.mainRender.isReady() && !limitFps) {
            int w = this.muteVideo ? 0 : this.encoderRecordWidth;
            h = this.muteVideo ? 0 : this.encoderRecordHeight;
            this.surfaceManagerEncoderRecord.makeCurrent();
            this.mainRender.drawScreen(w, h, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
            this.surfaceManagerEncoderRecord.swapBuffer();
        }
        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady() && this.mainRender.isReady()) {
            this.surfaceManagerPhoto.makeCurrent();
            this.mainRender.drawScreen(this.encoderWidth, this.encoderHeight, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
            this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
            this.takePhotoCallback = null;
            this.surfaceManagerPhoto.swapBuffer();
        }
    }

    @Override
    public void addMediaCodecSurface(Surface surface) {
        ExecutorService executor = this.executor;
        if (executor == null) {
            return;
        }
        ExtensionsKt.secureSubmit((ExecutorService)executor, () -> {
            if (this.surfaceManager.isReady()) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
            }
            return null;
        });
    }

    @Override
    public void removeMediaCodecSurface() {
        this.threadQueue.clear();
        ExecutorService executor = this.executor;
        if (executor == null) {
            return;
        }
        ExtensionsKt.secureSubmit((ExecutorService)executor, () -> {
            this.surfaceManagerEncoder.release();
            return null;
        });
    }

    @Override
    public void addMediaCodecRecordSurface(Surface surface) {
        ExecutorService executor = this.executor;
        if (executor == null) {
            return;
        }
        ExtensionsKt.secureSubmit((ExecutorService)executor, () -> {
            if (this.surfaceManager.isReady()) {
                this.surfaceManagerEncoderRecord.release();
                this.surfaceManagerEncoderRecord.eglSetup(surface, this.surfaceManager);
            }
            return null;
        });
    }

    @Override
    public void removeMediaCodecRecordSurface() {
        this.threadQueue.clear();
        ExecutorService executor = this.executor;
        if (executor == null) {
            return;
        }
        ExtensionsKt.secureSubmit((ExecutorService)executor, () -> {
            this.surfaceManagerEncoderRecord.release();
            return null;
        });
    }

    @Override
    public void start() {
        ExecutorService executor = this.executor = ExtensionsKt.newSingleThreadExecutor(this.threadQueue);
        ExtensionsKt.secureSubmit((ExecutorService)executor, () -> {
            this.surfaceManager.release();
            this.surfaceManager.eglSetup(this.getHolder().getSurface());
            this.surfaceManager.makeCurrent();
            this.mainRender.initGl(this.getContext(), this.encoderWidth, this.encoderHeight, this.encoderWidth, this.encoderHeight);
            this.surfaceManagerPhoto.release();
            this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
            this.running.set(true);
            this.mainRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.forceRenderer.start((Function0<Unit>)((Function0)() -> {
                ExecutorService ex = this.executor;
                if (ex == null) {
                    return null;
                }
                ex.execute(() -> this.draw(true));
                return null;
            }));
            return null;
        });
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.threadQueue.clear();
        ExecutorService executor = this.executor;
        if (executor == null) {
            return;
        }
        ExtensionsKt.secureSubmit((ExecutorService)executor, () -> {
            this.forceRenderer.stop();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManagerEncoderRecord.release();
            this.surfaceManager.release();
            this.mainRender.release();
            return null;
        });
        executor.shutdownNow();
        this.executor = null;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (!this.isRunning()) {
            return;
        }
        ExecutorService ex = this.executor;
        if (ex == null) {
            return;
        }
        ex.execute(() -> this.draw(false));
    }

    public void surfaceCreated(@NonNull SurfaceHolder holder) {
    }

    public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
        this.mainRender.setPreviewSize(this.previewWidth, this.previewHeight);
    }

    public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
        this.stop();
    }
}

