/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.content.Context;
import android.view.OrientationEventListener;
import com.pedro.encoder.input.video.CameraHelper;

public class SensorRotationManager {
    private final OrientationEventListener listener;
    private int currentOrientation = -1;

    public SensorRotationManager(final Context context, final boolean avoidDuplicated, final boolean followUI, final RotationChangedListener rotationListener) {
        this.listener = new OrientationEventListener(context, 3){

            public void onOrientationChanged(int sensorOrientation) {
                int uiOrientation;
                int rotation = (sensorOrientation + 45) / 90 % 4;
                int rotationDegrees = rotation * 90;
                if (avoidDuplicated && SensorRotationManager.this.currentOrientation == rotationDegrees) {
                    return;
                }
                if (followUI && (uiOrientation = SensorRotationManager.this.getUiOrientation(context)) != rotationDegrees) {
                    return;
                }
                SensorRotationManager.this.currentOrientation = rotationDegrees;
                boolean isPortrait = rotationDegrees == 0 || rotationDegrees == 180;
                rotationListener.onRotationChanged(rotationDegrees, isPortrait);
            }
        };
    }

    public void start() {
        if (this.listener.canDetectOrientation()) {
            this.currentOrientation = -1;
            this.listener.enable();
        }
    }

    public void stop() {
        this.listener.disable();
        this.currentOrientation = -1;
    }

    private int getUiOrientation(Context context) {
        int orientation = CameraHelper.getCameraOrientation((Context)context);
        return orientation == 0 ? 270 : orientation - 90;
    }

    public static interface RotationChangedListener {
        public void onRotationChanged(int var1, boolean var2);
    }
}

