/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base.recording;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateManager;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.recording.RecordController;
import java.nio.ByteBuffer;

public abstract class BaseRecordController
implements RecordController {
    protected static final String TAG = "RecordController";
    protected RecordController.Status status = RecordController.Status.STOPPED;
    protected VideoCodec videoCodec = VideoCodec.H264;
    protected AudioCodec audioCodec = AudioCodec.AAC;
    protected long pauseMoment = 0L;
    protected long pauseTime = 0L;
    protected RecordController.Listener listener;
    protected int videoTrack = -1;
    protected int audioTrack = -1;
    protected final MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    protected final MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();
    protected boolean isOnlyAudio = false;
    protected boolean isOnlyVideo = false;
    protected BitrateManager bitrateManager;
    protected long startTs = 0L;

    public void setVideoCodec(VideoCodec videoCodec) {
        this.videoCodec = videoCodec;
    }

    public void setAudioCodec(AudioCodec audioCodec) {
        this.audioCodec = audioCodec;
    }

    public boolean isRunning() {
        return this.status == RecordController.Status.STARTED || this.status == RecordController.Status.RECORDING || this.status == RecordController.Status.RESUMED || this.status == RecordController.Status.PAUSED;
    }

    public boolean isRecording() {
        return this.status == RecordController.Status.RECORDING;
    }

    public RecordController.Status getStatus() {
        return this.status;
    }

    public void pauseRecord() {
        if (this.status == RecordController.Status.RECORDING) {
            this.pauseMoment = System.nanoTime() / 1000L;
            this.status = RecordController.Status.PAUSED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    public void resumeRecord() {
        if (this.status == RecordController.Status.PAUSED) {
            this.pauseTime += System.nanoTime() / 1000L - this.pauseMoment;
            this.status = RecordController.Status.RESUMED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    protected boolean isKeyFrame(ByteBuffer videoBuffer) {
        byte[] header = new byte[5];
        if (videoBuffer.remaining() < header.length) {
            return false;
        }
        videoBuffer.duplicate().get(header, 0, header.length);
        if (this.videoCodec == VideoCodec.AV1) {
            return false;
        }
        if (this.videoCodec == VideoCodec.H264 && (header[4] & 0x1F) == 5) {
            return true;
        }
        return this.videoCodec == VideoCodec.H265 && (header[4] >> 1 & 0x3F) == 19 || (header[4] >> 1 & 0x3F) == 20;
    }

    protected void updateFormat(MediaCodec.BufferInfo newInfo, MediaCodec.BufferInfo oldInfo) {
        if (this.startTs <= 0L) {
            this.startTs = oldInfo.presentationTimeUs;
        }
        newInfo.flags = oldInfo.flags;
        newInfo.offset = oldInfo.offset;
        newInfo.size = oldInfo.size;
        newInfo.presentationTimeUs = oldInfo.presentationTimeUs - this.startTs - this.pauseTime;
    }

    public void setVideoFormat(MediaFormat videoFormat) {
        this.setVideoFormat(videoFormat, false);
    }

    public void setAudioFormat(MediaFormat audioFormat) {
        this.setAudioFormat(audioFormat, false);
    }
}

