/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.generic;

import android.content.Context;
import android.media.MediaCodec;
import android.util.Size;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.StreamBase;
import com.pedro.library.generic.ClientType;
import com.pedro.library.generic.GenericStream;
import com.pedro.library.util.sources.audio.AudioSource;
import com.pedro.library.util.sources.audio.MicrophoneSource;
import com.pedro.library.util.sources.video.Camera2Source;
import com.pedro.library.util.sources.video.VideoSource;
import com.pedro.library.util.streamclient.GenericStreamClient;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import com.pedro.udp.UdpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0089\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u000e\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020\u001eH\u0014J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J$\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020.2\b\u00103\u001a\u0004\u0018\u00010.2\b\u00104\u001a\u0004\u0018\u00010.H\u0014J\u0018\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/pedro/library/generic/GenericStream;", "Lcom/pedro/library/base/StreamBase;", "context", "Landroid/content/Context;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "videoSource", "Lcom/pedro/library/util/sources/video/VideoSource;", "audioSource", "Lcom/pedro/library/util/sources/audio/AudioSource;", "<init>", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;Lcom/pedro/library/util/sources/video/VideoSource;Lcom/pedro/library/util/sources/audio/AudioSource;)V", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;)V", "streamClientListener", "com/pedro/library/generic/GenericStream$streamClientListener$1", "Lcom/pedro/library/generic/GenericStream$streamClientListener$1;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "udpClient", "Lcom/pedro/udp/UdpClient;", "streamClient", "Lcom/pedro/library/util/streamclient/GenericStreamClient;", "connectedType", "Lcom/pedro/library/generic/ClientType;", "getStreamClient", "setVideoCodecImp", "", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodecImp", "Lcom/pedro/common/AudioCodec;", "onAudioInfoImp", "sampleRate", "", "isStereo", "", "startStreamImp", "endPoint", "", "stopStreamImp", "getAudioDataImp", "audioBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "onVideoInfoImp", "sps", "pps", "vps", "getVideoDataImp", "videoBuffer", "library_release"})
@RequiresApi(value=21)
public final class GenericStream
extends StreamBase {
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final streamClientListener.1 streamClientListener;
    @NotNull
    private final RtmpClient rtmpClient;
    @NotNull
    private final RtspClient rtspClient;
    @NotNull
    private final SrtClient srtClient;
    @NotNull
    private final UdpClient udpClient;
    @NotNull
    private final GenericStreamClient streamClient;
    @NotNull
    private ClientType connectedType;

    public GenericStream(@NotNull Context context, @NotNull ConnectChecker connectChecker, @NotNull VideoSource videoSource, @NotNull AudioSource audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)audioSource, (String)"audioSource");
        super(context, videoSource, audioSource);
        this.connectChecker = connectChecker;
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ GenericStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyframe();
            }
        };
        this.rtmpClient = new RtmpClient(this.connectChecker);
        this.rtspClient = new RtspClient(this.connectChecker);
        this.srtClient = new SrtClient(this.connectChecker);
        this.udpClient = new UdpClient(this.connectChecker);
        this.streamClient = new GenericStreamClient(new RtmpStreamClient(this.rtmpClient, this.streamClientListener), new RtspStreamClient(this.rtspClient, this.streamClientListener), new SrtStreamClient(this.srtClient, this.streamClientListener), new UdpStreamClient(this.udpClient, this.streamClientListener));
        this.connectedType = ClientType.NONE;
    }

    public GenericStream(@NotNull Context context, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        this(context, connectChecker, new Camera2Source(context), new MicrophoneSource(0, 1, null));
    }

    @Override
    @NotNull
    public GenericStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != VideoCodec.H264 && codec != VideoCodec.H265) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support video H264 and H265");
        }
        this.rtmpClient.setVideoCodec(codec);
        this.rtspClient.setVideoCodec(codec);
        this.srtClient.setVideoCodec(codec);
        this.udpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != AudioCodec.AAC) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support audio AAC");
        }
        this.rtmpClient.setAudioCodec(codec);
        this.rtspClient.setAudioCodec(codec);
        this.srtClient.setAudioCodec(codec);
        this.udpClient.setAudioCodec(codec);
    }

    @Override
    protected void onAudioInfoImp(int sampleRate, boolean isStereo) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
        this.srtClient.setAudioInfo(sampleRate, isStereo);
        this.udpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamImp(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        this.streamClient.connecting(endPoint);
        if (StringsKt.startsWith((String)endPoint, (String)"rtmp", (boolean)true)) {
            this.connectedType = ClientType.RTMP;
            Size resolution = super.getVideoResolution();
            this.rtmpClient.setVideoResolution(resolution.getWidth(), resolution.getHeight());
            this.rtmpClient.setFps(super.getVideoFps());
            this.rtmpClient.connect(endPoint);
        } else if (StringsKt.startsWith((String)endPoint, (String)"rtsp", (boolean)true)) {
            this.connectedType = ClientType.RTSP;
            this.rtspClient.connect(endPoint);
        } else if (StringsKt.startsWith((String)endPoint, (String)"srt", (boolean)true)) {
            this.connectedType = ClientType.SRT;
            SrtClient.connect$default((SrtClient)this.srtClient, (String)endPoint, (boolean)false, (int)2, null);
        } else if (StringsKt.startsWith((String)endPoint, (String)"udp", (boolean)true)) {
            this.connectedType = ClientType.UDP;
            UdpClient.connect$default((UdpClient)this.udpClient, (String)endPoint, (boolean)false, (int)2, null);
        } else {
            ExtensionsKt.onMainThreadHandler(() -> GenericStream.startStreamImp$lambda$0(this));
        }
    }

    @Override
    protected void stopStreamImp() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.disconnect();
                break;
            }
            case 2: {
                this.rtspClient.disconnect();
                break;
            }
            case 3: {
                this.srtClient.disconnect();
                break;
            }
            case 4: {
                this.udpClient.disconnect();
            }
        }
        this.connectedType = ClientType.NONE;
    }

    @Override
    protected void getAudioDataImp(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.sendAudio(audioBuffer, info);
                break;
            }
            case 2: {
                this.rtspClient.sendAudio(audioBuffer, info);
                break;
            }
            case 3: {
                this.srtClient.sendAudio(audioBuffer, info);
                break;
            }
            case 4: {
                this.udpClient.sendAudio(audioBuffer, info);
            }
        }
    }

    @Override
    protected void onVideoInfoImp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.rtmpClient.setVideoInfo(sps, pps, vps);
        this.rtspClient.setVideoInfo(sps, pps, vps);
        this.srtClient.setVideoInfo(sps, pps, vps);
        this.udpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getVideoDataImp(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.sendVideo(videoBuffer, info);
                break;
            }
            case 2: {
                this.rtspClient.sendVideo(videoBuffer, info);
                break;
            }
            case 3: {
                this.srtClient.sendVideo(videoBuffer, info);
                break;
            }
            case 4: {
                this.udpClient.sendVideo(videoBuffer, info);
            }
        }
    }

    private static final Unit startStreamImp$lambda$0(GenericStream this$0) {
        this$0.connectChecker.onConnectionFailed("Unsupported protocol. Only support rtmp, rtsp and srt");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientType.values().length];
            try {
                nArray[ClientType.RTMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.RTSP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.SRT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.UDP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

