/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.generic;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.generic.ClientType;
import com.pedro.library.generic.GenericCamera2;
import com.pedro.library.util.streamclient.GenericStreamClient;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import com.pedro.udp.UdpClient;
import java.nio.ByteBuffer;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\f\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\u001bH\u0014J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J$\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020-2\b\u00102\u001a\u0004\u0018\u00010-2\b\u00103\u001a\u0004\u0018\u00010-H\u0014J\u0018\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/pedro/library/generic/GenericCamera2;", "Lcom/pedro/library/base/Camera2Base;", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "<init>", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;)V", "streamClientListener", "com/pedro/library/generic/GenericCamera2$streamClientListener$1", "Lcom/pedro/library/generic/GenericCamera2$streamClientListener$1;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "udpClient", "Lcom/pedro/udp/UdpClient;", "streamClient", "Lcom/pedro/library/util/streamclient/GenericStreamClient;", "connectedType", "Lcom/pedro/library/generic/ClientType;", "init", "", "getStreamClient", "setVideoCodecImp", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodecImp", "Lcom/pedro/common/AudioCodec;", "onAudioInfoImp", "isStereo", "", "sampleRate", "", "startStreamImp", "url", "", "stopStreamImp", "getAudioDataImp", "audioBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "onVideoInfoImp", "sps", "pps", "vps", "getVideoDataImp", "videoBuffer", "library_release"})
@RequiresApi(api=21)
public final class GenericCamera2
extends Camera2Base {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private RtmpClient rtmpClient;
    private RtspClient rtspClient;
    private SrtClient srtClient;
    private UdpClient udpClient;
    private GenericStreamClient streamClient;
    private ConnectChecker connectChecker;
    @NotNull
    private ClientType connectedType;

    public GenericCamera2(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(openGlView);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ GenericCamera2 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.connectedType = ClientType.NONE;
        this.init(connectChecker);
    }

    public GenericCamera2(@NotNull Context context, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(context);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.connectedType = ClientType.NONE;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.connectChecker = connectChecker;
        this.rtmpClient = new RtmpClient(connectChecker);
        this.rtspClient = new RtspClient(connectChecker);
        this.srtClient = new SrtClient(connectChecker);
        this.udpClient = new UdpClient(connectChecker);
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        RtmpStreamClient rtmpStreamClient = new RtmpStreamClient(rtmpClient, this.streamClientListener);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        RtspStreamClient rtspStreamClient = new RtspStreamClient(rtspClient, this.streamClientListener);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        SrtStreamClient srtStreamClient = new SrtStreamClient(srtClient, this.streamClientListener);
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        this.streamClient = new GenericStreamClient(rtmpStreamClient, rtspStreamClient, srtStreamClient, new UdpStreamClient(udpClient, this.streamClientListener));
    }

    @Override
    @NotNull
    public GenericStreamClient getStreamClient() {
        GenericStreamClient genericStreamClient = this.streamClient;
        if (genericStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            genericStreamClient = null;
        }
        return genericStreamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (!(codec == VideoCodec.H264 || codec == VideoCodec.H265)) {
            boolean bl = false;
            String string = "Unsupported codec: " + codec.name() + ". Generic only support video H264 and H265";
            throw new IllegalArgumentException(string.toString());
        }
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoCodec(codec);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setVideoCodec(codec);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setVideoCodec(codec);
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (!(codec == AudioCodec.AAC)) {
            boolean bl = false;
            String string = "Unsupported codec: " + codec.name() + ". Generic only support audio AAC";
            throw new IllegalArgumentException(string.toString());
        }
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioCodec(codec);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setAudioCodec(codec);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setAudioCodec(codec);
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setAudioCodec(codec);
    }

    @Override
    protected void onAudioInfoImp(boolean isStereo, int sampleRate) {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioInfo(sampleRate, isStereo);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setAudioInfo(sampleRate, isStereo);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setAudioInfo(sampleRate, isStereo);
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamImp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        GenericStreamClient genericStreamClient = this.streamClient;
        if (genericStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            genericStreamClient = null;
        }
        genericStreamClient.connecting(url);
        String string = url;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"rtmp", (boolean)false, (int)2, null)) {
            RtmpClient rtmpClient;
            this.connectedType = ClientType.RTMP;
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                RtmpClient rtmpClient2 = this.rtmpClient;
                if (rtmpClient2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient2 = null;
                }
                rtmpClient2.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                RtmpClient rtmpClient3 = this.rtmpClient;
                if (rtmpClient3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient3 = null;
                }
                rtmpClient3.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            if ((rtmpClient = this.rtmpClient) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient = null;
            }
            rtmpClient.setFps(this.videoEncoder.getFps());
            RtmpClient rtmpClient4 = this.rtmpClient;
            if (rtmpClient4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient4 = null;
            }
            rtmpClient4.connect(url);
        } else {
            string = url;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (StringsKt.startsWith$default((String)string3, (String)"rtsp", (boolean)false, (int)2, null)) {
                this.connectedType = ClientType.RTSP;
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.connect(url);
            } else {
                string = url;
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string4 = string.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (StringsKt.startsWith$default((String)string4, (String)"srt", (boolean)false, (int)2, null)) {
                    this.connectedType = ClientType.SRT;
                    SrtClient srtClient = this.srtClient;
                    if (srtClient == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                        srtClient = null;
                    }
                    SrtClient.connect$default((SrtClient)srtClient, (String)url, (boolean)false, (int)2, null);
                } else {
                    string = url;
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                    String string5 = string.toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    if (StringsKt.startsWith$default((String)string5, (String)"udp", (boolean)false, (int)2, null)) {
                        this.connectedType = ClientType.UDP;
                        UdpClient udpClient = this.udpClient;
                        if (udpClient == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
                            udpClient = null;
                        }
                        UdpClient.connect$default((UdpClient)udpClient, (String)url, (boolean)false, (int)2, null);
                    } else {
                        ExtensionsKt.onMainThreadHandler(() -> GenericCamera2.startStreamImp$lambda$2(this));
                    }
                }
            }
        }
    }

    @Override
    protected void stopStreamImp() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                RtmpClient rtmpClient = this.rtmpClient;
                if (rtmpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient = null;
                }
                rtmpClient.disconnect();
                break;
            }
            case 2: {
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.disconnect();
                break;
            }
            case 3: {
                SrtClient srtClient = this.srtClient;
                if (srtClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                    srtClient = null;
                }
                srtClient.disconnect();
                break;
            }
            case 4: {
                UdpClient udpClient = this.udpClient;
                if (udpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
                    udpClient = null;
                }
                udpClient.disconnect();
            }
        }
        this.connectedType = ClientType.NONE;
    }

    @Override
    protected void getAudioDataImp(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                RtmpClient rtmpClient = this.rtmpClient;
                if (rtmpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient = null;
                }
                rtmpClient.sendAudio(audioBuffer, info);
                break;
            }
            case 2: {
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.sendAudio(audioBuffer, info);
                break;
            }
            case 3: {
                SrtClient srtClient = this.srtClient;
                if (srtClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                    srtClient = null;
                }
                srtClient.sendAudio(audioBuffer, info);
                break;
            }
            case 4: {
                UdpClient udpClient = this.udpClient;
                if (udpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
                    udpClient = null;
                }
                udpClient.sendAudio(audioBuffer, info);
            }
        }
    }

    @Override
    protected void onVideoInfoImp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoInfo(sps, pps, vps);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setVideoInfo(sps, pps, vps);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setVideoInfo(sps, pps, vps);
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getVideoDataImp(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                RtmpClient rtmpClient = this.rtmpClient;
                if (rtmpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient = null;
                }
                rtmpClient.sendVideo(videoBuffer, info);
                break;
            }
            case 2: {
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.sendVideo(videoBuffer, info);
                break;
            }
            case 3: {
                SrtClient srtClient = this.srtClient;
                if (srtClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                    srtClient = null;
                }
                srtClient.sendVideo(videoBuffer, info);
                break;
            }
            case 4: {
                UdpClient udpClient = this.udpClient;
                if (udpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
                    udpClient = null;
                }
                udpClient.sendVideo(videoBuffer, info);
            }
        }
    }

    private static final Unit startStreamImp$lambda$2(GenericCamera2 this$0) {
        ConnectChecker connectChecker = this$0.connectChecker;
        if (connectChecker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectChecker");
            connectChecker = null;
        }
        connectChecker.onConnectionFailed("Unsupported protocol. Only support rtmp, rtsp and srt");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientType.values().length];
            try {
                nArray[ClientType.RTMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.RTSP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.SRT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.UDP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

