/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.StreamBase;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.sources.audio.AudioSource;
import com.pedro.library.util.sources.video.NoVideoSource;
import com.pedro.library.util.sources.video.VideoSource;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlStreamInterface;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00db\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u000b\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJR\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\b\b\u0002\u0010/\u001a\u00020,2\b\b\u0002\u00100\u001a\u00020,2\b\b\u0002\u00101\u001a\u00020,2\b\b\u0002\u00102\u001a\u00020,2\b\b\u0002\u00103\u001a\u00020,H\u0007J4\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020,2\b\b\u0002\u00107\u001a\u00020\u001f2\b\b\u0002\u00108\u001a\u00020\u001fH\u0007J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020:J\u000e\u0010>\u001a\u00020:2\u0006\u0010.\u001a\u00020,J\u000e\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020\u001fJ\u0016\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CJ\u0006\u0010E\u001a\u00020\u001fJ\u0016\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020\u001fJ\u0006\u0010K\u001a\u00020:J\u0006\u0010L\u001a\u00020:J\u000e\u0010M\u001a\u00020:2\u0006\u0010N\u001a\u00020OJ\u000e\u0010M\u001a\u00020:2\u0006\u0010P\u001a\u00020QJ\u001e\u0010M\u001a\u00020:2\u0006\u0010R\u001a\u00020S2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u001e\u0010M\u001a\u00020:2\u0006\u0010T\u001a\u00020U2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u0006\u0010V\u001a\u00020:J\u000e\u0010W\u001a\u00020:2\u0006\u0010X\u001a\u00020\u0005J\u000e\u0010Y\u001a\u00020:2\u0006\u0010X\u001a\u00020\u0007J\u0010\u0010Z\u001a\u00020:2\b\u0010[\u001a\u0004\u0018\u00010\\J\u0010\u0010]\u001a\u00020:2\b\u0010^\u001a\u0004\u0018\u00010_J\u000e\u0010`\u001a\u00020:2\u0006\u0010a\u001a\u00020,J\u0006\u0010b\u001a\u00020\u0019J\u000e\u0010c\u001a\u00020:2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010d\u001a\u00020SJ\b\u0010e\u001a\u00020fH\u0004J\b\u0010g\u001a\u00020,H\u0004J\b\u0010h\u001a\u00020:H\u0002J\b\u0010i\u001a\u00020:H\u0002J\u0006\u0010j\u001a\u00020:J\u0006\u0010k\u001a\u00020\u001fJ\u0006\u0010l\u001a\u00020\u001fJ\b\u0010m\u001a\u00020\u001fH\u0002J\u0018\u0010r\u001a\u00020:2\u0006\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u001fH$J\u0010\u0010s\u001a\u00020:2\u0006\u0010;\u001a\u00020<H$J\b\u0010t\u001a\u00020:H$J$\u0010u\u001a\u00020:2\u0006\u0010v\u001a\u00020w2\b\u0010x\u001a\u0004\u0018\u00010w2\b\u0010y\u001a\u0004\u0018\u00010wH$J\u0018\u0010z\u001a\u00020:2\u0006\u0010{\u001a\u00020w2\u0006\u0010|\u001a\u00020}H$J\u0018\u0010~\u001a\u00020:2\u0006\u0010\u007f\u001a\u00020w2\u0006\u0010|\u001a\u00020}H$J\n\u0010\u0080\u0001\u001a\u00030\u0081\u0001H&J\u0011\u0010\u0082\u0001\u001a\u00020:2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u0011\u0010\u0085\u0001\u001a\u00020:2\b\u0010\u0083\u0001\u001a\u00030\u0086\u0001J\u0013\u0010\u0087\u0001\u001a\u00020:2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H$J\u0013\u0010\u0088\u0001\u001a\u00020:2\b\u0010\u0083\u0001\u001a\u00030\u0086\u0001H$R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010#\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u001e\u0010$\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010n\u001a\u00020oX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020qX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0089\u0001"}, d2={"Lcom/pedro/library/base/StreamBase;", "", "context", "Landroid/content/Context;", "vSource", "Lcom/pedro/library/util/sources/video/VideoSource;", "aSource", "Lcom/pedro/library/util/sources/audio/AudioSource;", "<init>", "(Landroid/content/Context;Lcom/pedro/library/util/sources/video/VideoSource;Lcom/pedro/library/util/sources/audio/AudioSource;)V", "getMicrophoneData", "com/pedro/library/base/StreamBase$getMicrophoneData$1", "Lcom/pedro/library/base/StreamBase$getMicrophoneData$1;", "videoEncoder", "Lcom/pedro/encoder/video/VideoEncoder;", "getVideoEncoder", "()Lcom/pedro/encoder/video/VideoEncoder;", "videoEncoder$delegate", "Lkotlin/Lazy;", "audioEncoder", "Lcom/pedro/encoder/audio/AudioEncoder;", "getAudioEncoder", "()Lcom/pedro/encoder/audio/AudioEncoder;", "audioEncoder$delegate", "glInterface", "Lcom/pedro/library/view/GlStreamInterface;", "recordController", "Lcom/pedro/library/base/recording/BaseRecordController;", "fpsListener", "Lcom/pedro/library/util/FpsListener;", "value", "", "isStreaming", "()Z", "isOnPreview", "isRecording", "videoSource", "getVideoSource", "()Lcom/pedro/library/util/sources/video/VideoSource;", "audioSource", "getAudioSource", "()Lcom/pedro/library/util/sources/audio/AudioSource;", "prepareVideo", "width", "", "height", "bitrate", "fps", "iFrameInterval", "rotation", "profile", "level", "prepareAudio", "sampleRate", "isStereo", "echoCanceler", "noiseSuppressor", "startStream", "", "endPoint", "", "requestKeyframe", "setVideoBitrateOnFly", "forceFpsLimit", "enabled", "forceCodecType", "codecTypeVideo", "Lcom/pedro/encoder/utils/CodecUtil$CodecType;", "codecTypeAudio", "stopStream", "startRecord", "path", "listener", "Lcom/pedro/library/base/recording/RecordController$Listener;", "stopRecord", "pauseRecord", "resumeRecord", "startPreview", "textureView", "Landroid/view/TextureView;", "surfaceView", "Landroid/view/SurfaceView;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "surface", "Landroid/view/Surface;", "stopPreview", "changeVideoSource", "source", "changeAudioSource", "setEncoderErrorCallback", "encoderErrorCallback", "Lcom/pedro/encoder/EncoderErrorCallback;", "setFpsListener", "callback", "Lcom/pedro/library/util/FpsListener$Callback;", "setOrientation", "orientation", "getGlInterface", "setRecordController", "getSurfaceTexture", "getVideoResolution", "Landroid/util/Size;", "getVideoFps", "startSources", "stopSources", "release", "resetVideoEncoder", "resetAudioEncoder", "prepareEncoders", "getAacData", "Lcom/pedro/encoder/audio/GetAudioData;", "getVideoData", "Lcom/pedro/encoder/video/GetVideoData;", "onAudioInfoImp", "startStreamImp", "stopStreamImp", "onVideoInfoImp", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "getVideoDataImp", "videoBuffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "getAudioDataImp", "audioBuffer", "getStreamClient", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "setVideoCodec", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "setAudioCodecImp", "library_release"})
@RequiresApi(value=21)
public abstract class StreamBase {
    @NotNull
    private final getMicrophoneData.1 getMicrophoneData;
    @NotNull
    private final Lazy videoEncoder$delegate;
    @NotNull
    private final Lazy audioEncoder$delegate;
    @NotNull
    private final GlStreamInterface glInterface;
    @NotNull
    private BaseRecordController recordController;
    @NotNull
    private final FpsListener fpsListener;
    private boolean isStreaming;
    private boolean isOnPreview;
    @NotNull
    private VideoSource videoSource;
    @NotNull
    private AudioSource audioSource;
    @NotNull
    private final GetAudioData getAacData;
    @NotNull
    private final GetVideoData getVideoData;

    public StreamBase(@NotNull Context context, @NotNull VideoSource vSource, @NotNull AudioSource aSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vSource, (String)"vSource");
        Intrinsics.checkNotNullParameter((Object)aSource, (String)"aSource");
        this.getMicrophoneData = new GetMicrophoneData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputPCMData(Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                StreamBase.access$getAudioEncoder(this.this$0).inputPCMData(frame);
            }
        };
        this.videoEncoder$delegate = LazyKt.lazy(() -> StreamBase.videoEncoder_delegate$lambda$0(this));
        this.audioEncoder$delegate = LazyKt.lazy(() -> StreamBase.audioEncoder_delegate$lambda$1(this));
        this.glInterface = new GlStreamInterface(context);
        this.recordController = new AndroidMuxerRecordController();
        this.fpsListener = new FpsListener();
        this.videoSource = vSource;
        this.audioSource = aSource;
        this.getAacData = new GetAudioData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void getAudioData(ByteBuffer audioBuffer, MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.this$0.getAudioDataImp(audioBuffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordAudio(audioBuffer, info);
            }

            public void onAudioFormat(MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                StreamBase.access$getRecordController$p(this.this$0).setAudioFormat(mediaFormat);
            }
        };
        this.getVideoData = new GetVideoData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVideoInfo(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
                Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
                ByteBuffer byteBuffer = sps.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
                ByteBuffer byteBuffer2 = pps;
                ByteBuffer byteBuffer3 = vps;
                this.this$0.onVideoInfoImp(byteBuffer, byteBuffer2 != null ? byteBuffer2.duplicate() : null, byteBuffer3 != null ? byteBuffer3.duplicate() : null);
            }

            public void getVideoData(ByteBuffer videoBuffer, MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                StreamBase.access$getFpsListener$p(this.this$0).calculateFps();
                this.this$0.getVideoDataImp(videoBuffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordVideo(videoBuffer, info);
            }

            public void onVideoFormat(MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                StreamBase.access$getRecordController$p(this.this$0).setVideoFormat(mediaFormat);
            }
        };
    }

    private final VideoEncoder getVideoEncoder() {
        Lazy lazy = this.videoEncoder$delegate;
        return (VideoEncoder)lazy.getValue();
    }

    private final AudioEncoder getAudioEncoder() {
        Lazy lazy = this.audioEncoder$delegate;
        return (AudioEncoder)lazy.getValue();
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final boolean isOnPreview() {
        return this.isOnPreview;
    }

    public final boolean isRecording() {
        return this.recordController.isRunning();
    }

    @NotNull
    public final VideoSource getVideoSource() {
        return this.videoSource;
    }

    @NotNull
    public final AudioSource getAudioSource() {
        return this.audioSource;
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile, int level) throws IllegalArgumentException {
        if (this.isStreaming || this.isRecording() || this.isOnPreview) {
            throw new IllegalStateException("Stream, record and preview must be stopped before prepareVideo");
        }
        boolean videoResult = this.videoSource.init(width, height, fps, rotation);
        if (videoResult) {
            switch (rotation) {
                case 90: 
                case 270: {
                    this.glInterface.setEncoderSize(height, width);
                    break;
                }
                default: {
                    this.glInterface.setEncoderSize(width, height);
                }
            }
            boolean isPortrait = rotation == 90 || rotation == 270;
            this.glInterface.setIsPortrait(isPortrait);
            this.glInterface.setCameraOrientation(rotation == 0 ? 270 : rotation - 90);
            return this.getVideoEncoder().prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level);
        }
        return false;
    }

    public static /* synthetic */ boolean prepareVideo$default(StreamBase streamBase, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) throws IllegalArgumentException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareVideo");
        }
        if ((n9 & 8) != 0) {
            n4 = 30;
        }
        if ((n9 & 0x10) != 0) {
            n5 = 2;
        }
        if ((n9 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n9 & 0x40) != 0) {
            n7 = -1;
        }
        if ((n9 & 0x80) != 0) {
            n8 = -1;
        }
        return streamBase.prepareVideo(n, n2, n3, n4, n5, n6, n7, n8);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler, boolean noiseSuppressor) throws IllegalArgumentException {
        if (this.isStreaming || this.isRecording()) {
            throw new IllegalStateException("Stream and record must be stopped before prepareAudio");
        }
        boolean audioResult = this.audioSource.init(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (audioResult) {
            this.onAudioInfoImp(sampleRate, isStereo);
            return this.getAudioEncoder().prepareAudioEncoder(bitrate, sampleRate, isStereo, this.audioSource.getMaxInputSize());
        }
        return false;
    }

    public static /* synthetic */ boolean prepareAudio$default(StreamBase streamBase, int n, boolean bl, int n2, boolean bl2, boolean bl3, int n3, Object object) throws IllegalArgumentException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareAudio");
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        return streamBase.prepareAudio(n, bl, n2, bl2, bl3);
    }

    public final void startStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        if (this.isStreaming) {
            throw new IllegalStateException("Stream already started, stopStream before startStream again");
        }
        this.isStreaming = true;
        this.startStreamImp(endPoint);
        if (!this.isRecording()) {
            this.startSources();
        } else {
            this.requestKeyframe();
        }
    }

    public final void requestKeyframe() {
        if (this.getVideoEncoder().isRunning()) {
            this.getVideoEncoder().requestKeyframe();
        }
    }

    public final void setVideoBitrateOnFly(int bitrate) {
        this.getVideoEncoder().setVideoBitrateOnFly(bitrate);
    }

    public final void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.getVideoEncoder().getFps() : 0;
        this.getVideoEncoder().setForceFps(fps);
        this.glInterface.forceFpsLimit(fps);
    }

    public final void forceCodecType(@NotNull CodecUtil.CodecType codecTypeVideo, @NotNull CodecUtil.CodecType codecTypeAudio) {
        Intrinsics.checkNotNullParameter((Object)codecTypeVideo, (String)"codecTypeVideo");
        Intrinsics.checkNotNullParameter((Object)codecTypeAudio, (String)"codecTypeAudio");
        this.getVideoEncoder().forceCodecType(codecTypeVideo);
        this.getAudioEncoder().forceCodecType(codecTypeAudio);
    }

    public final boolean stopStream() {
        this.isStreaming = false;
        this.stopStreamImp();
        if (!this.isRecording()) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void startRecord(@NotNull String path, @NotNull RecordController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.isRecording()) {
            throw new IllegalStateException("Record already started, stopRecord before startRecord again");
        }
        this.recordController.startRecord(path, listener);
        if (!this.isStreaming) {
            this.startSources();
        } else {
            this.getVideoEncoder().requestKeyframe();
        }
    }

    public final boolean stopRecord() {
        this.recordController.stopRecord();
        if (!this.isStreaming) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public final void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public final void startPreview(@NotNull TextureView textureView) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        this.startPreview(new Surface(textureView.getSurfaceTexture()), textureView.getWidth(), textureView.getHeight());
    }

    public final void startPreview(@NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Surface surface = surfaceView.getHolder().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        this.startPreview(surface, surfaceView.getWidth(), surfaceView.getHeight());
    }

    public final void startPreview(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.startPreview(new Surface(surfaceTexture), width, height);
    }

    public final void startPreview(@NotNull Surface surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (!surface.isValid()) {
            throw new IllegalArgumentException("Make sure the Surface is valid");
        }
        if (this.isOnPreview) {
            throw new IllegalStateException("Preview already started, stopPreview before startPreview again");
        }
        this.isOnPreview = true;
        if (!this.glInterface.isRunning()) {
            this.glInterface.start();
        }
        if (!this.videoSource.isRunning()) {
            this.videoSource.start(this.glInterface.getSurfaceTexture());
        }
        this.glInterface.attachPreview(surface);
        this.glInterface.setPreviewResolution(width, height);
    }

    public final void stopPreview() {
        this.isOnPreview = false;
        if (!this.isStreaming && !this.isRecording()) {
            this.videoSource.stop();
        }
        this.glInterface.deAttachPreview();
        if (!this.isStreaming && !this.isRecording()) {
            this.glInterface.stop();
        }
    }

    public final void changeVideoSource(@NotNull VideoSource source) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean wasRunning = this.videoSource.isRunning();
        boolean wasCreated = this.videoSource.getCreated();
        if (wasCreated) {
            source.init(this.getVideoEncoder().getWidth(), this.getVideoEncoder().getHeight(), this.getVideoEncoder().getFps(), this.getVideoEncoder().getRotation());
        }
        this.videoSource.stop();
        this.videoSource.release();
        if (wasRunning) {
            source.start(this.glInterface.getSurfaceTexture());
        }
        this.videoSource = source;
    }

    public final void changeAudioSource(@NotNull AudioSource source) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean wasRunning = this.audioSource.isRunning();
        boolean wasCreated = this.audioSource.getCreated();
        if (wasCreated) {
            source.init(this.audioSource.getSampleRate(), this.audioSource.isStereo(), this.audioSource.getEchoCanceler(), this.audioSource.getNoiseSuppressor());
        }
        this.audioSource.stop();
        this.audioSource.release();
        if (wasRunning) {
            source.start(this.getMicrophoneData);
        }
        this.audioSource = source;
    }

    public final void setEncoderErrorCallback(@Nullable EncoderErrorCallback encoderErrorCallback) {
        this.getVideoEncoder().setEncoderErrorCallback(encoderErrorCallback);
        this.getAudioEncoder().setEncoderErrorCallback(encoderErrorCallback);
    }

    public final void setFpsListener(@Nullable FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public final void setOrientation(int orientation) {
        this.glInterface.setCameraOrientation(orientation);
    }

    @NotNull
    public final GlStreamInterface getGlInterface() {
        return this.glInterface;
    }

    public final void setRecordController(@NotNull BaseRecordController recordController) {
        Intrinsics.checkNotNullParameter((Object)recordController, (String)"recordController");
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        if (!(this.videoSource instanceof NoVideoSource)) {
            throw new IllegalStateException("getSurfaceTexture only available with VideoManager.Source.DISABLED");
        }
        return this.glInterface.getSurfaceTexture();
    }

    @NotNull
    protected final Size getVideoResolution() {
        return new Size(this.getVideoEncoder().getWidth(), this.getVideoEncoder().getHeight());
    }

    protected final int getVideoFps() {
        return this.getVideoEncoder().getFps();
    }

    private final void startSources() {
        if (!this.glInterface.isRunning()) {
            this.glInterface.start();
        }
        if (!this.videoSource.isRunning()) {
            this.videoSource.start(this.glInterface.getSurfaceTexture());
        }
        this.audioSource.start(this.getMicrophoneData);
        long startTs = System.nanoTime() / (long)1000;
        this.getVideoEncoder().start(startTs);
        this.getAudioEncoder().start(startTs);
        Surface surface = this.getVideoEncoder().getInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
        this.glInterface.addMediaCodecSurface(surface);
    }

    private final void stopSources() {
        if (!this.isOnPreview) {
            this.videoSource.stop();
        }
        this.audioSource.stop();
        this.glInterface.removeMediaCodecSurface();
        if (!this.isOnPreview) {
            this.glInterface.stop();
        }
        this.getVideoEncoder().stop();
        this.getAudioEncoder().stop();
        if (!this.isRecording()) {
            this.recordController.resetFormats();
        }
    }

    public final void release() {
        if (this.isStreaming) {
            this.stopStream();
        }
        if (this.isRecording()) {
            this.stopRecord();
        }
        if (this.isOnPreview) {
            this.stopPreview();
        }
        this.stopSources();
        this.videoSource.release();
        this.audioSource.release();
    }

    public final boolean resetVideoEncoder() {
        this.glInterface.removeMediaCodecSurface();
        boolean result = this.getVideoEncoder().reset();
        if (!result) {
            return false;
        }
        Surface surface = this.getVideoEncoder().getInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
        this.glInterface.addMediaCodecSurface(surface);
        return true;
    }

    public final boolean resetAudioEncoder() {
        return this.getAudioEncoder().reset();
    }

    private final boolean prepareEncoders() {
        return this.getVideoEncoder().prepareVideoEncoder() && this.getAudioEncoder().prepareAudioEncoder();
    }

    protected abstract void onAudioInfoImp(int var1, boolean var2);

    protected abstract void startStreamImp(@NotNull String var1);

    protected abstract void stopStreamImp();

    protected abstract void onVideoInfoImp(@NotNull ByteBuffer var1, @Nullable ByteBuffer var2, @Nullable ByteBuffer var3);

    protected abstract void getVideoDataImp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    protected abstract void getAudioDataImp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    @NotNull
    public abstract StreamBaseClient getStreamClient();

    public final void setVideoCodec(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (WhenMappings.$EnumSwitchMapping$0[codec.ordinal()]) {
            case 1 -> "video/avc";
            case 2 -> "video/hevc";
            case 3 -> "video/av01";
            default -> throw new NoWhenBranchMatchedException();
        };
        this.getVideoEncoder().setType(type);
    }

    public final void setAudioCodec(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (WhenMappings.$EnumSwitchMapping$1[codec.ordinal()]) {
            case 1 -> "audio/g711-alaw";
            case 2 -> "audio/mp4a-latm";
            case 3 -> "audio/opus";
            default -> throw new NoWhenBranchMatchedException();
        };
        this.getAudioEncoder().setType(type);
    }

    protected abstract void setVideoCodecImp(@NotNull VideoCodec var1);

    protected abstract void setAudioCodecImp(@NotNull AudioCodec var1);

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, profile, 0, 128, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, 0, 0, 192, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, 0, 0, 0, 224, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, 0, 0, 0, 0, 240, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate) throws IllegalArgumentException {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, 0, 0, 0, 0, 0, 248, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler) throws IllegalArgumentException {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, echoCanceler, false, 16, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate) throws IllegalArgumentException {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, false, false, 24, null);
    }

    private static final VideoEncoder videoEncoder_delegate$lambda$0(StreamBase this$0) {
        return new VideoEncoder(this$0.getVideoData);
    }

    private static final AudioEncoder audioEncoder_delegate$lambda$1(StreamBase this$0) {
        return new AudioEncoder(this$0.getAacData);
    }

    public static final /* synthetic */ AudioEncoder access$getAudioEncoder(StreamBase $this) {
        return $this.getAudioEncoder();
    }

    public static final /* synthetic */ BaseRecordController access$getRecordController$p(StreamBase $this) {
        return $this.recordController;
    }

    public static final /* synthetic */ FpsListener access$getFpsListener$p(StreamBase $this) {
        return $this.fpsListener;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

