/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera1Base;
import com.pedro.library.rtmp.RtmpCamera1;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0015\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u0017\b\u0017\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J$\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0014J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010+\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u00020\u0018H\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u00063"}, d2={"Lcom/pedro/library/rtmp/RtmpCamera1;", "Lcom/pedro/library/base/Camera1Base;", "surfaceView", "Landroid/view/SurfaceView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "(Landroid/view/SurfaceView;Lcom/pedro/common/ConnectChecker;)V", "textureView", "Landroid/view/TextureView;", "(Landroid/view/TextureView;Lcom/pedro/common/ConnectChecker;)V", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;)V", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "streamClient", "Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "streamClientListener", "com/pedro/library/rtmp/RtmpCamera1$streamClientListener$1", "Lcom/pedro/library/rtmp/RtmpCamera1$streamClientListener$1;", "getAacDataRtp", "", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "getStreamClient", "init", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudioRtp", "isStereo", "", "sampleRate", "", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "Lcom/pedro/common/VideoCodec;", "startStreamRtp", "url", "", "stopStreamRtp", "library_release"})
public final class RtmpCamera1
extends Camera1Base {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private RtmpClient rtmpClient;
    private RtmpStreamClient streamClient;

    public RtmpCamera1(@NotNull SurfaceView surfaceView, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(surfaceView);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtmpCamera1 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.init(connectChecker);
    }

    public RtmpCamera1(@NotNull TextureView textureView, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(textureView);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    @RequiresApi(value=18)
    public RtmpCamera1(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(openGlView);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(@NotNull Context context, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(context);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.rtmpClient = new RtmpClient(connectChecker);
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        this.streamClient = new RtmpStreamClient(rtmpClient, this.streamClientListener);
    }

    @Override
    @NotNull
    public RtmpStreamClient getStreamClient() {
        RtmpStreamClient rtmpStreamClient = this.streamClient;
        if (rtmpStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            rtmpStreamClient = null;
        }
        return rtmpStreamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        RtmpClient rtmpClient;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            RtmpClient rtmpClient2 = this.rtmpClient;
            if (rtmpClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient2 = null;
            }
            rtmpClient2.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            RtmpClient rtmpClient3 = this.rtmpClient;
            if (rtmpClient3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient3 = null;
            }
            rtmpClient3.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        if ((rtmpClient = this.rtmpClient) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setFps(this.videoEncoder.getFps());
        RtmpClient rtmpClient4 = this.rtmpClient;
        if (rtmpClient4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient4 = null;
        }
        rtmpClient4.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.sendVideo(h264Buffer, info);
    }
}

