/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.util.Filter;
import com.pedro.library.util.SensorRotationManager;
import com.pedro.library.view.ForceRenderer;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.GlStreamInterface;
import com.pedro.library.view.OrientationForced;
import com.pedro.library.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0018\u00104\u001a\u0002052\u0006\u00108\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020;H\u0016J\u000e\u0010<\u001a\u0002052\u0006\u0010:\u001a\u00020;J\b\u0010=\u001a\u000205H\u0016J\u0006\u0010>\u001a\u000205J\u0010\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020\tH\u0002J\b\u0010A\u001a\u00020\u000fH\u0016J\u0010\u0010B\u001a\u0002052\u0006\u0010C\u001a\u00020\u000fH\u0016J\u000e\u0010D\u001a\u0002052\u0006\u0010@\u001a\u00020#J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020;H\u0016J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\tH\u0016J\b\u0010K\u001a\u00020\tH\u0016J\b\u0010!\u001a\u000205H\u0016J\u0012\u0010L\u001a\u0002052\b\u0010M\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010N\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010N\u001a\u0002052\u0006\u00108\u001a\u00020\u000fH\u0016J\b\u0010O\u001a\u000205H\u0016J\u000e\u0010P\u001a\u0002052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010Q\u001a\u0002052\u0006\u0010R\u001a\u00020\u000fJ\u0018\u0010S\u001a\u0002052\u0006\u0010T\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020\u000fH\u0016J\u0010\u0010V\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0018\u0010V\u001a\u0002052\u0006\u00108\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010W\u001a\u0002052\u0006\u0010X\u001a\u00020\tH\u0016J\u0018\u0010W\u001a\u0002052\u0006\u0010X\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u000fH\u0016J\u0010\u0010Y\u001a\u0002052\u0006\u0010Z\u001a\u00020\tH\u0016J\u0010\u0010[\u001a\u0002052\u0006\u0010Z\u001a\u00020\tH\u0016J\u0010\u0010\\\u001a\u0002052\u0006\u0010Z\u001a\u00020\tH\u0016J\u0010\u0010]\u001a\u0002052\u0006\u0010Z\u001a\u00020\tH\u0016J \u0010^\u001a\u0002052\u0006\u0010T\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\tJ\u000e\u0010_\u001a\u0002052\u0006\u0010R\u001a\u00020\u000fJ\u0010\u0010`\u001a\u0002052\u0006\u0010a\u001a\u00020\u000fH\u0016J\u0010\u0010b\u001a\u0002052\u0006\u0010R\u001a\u00020\u000fH\u0016J\b\u0010c\u001a\u000205H\u0016J\b\u0010d\u001a\u000205H\u0016J\u0012\u0010e\u001a\u0002052\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u0010f\u001a\u000205H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000bR\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/pedro/library/view/GlStreamInterface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Lcom/pedro/library/view/GlInterface;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "aspectRatioMode", "Lcom/pedro/encoder/utils/gl/AspectRatioMode;", "autoHandleOrientation", "", "getAutoHandleOrientation", "()Z", "setAutoHandleOrientation", "(Z)V", "encoderHeight", "", "encoderWidth", "executor", "Ljava/util/concurrent/ExecutorService;", "filterQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/library/util/Filter;", "forceRender", "Lcom/pedro/library/view/ForceRenderer;", "fpsLimiter", "Lcom/pedro/encoder/input/video/FpsLimiter;", "isPortrait", "isPreviewHorizontalFlip", "isPreviewVerticalFlip", "isStreamHorizontalFlip", "isStreamVerticalFlip", "mainRender", "Lcom/pedro/encoder/input/gl/render/MainRender;", "muteVideo", "orientationForced", "Lcom/pedro/library/view/OrientationForced;", "previewHeight", "previewOrientation", "previewWidth", "<set-?>", "running", "getRunning", "sensorRotationManager", "Lcom/pedro/library/util/SensorRotationManager;", "streamOrientation", "surfaceManager", "Lcom/pedro/encoder/input/gl/SurfaceManager;", "surfaceManagerEncoder", "surfaceManagerPhoto", "surfaceManagerPreview", "takePhotoCallback", "Lcom/pedro/library/view/TakePhotoCallback;", "addFilter", "", "baseFilterRender", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "filterPosition", "addMediaCodecSurface", "surface", "Landroid/view/Surface;", "attachPreview", "clearFilters", "deAttachPreview", "draw", "forced", "filtersCount", "forceFpsLimit", "fps", "forceOrientation", "getEncoderSize", "Landroid/graphics/Point;", "getSurface", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "isRunning", "isVideoMuted", "onFrameAvailable", "surfaceTexture", "removeFilter", "removeMediaCodecSurface", "setAspectRatioMode", "setCameraOrientation", "orientation", "setEncoderSize", "width", "height", "setFilter", "setForceRender", "enabled", "setIsPreviewHorizontalFlip", "flip", "setIsPreviewVerticalFlip", "setIsStreamHorizontalFlip", "setIsStreamVerticalFlip", "setPreviewResolution", "setPreviewRotation", "setRotation", "rotation", "setStreamRotation", "start", "stop", "takePhoto", "unMuteVideo", "library_release"})
@RequiresApi(api=18)
public final class GlStreamInterface
implements SurfaceTexture.OnFrameAvailableListener,
GlInterface {
    @NotNull
    private final Context context;
    @Nullable
    private TakePhotoCallback takePhotoCallback;
    private volatile boolean running;
    @NotNull
    private final SurfaceManager surfaceManager;
    @NotNull
    private final SurfaceManager surfaceManagerEncoder;
    @NotNull
    private final SurfaceManager surfaceManagerPhoto;
    @NotNull
    private final SurfaceManager surfaceManagerPreview;
    @NotNull
    private final MainRender mainRender;
    private int encoderWidth;
    private int encoderHeight;
    private int streamOrientation;
    private int previewWidth;
    private int previewHeight;
    private int previewOrientation;
    private boolean isPortrait;
    @NotNull
    private OrientationForced orientationForced;
    @NotNull
    private final BlockingQueue<Filter> filterQueue;
    private boolean muteVideo;
    private boolean isPreviewHorizontalFlip;
    private boolean isPreviewVerticalFlip;
    private boolean isStreamHorizontalFlip;
    private boolean isStreamVerticalFlip;
    @NotNull
    private AspectRatioMode aspectRatioMode;
    @Nullable
    private ExecutorService executor;
    @NotNull
    private final FpsLimiter fpsLimiter;
    @NotNull
    private final ForceRenderer forceRender;
    private boolean autoHandleOrientation;
    @NotNull
    private final SensorRotationManager sensorRotationManager;

    public GlStreamInterface(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerPhoto = new SurfaceManager();
        this.surfaceManagerPreview = new SurfaceManager();
        this.mainRender = new MainRender();
        this.orientationForced = OrientationForced.NONE;
        this.filterQueue = new LinkedBlockingQueue();
        this.aspectRatioMode = AspectRatioMode.Adjust;
        this.fpsLimiter = new FpsLimiter();
        this.forceRender = new ForceRenderer();
        this.sensorRotationManager = new SensorRotationManager(this.context, true, arg_0 -> GlStreamInterface.sensorRotationManager$lambda$0(this, arg_0));
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final boolean getAutoHandleOrientation() {
        return this.autoHandleOrientation;
    }

    public final void setAutoHandleOrientation(boolean bl) {
        this.autoHandleOrientation = bl;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    @NotNull
    public Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setForceRender(boolean enabled, int fps) {
        this.forceRender.setEnabled(enabled, fps);
    }

    @Override
    public void setForceRender(boolean enabled) {
        this.setForceRender(enabled, 5);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    @NotNull
    public SurfaceTexture getSurfaceTexture() {
        return this.mainRender.getSurfaceTexture();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        return this.mainRender.getSurface();
    }

    @Override
    public void addMediaCodecSurface(@NotNull Surface surface) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            ExtensionsKt.secureSubmit((ExecutorService)executorService, (Function0)((Function0)new Function0<Unit>(this, surface){
                final /* synthetic */ GlStreamInterface this$0;
                final /* synthetic */ Surface $surface;
                {
                    this.this$0 = $receiver;
                    this.$surface = $surface;
                    super(0);
                }

                public final void invoke() {
                    if (GlStreamInterface.access$getSurfaceManager$p(this.this$0).isReady()) {
                        GlStreamInterface.access$getSurfaceManagerEncoder$p(this.this$0).release();
                        GlStreamInterface.access$getSurfaceManagerEncoder$p(this.this$0).eglSetup(this.$surface, GlStreamInterface.access$getSurfaceManager$p(this.this$0));
                    }
                }
            }));
        }
    }

    @Override
    public void removeMediaCodecSurface() {
        block0: {
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            ExtensionsKt.secureSubmit((ExecutorService)executorService, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GlStreamInterface this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GlStreamInterface.access$getSurfaceManagerEncoder$p(this.this$0).release();
                }
            }));
        }
    }

    @Override
    public void takePhoto(@Nullable TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    @Override
    public void start() {
        block0: {
            ExecutorService executorService = this.executor = Executors.newSingleThreadExecutor();
            if (executorService == null) break block0;
            ExtensionsKt.secureSubmit((ExecutorService)executorService, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GlStreamInterface this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GlStreamInterface.access$getSurfaceManager$p(this.this$0).release();
                    GlStreamInterface.access$getSurfaceManager$p(this.this$0).eglSetup();
                    GlStreamInterface.access$getSurfaceManager$p(this.this$0).makeCurrent();
                    GlStreamInterface.access$getMainRender$p(this.this$0).initGl(GlStreamInterface.access$getContext$p(this.this$0), GlStreamInterface.access$getEncoderWidth$p(this.this$0), GlStreamInterface.access$getEncoderHeight$p(this.this$0), GlStreamInterface.access$getEncoderWidth$p(this.this$0), GlStreamInterface.access$getEncoderHeight$p(this.this$0));
                    GlStreamInterface.access$getSurfaceManagerPhoto$p(this.this$0).release();
                    GlStreamInterface.access$getSurfaceManagerPhoto$p(this.this$0).eglSetup(GlStreamInterface.access$getEncoderWidth$p(this.this$0), GlStreamInterface.access$getEncoderHeight$p(this.this$0), GlStreamInterface.access$getSurfaceManager$p(this.this$0));
                    GlStreamInterface.access$setRunning$p(this.this$0, true);
                    GlStreamInterface.access$getMainRender$p(this.this$0).getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this.this$0);
                    GlStreamInterface.access$getForceRender$p(this.this$0).start((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ GlStreamInterface this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            block0: {
                                ExecutorService executorService = GlStreamInterface.access$getExecutor$p(this.this$0);
                                if (executorService == null) break block0;
                                executorService.execute(() -> start.1.invoke$lambda$0(this.this$0));
                            }
                        }

                        private static final void invoke$lambda$0(GlStreamInterface this$0) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            GlStreamInterface.access$draw(this$0, true);
                        }
                    }));
                    if (this.this$0.getAutoHandleOrientation()) {
                        GlStreamInterface.access$getSensorRotationManager$p(this.this$0).start();
                    }
                }
            }));
        }
    }

    @Override
    public void stop() {
        block0: {
            this.running = false;
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            ExtensionsKt.secureSubmit((ExecutorService)executorService, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GlStreamInterface this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GlStreamInterface.access$getForceRender$p(this.this$0).stop();
                    GlStreamInterface.access$getSensorRotationManager$p(this.this$0).stop();
                    GlStreamInterface.access$getSurfaceManagerPhoto$p(this.this$0).release();
                    GlStreamInterface.access$getSurfaceManagerEncoder$p(this.this$0).release();
                    GlStreamInterface.access$getSurfaceManager$p(this.this$0).release();
                    GlStreamInterface.access$getMainRender$p(this.this$0).release();
                    ExecutorService executorService = GlStreamInterface.access$getExecutor$p(this.this$0);
                    if (executorService != null) {
                        executorService.shutdownNow();
                    }
                    GlStreamInterface.access$setExecutor$p(this.this$0, null);
                }
            }));
        }
    }

    private final void draw(boolean forced) {
        int h;
        int w;
        if (!this.running || this.fpsLimiter.limitFPS()) {
            return;
        }
        if (!forced) {
            this.forceRender.frameAvailable();
        }
        if (this.surfaceManager.isReady() && this.mainRender.isReady()) {
            this.surfaceManager.makeCurrent();
            this.mainRender.updateFrame();
            this.mainRender.drawOffScreen();
            this.surfaceManager.swapBuffer();
        }
        if (!this.filterQueue.isEmpty() && this.mainRender.isReady()) {
            try {
                Filter filter = this.filterQueue.take();
                this.mainRender.setFilterAction(filter.filterAction, filter.position, filter.baseFilterRender);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        boolean orientation = switch (WhenMappings.$EnumSwitchMapping$0[this.orientationForced.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> this.isPortrait;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (this.surfaceManagerEncoder.isReady() && this.mainRender.isReady()) {
            w = this.muteVideo ? 0 : this.encoderWidth;
            h = this.muteVideo ? 0 : this.encoderHeight;
            this.surfaceManagerEncoder.makeCurrent();
            this.mainRender.drawScreenEncoder(w, h, orientation, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
            this.surfaceManagerEncoder.swapBuffer();
        }
        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady() && this.mainRender.isReady()) {
            this.surfaceManagerPhoto.makeCurrent();
            this.mainRender.drawScreen(this.encoderWidth, this.encoderHeight, AspectRatioMode.NONE, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
            TakePhotoCallback takePhotoCallback = this.takePhotoCallback;
            if (takePhotoCallback != null) {
                takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
            }
            this.takePhotoCallback = null;
            this.surfaceManagerPhoto.swapBuffer();
        }
        if (this.surfaceManagerPreview.isReady() && this.mainRender.isReady()) {
            w = this.previewWidth == 0 ? this.encoderWidth : this.previewWidth;
            h = this.previewHeight == 0 ? this.encoderHeight : this.previewHeight;
            this.surfaceManagerPreview.makeCurrent();
            this.mainRender.drawScreenPreview(w, h, orientation, this.aspectRatioMode, this.previewOrientation, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
            this.surfaceManagerPreview.swapBuffer();
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        block0: {
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            executorService.execute(() -> GlStreamInterface.onFrameAvailable$lambda$1(this));
        }
    }

    public final void forceOrientation(@NotNull OrientationForced forced) {
        Intrinsics.checkNotNullParameter((Object)((Object)forced), (String)"forced");
        this.orientationForced = forced;
    }

    public final void attachPreview(@NotNull Surface surface) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            ExtensionsKt.secureSubmit((ExecutorService)executorService, (Function0)((Function0)new Function0<Unit>(this, surface){
                final /* synthetic */ GlStreamInterface this$0;
                final /* synthetic */ Surface $surface;
                {
                    this.this$0 = $receiver;
                    this.$surface = $surface;
                    super(0);
                }

                public final void invoke() {
                    if (GlStreamInterface.access$getSurfaceManager$p(this.this$0).isReady()) {
                        GlStreamInterface.access$getSurfaceManagerPreview$p(this.this$0).release();
                        GlStreamInterface.access$getSurfaceManagerPreview$p(this.this$0).eglSetup(this.$surface, GlStreamInterface.access$getSurfaceManager$p(this.this$0));
                    }
                }
            }));
        }
    }

    public final void deAttachPreview() {
        block0: {
            ExecutorService executorService = this.executor;
            if (executorService == null) break block0;
            ExtensionsKt.secureSubmit((ExecutorService)executorService, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GlStreamInterface this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GlStreamInterface.access$getSurfaceManagerPreview$p(this.this$0).release();
                }
            }));
        }
    }

    @Override
    public void setStreamRotation(int orientation) {
        this.streamOrientation = orientation;
    }

    public final void setPreviewResolution(int width, int height, boolean isPortrait) {
        this.isPortrait = isPortrait;
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public static /* synthetic */ void setPreviewResolution$default(GlStreamInterface glStreamInterface, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = CameraHelper.isPortrait((Context)glStreamInterface.context);
        }
        glStreamInterface.setPreviewResolution(n, n2, bl);
    }

    public final void setPreviewRotation(int orientation) {
        this.previewOrientation = orientation;
    }

    public final void setCameraOrientation(int orientation) {
        this.mainRender.setCameraRotation(orientation);
    }

    @Override
    public void setFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.mainRender.filtersCount();
    }

    @Override
    public void setRotation(int rotation) {
        this.mainRender.setCameraRotation(rotation);
    }

    @Override
    public void forceFpsLimit(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public void setFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    public final void setAspectRatioMode(@NotNull AspectRatioMode aspectRatioMode) {
        Intrinsics.checkNotNullParameter((Object)aspectRatioMode, (String)"aspectRatioMode");
        this.aspectRatioMode = aspectRatioMode;
    }

    private static final void sensorRotationManager$lambda$0(GlStreamInterface this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.autoHandleOrientation) {
            this$0.setCameraOrientation(it);
        }
    }

    private static final void onFrameAvailable$lambda$1(GlStreamInterface this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.draw(false);
    }

    public static final /* synthetic */ SurfaceManager access$getSurfaceManager$p(GlStreamInterface $this) {
        return $this.surfaceManager;
    }

    public static final /* synthetic */ SurfaceManager access$getSurfaceManagerEncoder$p(GlStreamInterface $this) {
        return $this.surfaceManagerEncoder;
    }

    public static final /* synthetic */ MainRender access$getMainRender$p(GlStreamInterface $this) {
        return $this.mainRender;
    }

    public static final /* synthetic */ Context access$getContext$p(GlStreamInterface $this) {
        return $this.context;
    }

    public static final /* synthetic */ int access$getEncoderWidth$p(GlStreamInterface $this) {
        return $this.encoderWidth;
    }

    public static final /* synthetic */ int access$getEncoderHeight$p(GlStreamInterface $this) {
        return $this.encoderHeight;
    }

    public static final /* synthetic */ SurfaceManager access$getSurfaceManagerPhoto$p(GlStreamInterface $this) {
        return $this.surfaceManagerPhoto;
    }

    public static final /* synthetic */ void access$setRunning$p(GlStreamInterface $this, boolean bl) {
        $this.running = bl;
    }

    public static final /* synthetic */ ForceRenderer access$getForceRender$p(GlStreamInterface $this) {
        return $this.forceRender;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(GlStreamInterface $this) {
        return $this.executor;
    }

    public static final /* synthetic */ void access$draw(GlStreamInterface $this, boolean forced) {
        $this.draw(forced);
    }

    public static final /* synthetic */ SensorRotationManager access$getSensorRotationManager$p(GlStreamInterface $this) {
        return $this.sensorRotationManager;
    }

    public static final /* synthetic */ void access$setExecutor$p(GlStreamInterface $this, ExecutorService executorService) {
        $this.executor = executorService;
    }

    public static final /* synthetic */ SurfaceManager access$getSurfaceManagerPreview$p(GlStreamInterface $this) {
        return $this.surfaceManagerPreview;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrientationForced.values().length];
            try {
                nArray[OrientationForced.PORTRAIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrientationForced.LANDSCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrientationForced.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

