/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.StreamBase;
import com.pedro.library.srt.SrtStream;
import com.pedro.library.util.sources.audio.AudioSource;
import com.pedro.library.util.sources.audio.MicrophoneSource;
import com.pedro.library.util.sources.video.Camera2Source;
import com.pedro.library.util.sources.video.VideoSource;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.srt.srt.SrtClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u000f\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u00192\b\u0010#\u001a\u0004\u0018\u00010\u0019H\u0014J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\u0012H\u0014J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010)\u001a\u00020,H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/pedro/library/srt/SrtStream;", "Lcom/pedro/library/base/StreamBase;", "context", "Landroid/content/Context;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;)V", "videoSource", "Lcom/pedro/library/util/sources/video/VideoSource;", "audioSource", "Lcom/pedro/library/util/sources/audio/AudioSource;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;Lcom/pedro/library/util/sources/video/VideoSource;Lcom/pedro/library/util/sources/audio/AudioSource;)V", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "streamClientListener", "com/pedro/library/srt/SrtStream$streamClientListener$1", "Lcom/pedro/library/srt/SrtStream$streamClientListener$1;", "audioInfo", "", "sampleRate", "", "isStereo", "", "getAacDataRtp", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "getStreamClient", "Lcom/pedro/library/util/streamclient/SrtStreamClient;", "onSpsPpsVpsRtp", "sps", "pps", "vps", "rtpStartStream", "endPoint", "", "rtpStopStream", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "Lcom/pedro/common/VideoCodec;", "library_release"})
@RequiresApi(value=21)
public final class SrtStream
extends StreamBase {
    @NotNull
    private final SrtClient srtClient;
    @NotNull
    private final streamClientListener.1 streamClientListener;

    public SrtStream(@NotNull Context context, @NotNull ConnectChecker connectChecker, @NotNull VideoSource videoSource, @NotNull AudioSource audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)audioSource, (String)"audioSource");
        super(context, videoSource, audioSource);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ SrtStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyframe();
            }
        };
    }

    @Override
    @NotNull
    public SrtStreamClient getStreamClient() {
        return new SrtStreamClient(this.srtClient, this.streamClientListener);
    }

    public SrtStream(@NotNull Context context, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        this(context, connectChecker, new Camera2Source(context), new MicrophoneSource());
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.srtClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.srtClient.setAudioCodec(codec);
    }

    @Override
    protected void audioInfo(int sampleRate, boolean isStereo) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void rtpStartStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        SrtClient.connect$default((SrtClient)this.srtClient, (String)endPoint, (boolean)false, (int)2, null);
    }

    @Override
    protected void rtpStopStream() {
        this.srtClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.srtClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.srtClient.sendAudio(aacBuffer, info);
    }
}

