/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.media.MediaCodec;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.library.base.OnlyAudioBase;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.srt.srt.SrtClient;
import java.nio.ByteBuffer;

public class SrtOnlyAudio
extends OnlyAudioBase {
    private final SrtClient srtClient;
    private final SrtStreamClient streamClient;

    public SrtOnlyAudio(ConnectChecker connectChecker) {
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new SrtStreamClient(this.srtClient, null);
        this.streamClient.setOnlyAudio(true);
    }

    @Override
    public SrtStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.srtClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.srtClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srtClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srtClient.sendAudio(aacBuffer, info);
    }
}

