/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class RtmpFromFile
extends FromFileBase {
    private final RtmpClient rtmpClient;
    private final RtmpStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public RtmpFromFile(ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    public RtmpFromFile(Context context, ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    public RtmpFromFile(OpenGlView openGlView, ConnectChecker connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtmpClient = new RtmpClient(connectChecker);
        this.streamClient = new RtmpStreamClient(this.rtmpClient, this.streamClientListener);
    }

    @Override
    public RtmpStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        this.rtmpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.rtmpClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.rtmpClient.setFps(this.videoEncoder.getFps());
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }
}

