/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.generic;

import android.media.MediaCodec;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.library.base.OnlyAudioBase;
import com.pedro.library.generic.ClientType;
import com.pedro.library.util.streamclient.GenericStreamClient;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import com.pedro.udp.UdpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/pedro/library/generic/GenericOnlyAudio;", "Lcom/pedro/library/base/OnlyAudioBase;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "(Lcom/pedro/common/ConnectChecker;)V", "connectedType", "Lcom/pedro/library/generic/ClientType;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "streamClient", "Lcom/pedro/library/util/streamclient/GenericStreamClient;", "udpClient", "Lcom/pedro/udp/UdpClient;", "getAacDataRtp", "", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getStreamClient", "prepareAudioRtp", "isStereo", "", "sampleRate", "", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "startStreamRtp", "url", "", "stopStreamRtp", "library_release"})
public final class GenericOnlyAudio
extends OnlyAudioBase {
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final RtmpClient rtmpClient;
    @NotNull
    private final RtspClient rtspClient;
    @NotNull
    private final SrtClient srtClient;
    @NotNull
    private final UdpClient udpClient;
    @NotNull
    private final GenericStreamClient streamClient;
    @NotNull
    private ClientType connectedType;

    /*
     * WARNING - void declaration
     */
    public GenericOnlyAudio(@NotNull ConnectChecker connectChecker) {
        void $this$streamClient_u24lambda_u240;
        GenericStreamClient genericStreamClient;
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        this.connectChecker = connectChecker;
        this.rtmpClient = new RtmpClient(this.connectChecker);
        this.rtspClient = new RtspClient(this.connectChecker);
        this.srtClient = new SrtClient(this.connectChecker);
        this.udpClient = new UdpClient(this.connectChecker);
        GenericStreamClient genericStreamClient2 = genericStreamClient = new GenericStreamClient(new RtmpStreamClient(this.rtmpClient, null), new RtspStreamClient(this.rtspClient, null), new SrtStreamClient(this.srtClient, null), new UdpStreamClient(this.udpClient, null));
        GenericOnlyAudio genericOnlyAudio = this;
        boolean bl = false;
        $this$streamClient_u24lambda_u240.setOnlyAudio(true);
        genericOnlyAudio.streamClient = genericStreamClient;
        this.connectedType = ClientType.NONE;
    }

    @Override
    @NotNull
    public GenericStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != AudioCodec.AAC) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support audio AAC");
        }
        this.rtmpClient.setAudioCodec(codec);
        this.rtspClient.setAudioCodec(codec);
        this.srtClient.setAudioCodec(codec);
        this.udpClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
        this.srtClient.setAudioInfo(sampleRate, isStereo);
        this.udpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.streamClient.connecting(url);
        if (StringsKt.startsWith((String)url, (String)"rtmp", (boolean)true)) {
            this.connectedType = ClientType.RTMP;
            this.rtmpClient.connect(url);
        } else if (StringsKt.startsWith((String)url, (String)"rtsp", (boolean)true)) {
            this.connectedType = ClientType.RTSP;
            this.rtspClient.connect(url);
        } else if (StringsKt.startsWith((String)url, (String)"srt", (boolean)true)) {
            this.connectedType = ClientType.SRT;
            SrtClient.connect$default((SrtClient)this.srtClient, (String)url, (boolean)false, (int)2, null);
        } else if (StringsKt.startsWith((String)url, (String)"udp", (boolean)true)) {
            this.connectedType = ClientType.UDP;
            UdpClient.connect$default((UdpClient)this.udpClient, (String)url, (boolean)false, (int)2, null);
        } else {
            ExtensionsKt.onMainThreadHandler((Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GenericOnlyAudio this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GenericOnlyAudio.access$getConnectChecker$p(this.this$0).onConnectionFailed("Unsupported protocol. Only support rtmp, rtsp and srt");
                }
            }));
        }
    }

    @Override
    protected void stopStreamRtp() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.disconnect();
                break;
            }
            case 2: {
                this.rtspClient.disconnect();
                break;
            }
            case 3: {
                this.srtClient.disconnect();
                break;
            }
            case 4: {
                this.udpClient.disconnect();
            }
        }
        this.connectedType = ClientType.NONE;
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.sendAudio(aacBuffer, info);
                break;
            }
            case 2: {
                this.rtspClient.sendAudio(aacBuffer, info);
                break;
            }
            case 3: {
                this.srtClient.sendAudio(aacBuffer, info);
                break;
            }
            case 4: {
                this.udpClient.sendAudio(aacBuffer, info);
            }
        }
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(GenericOnlyAudio $this) {
        return $this.connectChecker;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientType.values().length];
            try {
                nArray[ClientType.RTMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.RTSP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.SRT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.UDP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

