/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoder;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.GlStreamInterface;
import com.pedro.library.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public abstract class FromFileBase {
    private static final String TAG = "FromFileBase";
    protected VideoEncoder videoEncoder;
    private AudioEncoder audioEncoder;
    private GlInterface glInterface;
    private boolean streaming = false;
    protected BaseRecordController recordController;
    private final FpsListener fpsListener = new FpsListener();
    private VideoDecoder videoDecoder;
    private AudioDecoder audioDecoder;
    protected boolean videoEnabled = false;
    private boolean audioEnabled = false;
    private AudioTrack audioTrackPlayer;
    private final GetMicrophoneData getMicrophoneData = frame -> {
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.write(frame.getBuffer(), frame.getOffset(), frame.getSize());
        }
        this.audioEncoder.inputPCMData(frame);
    };
    private final GetAacData getAacData = new GetAacData(){

        public void getAacData(@NonNull ByteBuffer aacBuffer, @NonNull MediaCodec.BufferInfo info) {
            FromFileBase.this.recordController.recordAudio(aacBuffer, info);
            if (FromFileBase.this.streaming) {
                FromFileBase.this.getAacDataRtp(aacBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            FromFileBase.this.recordController.setAudioFormat(mediaFormat, !FromFileBase.this.videoEnabled);
        }
    };
    private final GetVideoData getVideoData = new GetVideoData(){

        public void onSpsPpsVps(@NonNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
            FromFileBase.this.onSpsPpsVpsRtp(sps.duplicate(), pps != null ? pps.duplicate() : null, vps != null ? vps.duplicate() : null);
        }

        public void getVideoData(@NonNull ByteBuffer h264Buffer, @NonNull MediaCodec.BufferInfo info) {
            FromFileBase.this.fpsListener.calculateFps();
            FromFileBase.this.recordController.recordVideo(h264Buffer, info);
            if (FromFileBase.this.streaming) {
                FromFileBase.this.getH264DataRtp(h264Buffer, info);
            }
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            FromFileBase.this.recordController.setVideoFormat(mediaFormat, !FromFileBase.this.audioEnabled);
        }
    };
    private final DecoderInterface decoderInterface = new DecoderInterface(){
        private int trackFinished = 0;

        public void onLoop() {
            int maxTracks = 0;
            if (FromFileBase.this.audioEnabled) {
                ++maxTracks;
            }
            if (FromFileBase.this.videoEnabled) {
                ++maxTracks;
            }
            ++this.trackFinished;
            if (this.trackFinished >= maxTracks) {
                FromFileBase.this.reSyncFile();
                this.trackFinished = 0;
            }
        }
    };

    public FromFileBase(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(Context context, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = new GlStreamInterface(context);
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(OpenGlView openGlView, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = openGlView;
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    private void init(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.videoEncoder = new VideoEncoder(this.getVideoData);
        this.audioEncoder = new AudioEncoder(this.getAacData);
        this.videoDecoder = new VideoDecoder(videoDecoderInterface, this.decoderInterface);
        this.audioDecoder = new AudioDecoder(this.getMicrophoneData, audioDecoderInterface, this.decoderInterface);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setFpsListener(FpsListener.Callback callback2) {
        this.fpsListener.setCallback(callback2);
    }

    public boolean prepareVideo(String filePath, int bitRate, int rotation, int profile, int level) throws IOException {
        if (!this.videoDecoder.initExtractor(filePath)) {
            return false;
        }
        return this.finishPrepareVideo(bitRate, rotation, profile, level);
    }

    public boolean prepareVideo(FileDescriptor fileDescriptor, int bitRate, int rotation, int profile, int level) throws IOException {
        if (!this.videoDecoder.initExtractor(fileDescriptor)) {
            return false;
        }
        return this.finishPrepareVideo(bitRate, rotation, profile, level);
    }

    public boolean prepareVideo(Context context, Uri uri, int bitRate, int rotation, int profile, int level) throws IOException {
        if (!this.videoDecoder.initExtractor(context, uri, null)) {
            return false;
        }
        return this.finishPrepareVideo(bitRate, rotation, profile, level);
    }

    public boolean prepareVideo(String filePath, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(filePath, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(FileDescriptor fileDescriptor, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(fileDescriptor, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(String filePath) throws IOException {
        return this.prepareVideo(filePath, 1228800, 0);
    }

    public boolean prepareVideo(Context context, Uri uri, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(context, uri, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(Context context, Uri uri) throws IOException {
        return this.prepareVideo(context, uri, 1228800, 0);
    }

    public boolean prepareVideo(FileDescriptor fileDescriptor) throws IOException {
        return this.prepareVideo(fileDescriptor, 1228800, 0);
    }

    private boolean finishPrepareVideo(int bitRate, int rotation, int profile, int level) {
        boolean result = this.videoEncoder.prepareVideoEncoder(this.videoDecoder.getWidth(), this.videoDecoder.getHeight(), this.videoDecoder.getFps(), bitRate, rotation, 2, FormatVideoEncoder.SURFACE, profile, level);
        if (!result) {
            return false;
        }
        this.videoEnabled = result = this.videoDecoder.prepareVideo(this.videoEncoder.getInputSurface());
        return result;
    }

    public boolean prepareAudio(String filePath, int bitRate) throws IOException {
        if (!this.audioDecoder.initExtractor(filePath)) {
            return false;
        }
        return this.finishPrepareAudio(bitRate);
    }

    public boolean prepareAudio(FileDescriptor fileDescriptor, int bitRate) throws IOException {
        if (!this.audioDecoder.initExtractor(fileDescriptor)) {
            return false;
        }
        return this.finishPrepareAudio(bitRate);
    }

    public boolean prepareAudio(Context context, Uri uri, int bitRate) throws IOException {
        if (!this.audioDecoder.initExtractor(context, uri, null)) {
            return false;
        }
        return this.finishPrepareAudio(bitRate);
    }

    private boolean finishPrepareAudio(int bitRate) {
        this.audioDecoder.prepareAudio();
        boolean result = this.audioEncoder.prepareAudioEncoder(bitRate, this.audioDecoder.getSampleRate(), this.audioDecoder.isStereo(), this.audioDecoder.getOutsize());
        this.prepareAudioRtp(this.audioDecoder.isStereo(), this.audioDecoder.getSampleRate());
        this.audioEnabled = result;
        return result;
    }

    public boolean isAudioDeviceEnabled() {
        return this.audioTrackPlayer != null && this.audioTrackPlayer.getPlayState() == 3;
    }

    public void setEncoderErrorCallback(EncoderErrorCallback encoderErrorCallback) {
        this.videoEncoder.setEncoderErrorCallback(encoderErrorCallback);
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void playAudioDevice() {
        if (this.audioEnabled) {
            if (this.isAudioDeviceEnabled()) {
                this.audioTrackPlayer.stop();
            }
            int channel = this.audioDecoder.isStereo() ? 12 : 4;
            int buffSize = AudioTrack.getMinBufferSize((int)this.audioDecoder.getSampleRate(), (int)channel, (int)2);
            this.audioTrackPlayer = new AudioTrack(3, this.audioDecoder.getSampleRate(), channel, 2, buffSize, 1);
            this.audioTrackPlayer.play();
        }
    }

    public void stopAudioDevice() {
        if (this.audioEnabled && this.isAudioDeviceEnabled()) {
            this.audioTrackPlayer.stop();
            this.audioTrackPlayer = null;
        }
    }

    public boolean prepareAudio(String filePath) throws IOException {
        return this.prepareAudio(filePath, 65536);
    }

    public boolean prepareAudio(Context context, Uri uri) throws IOException {
        return this.prepareAudio(context, uri, 65536);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public void forceCodecType(CodecUtil.CodecType codecTypeVideo, CodecUtil.CodecType codecTypeAudio) {
        if (this.videoEnabled) {
            this.videoEncoder.forceCodecType(codecTypeVideo);
        }
        if (this.audioEnabled) {
            this.audioEncoder.forceCodecType(codecTypeAudio);
        }
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else if (this.videoEnabled) {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
    }

    private void startEncoders() {
        if (this.videoEnabled) {
            this.videoEncoder.start();
        }
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.play();
        }
        if (this.audioEnabled) {
            this.audioEncoder.start();
        }
        if (this.videoEnabled) {
            this.prepareGlView();
        }
        if (this.videoEnabled) {
            this.videoDecoder.start();
        }
        if (this.audioEnabled) {
            this.audioDecoder.start();
        }
    }

    public void replaceView(Context context) {
        this.replaceGlInterface(new GlStreamInterface(context));
    }

    public void replaceView(OpenGlView openGlView) {
        this.replaceGlInterface(openGlView);
    }

    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && this.videoEnabled) {
            if (this.isStreaming() || this.isRecording()) {
                this.videoDecoder.pauseRender();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                this.prepareGlView();
                this.videoDecoder.resumeRender();
            } else {
                this.glInterface = glInterface;
            }
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null) {
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.glInterface.setRotation(0);
            this.glInterface.start();
            if (this.videoEncoder.getInputSurface() != null) {
                this.videoDecoder.changeOutputSurface(this.glInterface.getSurface());
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
        }
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.videoEncoder.requestKeyframe();
            } else {
                if (this.glInterface != null) {
                    this.glInterface.removeMediaCodecSurface();
                }
                this.videoEncoder.reset();
                if (this.glInterface != null) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                } else {
                    this.videoDecoder.changeOutputSurface(this.videoEncoder.getInputSurface());
                }
            }
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            if (this.videoEnabled) {
                this.videoDecoder.stop();
            }
            if (this.audioEnabled) {
                this.audioDecoder.stop();
            }
            if (this.audioEnabled && this.isAudioDeviceEnabled()) {
                this.audioTrackPlayer.stop();
            }
            this.audioTrackPlayer = null;
            if (this.videoEnabled) {
                this.videoEncoder.stop();
            }
            if (this.audioEnabled) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
            this.videoEnabled = false;
            this.audioEnabled = false;
        }
    }

    public void setLoopMode(boolean loopMode) {
        this.videoDecoder.setLoopMode(loopMode);
        this.audioDecoder.setLoopMode(loopMode);
    }

    public void reSyncFile() {
        if (this.isStreaming() && this.videoEnabled && this.audioEnabled) {
            this.audioDecoder.moveTo(this.videoDecoder.getTime());
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.videoEncoder.getFps() : 0;
        this.videoEncoder.setForceFps(fps);
        if (this.glInterface != null) {
            this.glInterface.forceFpsLimit(fps);
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public double getVideoTime() {
        return this.videoDecoder.getTime();
    }

    public double getAudioTime() {
        return this.audioDecoder.getTime();
    }

    public double getVideoDuration() {
        return this.videoDecoder.getDuration();
    }

    public double getAudioDuration() {
        return this.audioDecoder.getDuration();
    }

    public void moveTo(double time) {
        if (this.videoEnabled) {
            this.videoDecoder.moveTo(time);
        }
        if (this.audioEnabled) {
            this.audioDecoder.moveTo(time);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract StreamBaseClient getStreamClient();

    public void setVideoCodec(VideoCodec codec) {
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case VideoCodec.H264 -> "video/avc";
            case VideoCodec.H265 -> "video/hevc";
            case VideoCodec.AV1 -> "video/av01";
        };
        this.videoEncoder.setType(type);
    }

    public void setAudioCodec(AudioCodec codec) {
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case AudioCodec.G711 -> "audio/g711-alaw";
            case AudioCodec.AAC -> "audio/mp4a-latm";
            case AudioCodec.OPUS -> "audio/opus";
        };
        this.audioEncoder.setType(type);
    }

    protected abstract void setVideoCodecImp(VideoCodec var1);

    protected abstract void setAudioCodecImp(AudioCodec var1);
}

