/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.SimpleCameraRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.R;
import com.pedro.library.view.OpenGlViewBase;

@RequiresApi(api=18)
public class LightOpenGlView
extends OpenGlViewBase {
    private final SimpleCameraRender simpleCameraRender = new SimpleCameraRender();
    private AspectRatioMode aspectRatioMode = AspectRatioMode.Adjust;

    public LightOpenGlView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightOpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LightOpenGlView);
        try {
            this.aspectRatioMode = AspectRatioMode.Companion.fromId(typedArray.getInt(R.styleable.OpenGlView_aspectRatioMode, AspectRatioMode.NONE.ordinal()));
            boolean isFlipHorizontal = typedArray.getBoolean(R.styleable.LightOpenGlView_isFlipHorizontal, false);
            boolean isFlipVertical = typedArray.getBoolean(R.styleable.LightOpenGlView_isFlipVertical, false);
            this.simpleCameraRender.setFlip(isFlipHorizontal, isFlipVertical);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setAspectRatioMode(AspectRatioMode aspectRatioMode) {
        this.aspectRatioMode = aspectRatioMode;
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.simpleCameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)"OpenGlViewBase", (String)("size: " + width + "x" + height));
        this.previewWidth = width;
        this.previewHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.surfaceManager.release();
        this.surfaceManager.eglSetup(this.getHolder().getSurface());
        this.surfaceManager.makeCurrent();
        this.simpleCameraRender.initGl(this.getContext(), this.encoderWidth, this.encoderHeight);
        this.simpleCameraRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.surfaceManagerPhoto.release();
        this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
        this.semaphore.release();
        try {
            while (this.running) {
                Object object;
                this.fpsLimiter.setFrameStartTs();
                if (this.frameAvailable || this.forceRender) {
                    this.frameAvailable = false;
                    this.surfaceManager.makeCurrent();
                    this.simpleCameraRender.updateFrame();
                    this.simpleCameraRender.drawFrame(this.previewWidth, this.previewHeight, this.aspectRatioMode, 0, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
                    this.surfaceManager.swapBuffer();
                    object = this.sync;
                    synchronized (object) {
                        if (this.surfaceManagerEncoder.isReady() && !this.fpsLimiter.limitFPS()) {
                            int w = this.muteVideo ? 0 : this.encoderWidth;
                            int h = this.muteVideo ? 0 : this.encoderHeight;
                            this.surfaceManagerEncoder.makeCurrent();
                            this.simpleCameraRender.drawFrame(w, h, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                            this.surfaceManagerEncoder.swapBuffer();
                        }
                        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady()) {
                            this.surfaceManagerPhoto.makeCurrent();
                            this.simpleCameraRender.drawFrame(this.encoderWidth, this.encoderHeight, this.aspectRatioMode, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                            this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
                            this.takePhotoCallback = null;
                            this.surfaceManagerPhoto.swapBuffer();
                        }
                    }
                }
                object = this.sync;
                synchronized (object) {
                    long sleep = this.fpsLimiter.getSleepTime();
                    if (sleep > 0L) {
                        this.sync.wait(sleep);
                    }
                }
            }
            return;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.simpleCameraRender.release();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
        }
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.simpleCameraRender.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.simpleCameraRender.getSurface();
    }

    @Override
    public void setFilter(int filterPosition, BaseFilterRender baseFilterRender) {
        throw new RuntimeException("Filters are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of filters");
    }

    @Override
    public void addFilter(BaseFilterRender baseFilterRender) {
        throw new RuntimeException("Filters are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of filters");
    }

    @Override
    public void addFilter(int filterPosition, BaseFilterRender baseFilterRender) {
        throw new RuntimeException("Filters are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of filters");
    }

    @Override
    public void clearFilters() {
        throw new RuntimeException("Filters are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of filters");
    }

    @Override
    public void removeFilter(int filterPosition) {
        throw new RuntimeException("Filters are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of filters");
    }

    @Override
    public void removeFilter(BaseFilterRender baseFilterRender) {
        throw new RuntimeException("Filters are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of filters");
    }

    @Override
    public int filtersCount() {
        return 0;
    }

    @Override
    public void setFilter(BaseFilterRender baseFilterRender) {
        this.addFilter(baseFilterRender);
    }

    @Override
    public void enableAA(boolean AAEnabled) {
        throw new RuntimeException("AA are not allowed when using LightOpenGlView. Replace it with OpenGlView to enable the use of AA");
    }

    @Override
    public void setRotation(int rotation) {
        this.simpleCameraRender.setRotation(rotation);
    }

    @Override
    public boolean isAAEnabled() {
        return false;
    }
}

