/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.rtsp.VideoCodec;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class RtspFromFile
extends FromFileBase {
    private final RtspClient rtspClient;
    private final RtspStreamClient streamClient;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;

    public RtspFromFile(ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspFromFile(Context context, ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspFromFile(OpenGlView openGlView, ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspFromFile(LightOpenGlView lightOpenGlView, ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(lightOpenGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
        this.streamClient = new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setOnlyAudio(!this.videoEnabled);
        this.rtspClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }
}

