/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.projection.MediaProjection;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.StreamBase;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.sources.AudioManager;
import com.pedro.library.util.sources.VideoManager;
import com.pedro.library.view.GlStreamInterface;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e3\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u0019\b'\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020 H$J\u0006\u00105\u001a\u000201J\u0010\u00106\u001a\u0002012\u0006\u00107\u001a\u000208H\u0007J\u0006\u00109\u001a\u000201J\u000e\u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020\u0005J\u0006\u0010<\u001a\u000201J\u000e\u0010=\u001a\u0002012\u0006\u00107\u001a\u000208J\u0006\u0010>\u001a\u000201J\u0006\u0010?\u001a\u000201J\u0006\u0010@\u001a\u000201J\u0006\u0010A\u001a\u000201J\u0018\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH$J\u0006\u0010G\u001a\u00020HJ\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010L\u001a\u00020HJ\u0006\u0010M\u001a\u000203J\u0006\u0010N\u001a\u00020\u001eJ\u0018\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020D2\u0006\u0010E\u001a\u00020FH$J\u0006\u0010Q\u001a\u00020RJ\b\u0010S\u001a\u000203H\u0004J\b\u0010T\u001a\u00020KH\u0004J\u0006\u0010U\u001a\u00020VJ\f\u0010W\u001a\b\u0012\u0004\u0012\u00020V0XJ\u0006\u0010Y\u001a\u00020 J\u0006\u0010Z\u001a\u00020 J\u0006\u0010[\u001a\u00020 J\u0006\u0010\\\u001a\u000201J\"\u0010]\u001a\u0002012\u0006\u0010^\u001a\u00020D2\u0006\u0010_\u001a\u00020D2\b\u0010`\u001a\u0004\u0018\u00010DH$J4\u0010a\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020 2\u0006\u0010b\u001a\u0002032\b\b\u0002\u0010c\u001a\u00020 2\b\b\u0002\u0010d\u001a\u00020 H\u0007J\b\u0010e\u001a\u00020 H\u0002JH\u0010f\u001a\u00020 2\u0006\u0010g\u001a\u0002032\u0006\u0010h\u001a\u0002032\u0006\u0010b\u001a\u0002032\b\b\u0002\u0010i\u001a\u0002032\b\b\u0002\u0010j\u001a\u0002032\b\b\u0002\u0010k\u001a\u0002032\b\b\u0002\u0010l\u001a\u000203H\u0007J\u0006\u0010m\u001a\u000201J\u0010\u0010n\u001a\u0002012\u0006\u0010o\u001a\u00020pH$J\b\u0010q\u001a\u000201H$J\u000e\u0010r\u001a\u0002012\u0006\u0010s\u001a\u000203J\u0010\u0010t\u001a\u0002012\b\u0010u\u001a\u0004\u0018\u00010vJ\u000e\u0010w\u001a\u0002012\u0006\u0010x\u001a\u000203J\u000e\u0010y\u001a\u0002012\u0006\u0010z\u001a\u000203J\u000e\u0010{\u001a\u0002012\u0006\u0010%\u001a\u00020&J\u0010\u0010|\u001a\u0002012\u0006\u0010}\u001a\u00020pH\u0004J\u000f\u0010~\u001a\u0002012\u0007\u0010\u007f\u001a\u00030\u0080\u0001J\u000e\u0010~\u001a\u0002012\u0006\u0010x\u001a\u00020VJ \u0010\u0081\u0001\u001a\u0002012\u0007\u0010\u0082\u0001\u001a\u00020R2\u0006\u0010g\u001a\u0002032\u0006\u0010h\u001a\u000203J!\u0010\u0081\u0001\u001a\u0002012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010g\u001a\u0002032\u0006\u0010h\u001a\u000203J\u0011\u0010\u0081\u0001\u001a\u0002012\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001J\u0011\u0010\u0081\u0001\u001a\u0002012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J\u001a\u0010\u0089\u0001\u001a\u0002012\u0007\u0010\u008a\u0001\u001a\u00020p2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001J\t\u0010\u008d\u0001\u001a\u000201H\u0002J\u000f\u0010\u008e\u0001\u001a\u0002012\u0006\u0010o\u001a\u00020pJ\u0007\u0010\u008f\u0001\u001a\u000201J\u0007\u0010\u0090\u0001\u001a\u00020 J\t\u0010\u0091\u0001\u001a\u000201H\u0002J\u0007\u0010\u0092\u0001\u001a\u00020 J\u0007\u0010\u0093\u0001\u001a\u000201J\u0007\u0010\u0094\u0001\u001a\u000201R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u001e\u0010$\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u000e\u001a\u0004\b)\u0010*R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006\u0095\u0001"}, d2={"Lcom/pedro/library/base/StreamBase;", "", "context", "Landroid/content/Context;", "videoSource", "Lcom/pedro/library/util/sources/VideoManager$Source;", "audioSource", "Lcom/pedro/library/util/sources/AudioManager$Source;", "(Landroid/content/Context;Lcom/pedro/library/util/sources/VideoManager$Source;Lcom/pedro/library/util/sources/AudioManager$Source;)V", "audioEncoder", "Lcom/pedro/encoder/audio/AudioEncoder;", "getAudioEncoder", "()Lcom/pedro/encoder/audio/AudioEncoder;", "audioEncoder$delegate", "Lkotlin/Lazy;", "audioManager", "Lcom/pedro/library/util/sources/AudioManager;", "getAudioManager", "()Lcom/pedro/library/util/sources/AudioManager;", "audioManager$delegate", "getAudioSource", "()Lcom/pedro/library/util/sources/AudioManager$Source;", "getAacData", "Lcom/pedro/encoder/audio/GetAacData;", "getMicrophoneData", "com/pedro/library/base/StreamBase$getMicrophoneData$1", "Lcom/pedro/library/base/StreamBase$getMicrophoneData$1;", "getVideoData", "Lcom/pedro/encoder/video/GetVideoData;", "glInterface", "Lcom/pedro/library/view/GlStreamInterface;", "<set-?>", "", "isOnPreview", "()Z", "isRecording", "isStreaming", "recordController", "Lcom/pedro/library/base/recording/BaseRecordController;", "videoEncoder", "Lcom/pedro/encoder/video/VideoEncoder;", "getVideoEncoder", "()Lcom/pedro/encoder/video/VideoEncoder;", "videoEncoder$delegate", "videoManager", "Lcom/pedro/library/util/sources/VideoManager;", "getVideoSource", "()Lcom/pedro/library/util/sources/VideoManager$Source;", "audioInfo", "", "sampleRate", "", "isStereo", "changeAudioSourceDisabled", "changeAudioSourceInternal", "mediaProjection", "Landroid/media/projection/MediaProjection;", "changeAudioSourceMicrophone", "changeVideoSourceCamera", "source", "changeVideoSourceDisabled", "changeVideoSourceScreen", "disableAutoFocus", "disableLantern", "enableAutoFocus", "enableLantern", "getAacDataRtp", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getCameraFacing", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "getCameraResolutions", "", "Landroid/util/Size;", "facing", "getExposure", "getGlInterface", "getH264DataRtp", "h264Buffer", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "getVideoFps", "getVideoResolution", "getZoom", "", "getZoomRange", "Landroid/util/Range;", "isAutoFocusEnabled", "isLanternEnabled", "isMuted", "mute", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudio", "bitrate", "echoCanceler", "noiseSuppressor", "prepareEncoders", "prepareVideo", "width", "height", "fps", "iFrameInterval", "avcProfile", "avcProfileLevel", "requestKeyframe", "rtpStartStream", "endPoint", "", "rtpStopStream", "setAudioMaxInputSize", "size", "setEncoderErrorCallback", "encoderErrorCallback", "Lcom/pedro/encoder/EncoderErrorCallback;", "setExposure", "level", "setOrientation", "orientation", "setRecordController", "setVideoMime", "videoMime", "setZoom", "event", "Landroid/view/MotionEvent;", "startPreview", "surfaceTexture", "surface", "Landroid/view/Surface;", "surfaceView", "Landroid/view/SurfaceView;", "textureView", "Landroid/view/TextureView;", "startRecord", "path", "listener", "Lcom/pedro/library/base/recording/RecordController$Listener;", "startSources", "startStream", "stopPreview", "stopRecord", "stopSources", "stopStream", "switchCamera", "unMute", "library_release"})
@RequiresApi(value=21)
public abstract class StreamBase {
    @NotNull
    private final getMicrophoneData.1 getMicrophoneData;
    @NotNull
    private final Lazy videoEncoder$delegate;
    @NotNull
    private final Lazy audioEncoder$delegate;
    @NotNull
    private final GlStreamInterface glInterface;
    @NotNull
    private final VideoManager videoManager;
    @NotNull
    private final Lazy audioManager$delegate;
    @NotNull
    private BaseRecordController recordController;
    private boolean isStreaming;
    private boolean isOnPreview;
    @NotNull
    private final VideoManager.Source videoSource;
    @NotNull
    private final AudioManager.Source audioSource;
    @NotNull
    private final GetAacData getAacData;
    @NotNull
    private final GetVideoData getVideoData;

    public StreamBase(@NotNull Context context, @NotNull VideoManager.Source videoSource, @NotNull AudioManager.Source audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)videoSource), (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)((Object)audioSource), (String)"audioSource");
        this.getMicrophoneData = new GetMicrophoneData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputPCMData(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                StreamBase.access$getAudioEncoder(this.this$0).inputPCMData(frame);
            }
        };
        this.videoEncoder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VideoEncoder>(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VideoEncoder invoke() {
                return new VideoEncoder(StreamBase.access$getGetVideoData$p(this.this$0));
            }
        }));
        this.audioEncoder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AudioEncoder>(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AudioEncoder invoke() {
                return new AudioEncoder(StreamBase.access$getGetAacData$p(this.this$0));
            }
        }));
        this.glInterface = new GlStreamInterface(context);
        this.videoManager = new VideoManager(context, videoSource);
        this.audioManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AudioManager>(this, audioSource){
            final /* synthetic */ StreamBase this$0;
            final /* synthetic */ AudioManager.Source $audioSource;
            {
                this.this$0 = $receiver;
                this.$audioSource = $audioSource;
                super(0);
            }

            @NotNull
            public final AudioManager invoke() {
                return new AudioManager(StreamBase.access$getGetMicrophoneData$p(this.this$0), this.$audioSource);
            }
        }));
        this.recordController = new AndroidMuxerRecordController();
        this.videoSource = this.videoManager.getSource();
        this.audioSource = this.getAudioManager().getSource();
        this.glInterface.init();
        this.getAacData = new GetAacData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void getAacData(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.this$0.getAacDataRtp(aacBuffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordAudio(aacBuffer, info);
            }

            public void onAudioFormat(@NotNull MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                StreamBase.access$getRecordController$p(this.this$0).setAudioFormat(mediaFormat);
            }
        };
        this.getVideoData = new GetVideoData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSpsPpsVps(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
                Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
                Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
                ByteBuffer byteBuffer = sps.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
                ByteBuffer byteBuffer2 = pps.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"duplicate(...)");
                ByteBuffer byteBuffer3 = vps;
                this.this$0.onSpsPpsVpsRtp(byteBuffer, byteBuffer2, byteBuffer3 != null ? byteBuffer3.duplicate() : null);
            }

            public void getVideoData(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.this$0.getH264DataRtp(h264Buffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordVideo(h264Buffer, info);
            }

            public void onVideoFormat(@NotNull MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                StreamBase.access$getRecordController$p(this.this$0).setVideoFormat(mediaFormat);
            }
        };
    }

    private final VideoEncoder getVideoEncoder() {
        Lazy lazy = this.videoEncoder$delegate;
        return (VideoEncoder)lazy.getValue();
    }

    private final AudioEncoder getAudioEncoder() {
        Lazy lazy = this.audioEncoder$delegate;
        return (AudioEncoder)lazy.getValue();
    }

    private final AudioManager getAudioManager() {
        Lazy lazy = this.audioManager$delegate;
        return (AudioManager)lazy.getValue();
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final boolean isOnPreview() {
        return this.isOnPreview;
    }

    public final boolean isRecording() {
        return this.recordController.isRunning();
    }

    @NotNull
    public final VideoManager.Source getVideoSource() {
        return this.videoSource;
    }

    @NotNull
    public final AudioManager.Source getAudioSource() {
        return this.audioSource;
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int avcProfile, int avcProfileLevel) {
        boolean videoResult = this.videoManager.createVideoManager(width, height, fps);
        if (videoResult) {
            this.glInterface.setEncoderSize(width, height);
            return this.getVideoEncoder().prepareVideoEncoder(width, height, fps, bitrate, 0, iFrameInterval, FormatVideoEncoder.SURFACE, avcProfile, avcProfileLevel);
        }
        return videoResult;
    }

    public static /* synthetic */ boolean prepareVideo$default(StreamBase streamBase, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareVideo");
        }
        if ((n8 & 8) != 0) {
            n4 = 30;
        }
        if ((n8 & 0x10) != 0) {
            n5 = 2;
        }
        if ((n8 & 0x20) != 0) {
            n6 = -1;
        }
        if ((n8 & 0x40) != 0) {
            n7 = -1;
        }
        return streamBase.prepareVideo(n, n2, n3, n4, n5, n6, n7);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler, boolean noiseSuppressor) {
        boolean audioResult = this.getAudioManager().createAudioManager(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (audioResult) {
            return this.getAudioEncoder().prepareAudioEncoder(bitrate, sampleRate, isStereo, this.getAudioManager().getMaxInputSize());
        }
        return audioResult;
    }

    public static /* synthetic */ boolean prepareAudio$default(StreamBase streamBase, int n, boolean bl, int n2, boolean bl2, boolean bl3, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareAudio");
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        return streamBase.prepareAudio(n, bl, n2, bl2, bl3);
    }

    public final void startStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        this.isStreaming = true;
        this.rtpStartStream(endPoint);
        if (!this.isRecording()) {
            this.startSources();
        } else {
            this.requestKeyframe();
        }
    }

    public final void requestKeyframe() {
        if (this.getVideoEncoder().isRunning()) {
            this.getVideoEncoder().requestKeyframe();
        }
    }

    public final boolean stopStream() {
        this.isStreaming = false;
        this.rtpStopStream();
        if (!this.isRecording()) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void startRecord(@NotNull String path, @NotNull RecordController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.recordController.startRecord(path, listener);
        if (!this.isStreaming) {
            this.startSources();
        } else {
            this.getVideoEncoder().requestKeyframe();
        }
    }

    public final boolean stopRecord() {
        this.recordController.stopRecord();
        if (!this.isStreaming) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void startPreview(@NotNull TextureView textureView) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        this.startPreview(new Surface(textureView.getSurfaceTexture()), textureView.getWidth(), textureView.getHeight());
    }

    public final void startPreview(@NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Surface surface = surfaceView.getHolder().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        this.startPreview(surface, surfaceView.getWidth(), surfaceView.getHeight());
    }

    public final void startPreview(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.startPreview(new Surface(surfaceTexture), width, height);
    }

    public final void startPreview(@NotNull Surface surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (!surface.isValid()) {
            throw new IllegalArgumentException("Make sure the Surface is valid");
        }
        this.isOnPreview = true;
        if (!this.glInterface.getRunning()) {
            this.glInterface.start();
        }
        if (!this.videoManager.isRunning()) {
            this.videoManager.start(this.glInterface.getSurfaceTexture());
        }
        this.glInterface.attachPreview(surface);
        this.glInterface.setPreviewResolution(width, height);
    }

    public final void stopPreview() {
        this.isOnPreview = false;
        if (!this.isStreaming && !this.isRecording()) {
            this.videoManager.stop();
        }
        this.glInterface.deAttachPreview();
        if (!this.isStreaming && !this.isRecording()) {
            this.glInterface.stop();
        }
    }

    public final void changeVideoSourceCamera(@NotNull VideoManager.Source source) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        this.glInterface.setForceRender(false);
        this.videoManager.changeSourceCamera(source);
    }

    public final void changeVideoSourceScreen(@NotNull MediaProjection mediaProjection) {
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.glInterface.setForceRender(true);
        this.videoManager.changeSourceScreen(mediaProjection);
    }

    public final void changeVideoSourceDisabled() {
        this.glInterface.setForceRender(false);
        this.videoManager.changeVideoSourceDisabled();
    }

    public final void changeAudioSourceMicrophone() {
        this.getAudioManager().changeSourceMicrophone();
    }

    @RequiresApi(value=29)
    public final void changeAudioSourceInternal(@NotNull MediaProjection mediaProjection) {
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.getAudioManager().changeSourceInternal(mediaProjection);
    }

    public final void changeAudioSourceDisabled() {
        this.getAudioManager().changeAudioSourceDisabled();
    }

    public final void setEncoderErrorCallback(@Nullable EncoderErrorCallback encoderErrorCallback) {
        this.getVideoEncoder().setEncoderErrorCallback(encoderErrorCallback);
        this.getAudioEncoder().setEncoderErrorCallback(encoderErrorCallback);
    }

    public final void setAudioMaxInputSize(int size) {
        this.getAudioManager().setMaxInputSize(size);
    }

    public final void mute() {
        this.getAudioManager().mute();
    }

    public final void unMute() {
        this.getAudioManager().unMute();
    }

    public final boolean isMuted() {
        return this.getAudioManager().isMuted();
    }

    public final void switchCamera() {
        this.videoManager.switchCamera();
    }

    @NotNull
    public final CameraHelper.Facing getCameraFacing() {
        return this.videoManager.getCameraFacing();
    }

    @NotNull
    public final List<Size> getCameraResolutions(@NotNull VideoManager.Source source, @NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        return this.videoManager.getCameraResolutions(source, facing);
    }

    public final void setExposure(int level) {
        this.videoManager.setExposure(level);
    }

    public final int getExposure() {
        return this.videoManager.getExposure();
    }

    public final void enableLantern() {
        this.videoManager.enableLantern();
    }

    public final void disableLantern() {
        this.videoManager.disableLantern();
    }

    public final boolean isLanternEnabled() {
        return this.videoManager.isLanternEnabled();
    }

    public final void enableAutoFocus() {
        this.videoManager.enableAutoFocus();
    }

    public final void disableAutoFocus() {
        this.videoManager.disableAutoFocus();
    }

    public final boolean isAutoFocusEnabled() {
        return this.videoManager.isAutoFocusEnabled();
    }

    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.videoManager.setZoom(event);
    }

    public final void setZoom(float level) {
        this.videoManager.setZoom(level);
    }

    @NotNull
    public final Range<Float> getZoomRange() {
        return this.videoManager.getZoomRange();
    }

    public final float getZoom() {
        return this.videoManager.getZoom();
    }

    public final void setOrientation(int orientation) {
        this.glInterface.setCameraOrientation(orientation);
    }

    @NotNull
    public final GlStreamInterface getGlInterface() {
        return this.glInterface;
    }

    public final void setRecordController(@NotNull BaseRecordController recordController) {
        Intrinsics.checkNotNullParameter((Object)recordController, (String)"recordController");
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        if (this.videoSource != VideoManager.Source.DISABLED) {
            throw new IllegalStateException("getSurfaceTexture only available with VideoManager.Source.DISABLED");
        }
        return this.glInterface.getSurfaceTexture();
    }

    protected final void setVideoMime(@NotNull String videoMime) {
        Intrinsics.checkNotNullParameter((Object)videoMime, (String)"videoMime");
        this.recordController.setVideoMime(videoMime);
        this.getVideoEncoder().setType(videoMime);
    }

    @NotNull
    protected final Size getVideoResolution() {
        return new Size(this.getVideoEncoder().getWidth(), this.getVideoEncoder().getHeight());
    }

    protected final int getVideoFps() {
        return this.getVideoEncoder().getFps();
    }

    private final void startSources() {
        if (!this.glInterface.getRunning()) {
            this.glInterface.start();
        }
        if (!this.videoManager.isRunning()) {
            this.videoManager.start(this.glInterface.getSurfaceTexture());
        }
        this.getAudioManager().start();
        this.getVideoEncoder().start();
        this.getAudioEncoder().start();
        Surface surface = this.getVideoEncoder().getInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
        this.glInterface.addMediaCodecSurface(surface);
    }

    private final void stopSources() {
        if (!this.isOnPreview) {
            this.videoManager.stop();
        }
        this.getAudioManager().stop();
        this.getVideoEncoder().stop();
        this.getAudioEncoder().stop();
        this.glInterface.removeMediaCodecSurface();
        if (!this.isOnPreview) {
            this.glInterface.stop();
        }
        if (!this.isRecording()) {
            this.recordController.resetFormats();
        }
    }

    private final boolean prepareEncoders() {
        return this.getVideoEncoder().prepareVideoEncoder() && this.getAudioEncoder().prepareAudioEncoder();
    }

    protected abstract void audioInfo(int var1, boolean var2);

    protected abstract void rtpStartStream(@NotNull String var1);

    protected abstract void rtpStopStream();

    protected abstract void onSpsPpsVpsRtp(@NotNull ByteBuffer var1, @NotNull ByteBuffer var2, @Nullable ByteBuffer var3);

    protected abstract void getH264DataRtp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    protected abstract void getAacDataRtp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int avcProfile) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, avcProfile, 0, 64, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, 0, 0, 96, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, 0, 0, 0, 112, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, 0, 0, 0, 0, 120, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler) {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, echoCanceler, false, 16, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate) {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, false, false, 24, null);
    }

    public static final /* synthetic */ AudioEncoder access$getAudioEncoder(StreamBase $this) {
        return $this.getAudioEncoder();
    }

    public static final /* synthetic */ GetVideoData access$getGetVideoData$p(StreamBase $this) {
        return $this.getVideoData;
    }

    public static final /* synthetic */ GetAacData access$getGetAacData$p(StreamBase $this) {
        return $this.getAacData;
    }

    public static final /* synthetic */ getMicrophoneData.1 access$getGetMicrophoneData$p(StreamBase $this) {
        return $this.getMicrophoneData;
    }

    public static final /* synthetic */ BaseRecordController access$getRecordController$p(StreamBase $this) {
        return $this.recordController;
    }
}

