/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.library.util.Filter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J\u0018\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+J\u000e\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020)2\u0006\u0010.\u001a\u00020/J\u0006\u00101\u001a\u00020)J\u0006\u00102\u001a\u00020)J\u0006\u00103\u001a\u00020\u0007J\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020/J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020)J\u0012\u0010:\u001a\u00020)2\b\u0010;\u001a\u0004\u0018\u000108H\u0016J\u0010\u0010<\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J\u000e\u0010<\u001a\u00020)2\u0006\u0010,\u001a\u00020\u0007J\u0006\u0010=\u001a\u00020)J\b\u0010>\u001a\u00020)H\u0016J\u000e\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020\u0007J\u0016\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0007J\u0010\u0010D\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J\u0018\u0010D\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+J\u000e\u0010E\u001a\u00020)2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020\u0007J\u000e\u0010H\u001a\u00020)2\u0006\u0010@\u001a\u00020\u0007J\u0016\u0010I\u001a\u00020)2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0007J\u000e\u0010J\u001a\u00020)2\u0006\u0010@\u001a\u00020\u0007J\u0006\u0010K\u001a\u00020)J\u0006\u0010L\u001a\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/pedro/library/view/GlStreamInterface;", "Ljava/lang/Runnable;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "encoderHeight", "", "encoderWidth", "filterQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/library/util/Filter;", "forceRender", "", "fpsLimiter", "Lcom/pedro/encoder/input/video/FpsLimiter;", "frameAvailable", "initialized", "isPortrait", "managerRender", "Lcom/pedro/encoder/input/gl/render/MainRender;", "previewHeight", "previewOrientation", "previewWidth", "running", "getRunning", "()Z", "setRunning", "(Z)V", "semaphore", "Ljava/util/concurrent/Semaphore;", "streamOrientation", "surfaceManager", "Lcom/pedro/encoder/input/gl/SurfaceManager;", "surfaceManagerEncoder", "surfaceManagerPreview", "sync", "Ljava/lang/Object;", "thread", "Ljava/lang/Thread;", "addFilter", "", "baseFilterRender", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "filterPosition", "addMediaCodecSurface", "surface", "Landroid/view/Surface;", "attachPreview", "clearFilters", "deAttachPreview", "filtersCount", "getEncoderSize", "Landroid/graphics/Point;", "getSurface", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "init", "onFrameAvailable", "surfaceTexture", "removeFilter", "removeMediaCodecSurface", "run", "setCameraOrientation", "orientation", "setEncoderSize", "width", "height", "setFilter", "setForceRender", "setFps", "fps", "setPreviewOrientation", "setPreviewResolution", "setStreamOrientation", "start", "stop", "library_release"})
@RequiresApi(api=18)
public final class GlStreamInterface
implements Runnable,
SurfaceTexture.OnFrameAvailableListener {
    @NotNull
    private final Context context;
    @Nullable
    private Thread thread;
    private boolean frameAvailable;
    private boolean running;
    private boolean initialized;
    @NotNull
    private final SurfaceManager surfaceManager;
    @NotNull
    private final SurfaceManager surfaceManagerEncoder;
    @NotNull
    private final SurfaceManager surfaceManagerPreview;
    @Nullable
    private MainRender managerRender;
    @NotNull
    private final Semaphore semaphore;
    @NotNull
    private final Object sync;
    private int encoderWidth;
    private int encoderHeight;
    private int streamOrientation;
    private int previewWidth;
    private int previewHeight;
    private int previewOrientation;
    private boolean isPortrait;
    @NotNull
    private final FpsLimiter fpsLimiter;
    @NotNull
    private final BlockingQueue<Filter> filterQueue;
    private boolean forceRender;

    public GlStreamInterface(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerPreview = new SurfaceManager();
        this.semaphore = new Semaphore(0);
        this.sync = new Object();
        this.fpsLimiter = new FpsLimiter();
        this.filterQueue = new LinkedBlockingQueue();
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    public final void init() {
        if (!this.initialized) {
            this.managerRender = new MainRender();
        }
        MainRender mainRender = this.managerRender;
        if (mainRender != null) {
            mainRender.setCameraFlip(false, false);
        }
        this.initialized = true;
    }

    public final void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @NotNull
    public final Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    public final void setFps(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    public final void setForceRender(boolean forceRender) {
        this.forceRender = forceRender;
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        MainRender mainRender = this.managerRender;
        Intrinsics.checkNotNull((Object)mainRender);
        return mainRender.getSurfaceTexture();
    }

    @NotNull
    public final Surface getSurface() {
        MainRender mainRender = this.managerRender;
        Intrinsics.checkNotNull((Object)mainRender);
        return mainRender.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMediaCodecSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            if (this.surfaceManager.isReady()) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.surfaceManagerEncoder.release();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.thread = new Thread(this);
            this.running = true;
            Thread thread = this.thread;
            if (thread != null) {
                thread.start();
            }
            this.semaphore.acquireUninterruptibly();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        block7: {
            this.running = false;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
            try {
                Thread thread2 = this.thread;
                if (thread2 != null) {
                    thread2.join(100L);
                }
            }
            catch (InterruptedException e) {
                Thread thread3 = this.thread;
                if (thread3 == null) break block7;
                thread3.interrupt();
            }
        }
        this.thread = null;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        MainRender mainRender;
        this.surfaceManager.release();
        this.surfaceManager.eglSetup();
        this.surfaceManager.makeCurrent();
        MainRender mainRender2 = this.managerRender;
        if (mainRender2 != null) {
            mainRender2.initGl(this.context, this.encoderWidth, this.encoderHeight, this.encoderWidth, this.encoderHeight);
        }
        if ((mainRender = this.managerRender) != null && (mainRender = mainRender.getSurfaceTexture()) != null) {
            mainRender.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        this.semaphore.release();
        try {
            while (this.running) {
                Object object;
                this.fpsLimiter.setFrameStartTs();
                if (this.frameAvailable || this.forceRender) {
                    this.frameAvailable = false;
                    this.surfaceManager.makeCurrent();
                    MainRender mainRender3 = this.managerRender;
                    if (mainRender3 != null) {
                        mainRender3.updateFrame();
                    }
                    MainRender mainRender4 = this.managerRender;
                    if (mainRender4 != null) {
                        mainRender4.drawOffScreen();
                    }
                    MainRender mainRender5 = this.managerRender;
                    if (mainRender5 != null) {
                        mainRender5.drawScreen(this.encoderWidth, this.encoderHeight, false, 0, 0, false, false);
                    }
                    this.surfaceManager.swapBuffer();
                    if (!this.filterQueue.isEmpty()) {
                        Filter filter = this.filterQueue.take();
                        MainRender mainRender6 = this.managerRender;
                        if (mainRender6 != null) {
                            FilterAction filterAction = filter.getFilterAction();
                            int n = filter.getPosition();
                            BaseFilterRender baseFilterRender = filter.getBaseFilterRender();
                            Intrinsics.checkNotNullExpressionValue((Object)baseFilterRender, (String)"getBaseFilterRender(...)");
                            mainRender6.setFilterAction(filterAction, n, baseFilterRender);
                        }
                    }
                    object = this.sync;
                    synchronized (object) {
                        int h;
                        int w;
                        boolean $i$a$-synchronized-GlStreamInterface$run$32 = false;
                        boolean limitFps = this.fpsLimiter.limitFPS();
                        if (this.surfaceManagerEncoder.isReady() && !limitFps) {
                            w = this.encoderWidth;
                            h = this.encoderHeight;
                            this.surfaceManagerEncoder.makeCurrent();
                            MainRender mainRender7 = this.managerRender;
                            if (mainRender7 != null) {
                                mainRender7.drawScreenEncoder(w, h, this.isPortrait, this.streamOrientation, false, false);
                            }
                            this.surfaceManagerEncoder.swapBuffer();
                        }
                        if (this.surfaceManagerPreview.isReady() && !limitFps) {
                            w = this.previewWidth == 0 ? this.encoderWidth : this.previewWidth;
                            h = this.previewHeight == 0 ? this.encoderHeight : this.previewHeight;
                            this.surfaceManagerPreview.makeCurrent();
                            MainRender mainRender8 = this.managerRender;
                            if (mainRender8 != null) {
                                mainRender8.drawScreenPreview(w, h, this.isPortrait, true, 0, this.previewOrientation, false, false);
                            }
                            this.surfaceManagerPreview.swapBuffer();
                        }
                        Unit $i$a$-synchronized-GlStreamInterface$run$32 = Unit.INSTANCE;
                    }
                }
                object = this.sync;
                synchronized (object) {
                    boolean bl = false;
                    long sleep = this.fpsLimiter.getSleepTime();
                    if (sleep > 0L) {
                        this.sync.wait(sleep);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            MainRender mainRender9 = this.managerRender;
            if (mainRender9 != null) {
                mainRender9.release();
            }
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.frameAvailable = true;
            this.sync.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attachPreview(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            if (this.surfaceManager.isReady()) {
                this.isPortrait = CameraHelper.isPortrait((Context)this.context);
                this.surfaceManagerPreview.release();
                this.surfaceManagerPreview.eglSetup(surface, this.surfaceManager);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deAttachPreview() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            this.surfaceManagerPreview.release();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void setStreamOrientation(int orientation) {
        this.streamOrientation = orientation;
    }

    public final void setPreviewResolution(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public final void setPreviewOrientation(int orientation) {
        this.previewOrientation = orientation;
    }

    public final void setCameraOrientation(int orientation) {
        block0: {
            MainRender mainRender = this.managerRender;
            if (mainRender == null) break block0;
            mainRender.setCameraRotation(orientation);
        }
    }

    public final void setFilter(int filterPosition, @Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    public final void addFilter(@Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    public final void addFilter(int filterPosition, @Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    public final void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, null));
    }

    public final void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, null));
    }

    public final void removeFilter(@Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    public final int filtersCount() {
        MainRender mainRender = this.managerRender;
        return mainRender != null ? mainRender.filtersCount() : 0;
    }

    public final void setFilter(@Nullable BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }
}

