/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.srt;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.DisplayBase;
import com.pedro.srt.srt.SrtClient;
import com.pedro.srt.srt.VideoCodec;
import com.pedro.srt.utils.ConnectCheckerSrt;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class SrtDisplay
extends DisplayBase {
    private final SrtClient rtmpClient;

    public SrtDisplay(Context context, boolean useOpengl, ConnectCheckerSrt connectChecker) {
        super(context, useOpengl);
        this.rtmpClient = new SrtClient(connectChecker);
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.recordController.setVideoMime(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
        this.rtmpClient.setVideoCodec(videoCodec);
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(String reason) {
        return this.rtmpClient.shouldRetry(reason);
    }

    @Override
    public void reConnect(long delay, @Nullable String backupUrl) {
        this.rtmpClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.rtmpClient.hasCongestion();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendVideo(h264Buffer, info);
    }

    @Override
    public void setLogs(boolean enable) {
        this.rtmpClient.setLogs(enable);
    }

    @Override
    public void setCheckServerAlive(boolean enable) {
        this.rtmpClient.setCheckServerAlive(enable);
    }
}

