/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import android.util.Size;
import androidx.annotation.RequiresApi;
import com.pedro.library.base.StreamBase;
import com.pedro.library.util.sources.AudioManager;
import com.pedro.library.util.sources.VideoManager;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.rtmp.VideoCodec;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\"\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010\u0018H\u0014J\u001a\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+H\u0014J\b\u0010,\u001a\u00020\u000fH\u0016J\b\u0010-\u001a\u00020\u000fH\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020\u000fH\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u0011H\u0016J\u0010\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020+H\u0014J\b\u00104\u001a\u00020\u000fH\u0014J\u001c\u00105\u001a\u00020\u000f2\b\u00106\u001a\u0004\u0018\u00010+2\b\u00107\u001a\u0004\u0018\u00010+H\u0014J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010:\u001a\u00020\u000f2\b\u0010;\u001a\u0004\u0018\u00010<J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0011H\u0016J\u000e\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u0011J\u0010\u0010D\u001a\u00020\u00132\u0006\u0010E\u001a\u00020+H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/pedro/library/rtmp/RtmpStream;", "Lcom/pedro/library/base/StreamBase;", "context", "Landroid/content/Context;", "connectCheckerRtmp", "Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;", "(Landroid/content/Context;Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;)V", "videoSource", "Lcom/pedro/library/util/sources/VideoManager$Source;", "audioSource", "Lcom/pedro/library/util/sources/AudioManager$Source;", "(Landroid/content/Context;Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;Lcom/pedro/library/util/sources/VideoManager$Source;Lcom/pedro/library/util/sources/AudioManager$Source;)V", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "audioInfo", "", "sampleRate", "", "isStereo", "", "forceAkamaiTs", "enabled", "getAacDataRtp", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getCacheSize", "getDroppedAudioFrames", "", "getDroppedVideoFrames", "getH264DataRtp", "h264Buffer", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "onSpsPpsVpsRtp", "sps", "pps", "vps", "reConnect", "delay", "backupUrl", "", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "rtpStartStream", "endPoint", "rtpStopStream", "setAuthorization", "user", "password", "setCheckServerAlive", "setLogs", "setProfileIop", "profileIop", "Lcom/pedro/rtmp/flv/video/ProfileIop;", "setReTries", "reTries", "setVideoCodec", "videoCodec", "Lcom/pedro/rtmp/rtmp/VideoCodec;", "setWriteChunkSize", "chunkSize", "shouldRetry", "reason", "library_release"})
@RequiresApi(value=21)
public final class RtmpStream
extends StreamBase {
    @NotNull
    private final RtmpClient rtmpClient;

    public RtmpStream(@NotNull Context context, @NotNull ConnectCheckerRtmp connectCheckerRtmp, @NotNull VideoManager.Source videoSource, @NotNull AudioManager.Source audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        Intrinsics.checkNotNullParameter((Object)((Object)videoSource), (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)((Object)audioSource), (String)"audioSource");
        super(context, videoSource, audioSource);
        this.rtmpClient = new RtmpClient(connectCheckerRtmp);
    }

    public RtmpStream(@NotNull Context context, @NotNull ConnectCheckerRtmp connectCheckerRtmp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        this(context, connectCheckerRtmp, VideoManager.Source.CAMERA2, AudioManager.Source.MICROPHONE);
    }

    public final void setProfileIop(@Nullable ProfileIop profileIop) {
        ProfileIop profileIop2 = profileIop;
        Intrinsics.checkNotNull((Object)profileIop2);
        this.rtmpClient.setProfileIop(profileIop2);
    }

    public final void setVideoCodec(@NotNull VideoCodec videoCodec) {
        Intrinsics.checkNotNullParameter((Object)videoCodec, (String)"videoCodec");
        String mime = videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc";
        super.setVideoMime(mime);
        this.rtmpClient.setVideoCodec(videoCodec);
    }

    public final void forceAkamaiTs(boolean enabled) {
        this.rtmpClient.forceAkamaiTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        if (!this.isStreaming()) {
            this.rtmpClient.setWriteChunkSize(chunkSize);
        }
    }

    @Override
    protected void audioInfo(int sampleRate, boolean isStereo) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void rtpStartStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        Size resolution = super.getVideoResolution();
        this.rtmpClient.setVideoResolution(resolution.getWidth(), resolution.getHeight());
        this.rtmpClient.setFps(super.getVideoFps());
        RtmpClient.connect$default((RtmpClient)this.rtmpClient, (String)endPoint, (boolean)false, (int)2, null);
    }

    @Override
    protected void rtpStopStream() {
        this.rtmpClient.disconnect();
    }

    @Override
    protected void setAuthorization(@Nullable String user, @Nullable String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtmpClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return this.rtmpClient.shouldRetry(reason);
    }

    @Override
    protected void reConnect(long delay, @Nullable String backupUrl) {
        this.rtmpClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.rtmpClient.hasCongestion();
    }

    @Override
    public void setLogs(boolean enabled) {
        this.rtmpClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.rtmpClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }
}

