/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.AndroidViewSprite;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@RequiresApi(api=18)
public class AndroidViewFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uSamplerViewHandle = -1;
    private int[] viewId = new int[]{-1, -1};
    private View view;
    private SurfaceTexture surfaceTexture;
    private SurfaceTexture surfaceTexture2;
    private Surface surface;
    private Surface surface2;
    private final Handler mainHandler;
    private boolean running = false;
    private ExecutorService thread = null;
    private boolean hardwareMode = true;
    private final AndroidViewSprite sprite;
    private volatile Status renderingStatus = Status.DONE1;

    public AndroidViewFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
        this.sprite = new AndroidViewSprite();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.android_view_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uSamplerViewHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSamplerView");
        GlUtil.createExternalTextures(this.viewId.length, this.viewId, 0);
        this.surfaceTexture = new SurfaceTexture(this.viewId[0]);
        this.surfaceTexture2 = new SurfaceTexture(this.viewId[1]);
        this.surface = new Surface(this.surfaceTexture);
        this.surface2 = new Surface(this.surfaceTexture2);
    }

    @Override
    protected void drawFilter() {
        Status status = this.renderingStatus;
        switch (status) {
            case DONE1: {
                this.surfaceTexture.setDefaultBufferSize(this.getPreviewWidth(), this.getPreviewHeight());
                this.surfaceTexture.updateTexImage();
                this.renderingStatus = Status.RENDER2;
                break;
            }
            case DONE2: {
                this.surfaceTexture2.setDefaultBufferSize(this.getPreviewWidth(), this.getPreviewHeight());
                this.surfaceTexture2.updateTexImage();
                this.renderingStatus = Status.RENDER1;
                break;
            }
            case RENDER1: {
                this.surfaceTexture2.setDefaultBufferSize(this.getPreviewWidth(), this.getPreviewHeight());
                this.surfaceTexture2.updateTexImage();
                break;
            }
            default: {
                this.surfaceTexture.setDefaultBufferSize(this.getPreviewWidth(), this.getPreviewHeight());
                this.surfaceTexture.updateTexImage();
            }
        }
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
        GLES20.glUniform1i((int)this.uSamplerViewHandle, (int)1);
        GLES20.glActiveTexture((int)33985);
        switch (status) {
            case DONE2: 
            case RENDER1: {
                GLES20.glBindTexture((int)36197, (int)this.viewId[1]);
                break;
            }
            default: {
                GLES20.glBindTexture((int)36197, (int)this.viewId[0]);
            }
        }
    }

    @Override
    protected void disableResources() {
        GlUtil.disableResources(this.aTextureHandle, this.aPositionHandle);
    }

    @Override
    public void release() {
        this.stopRender();
        GLES20.glDeleteProgram((int)this.program);
        this.viewId = new int[]{-1, -1};
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
        }
        if (this.surfaceTexture2 != null) {
            this.surfaceTexture2.release();
        }
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.stopRender();
        this.view = view;
        if (view != null) {
            view.measure(0, 0);
            this.sprite.setView(view);
            this.startRender();
        }
    }

    public void setPosition(float x, float y) {
        this.sprite.translate(x, y);
    }

    public void setPosition(TranslateTo positionTo) {
        this.sprite.translate(positionTo);
    }

    public void setRotation(int rotation) {
        this.sprite.setRotation(rotation);
    }

    public void setScale(float scaleX, float scaleY) {
        this.sprite.scale(scaleX, scaleY);
    }

    public PointF getScale() {
        return this.sprite.getScale();
    }

    public PointF getPosition() {
        return this.sprite.getTranslation();
    }

    public int getRotation() {
        return this.sprite.getRotation();
    }

    public boolean isHardwareMode() {
        return Build.VERSION.SDK_INT >= 23 && this.hardwareMode;
    }

    public void setHardwareMode(boolean hardwareMode) {
        this.hardwareMode = hardwareMode;
    }

    private void startRender() {
        this.running = true;
        this.thread = Executors.newSingleThreadExecutor();
        this.thread.execute(() -> {
            while (this.running) {
                Status status = this.renderingStatus;
                if (status == Status.RENDER1 || status == Status.RENDER2) {
                    Canvas canvas;
                    try {
                        canvas = this.isHardwareMode() ? (status == Status.RENDER1 ? this.surface.lockHardwareCanvas() : this.surface2.lockHardwareCanvas()) : (status == Status.RENDER1 ? this.surface.lockCanvas(null) : this.surface2.lockCanvas(null));
                    }
                    catch (IllegalStateException e) {
                        continue;
                    }
                    this.sprite.calculateDefaultScale(this.getPreviewWidth(), this.getPreviewHeight());
                    PointF canvasPosition = this.sprite.getCanvasPosition(this.getPreviewWidth(), this.getPreviewHeight());
                    PointF canvasScale = this.sprite.getCanvasScale(this.getPreviewWidth(), this.getPreviewHeight());
                    PointF rotationAxis = this.sprite.getRotationAxis();
                    int rotation = this.sprite.getRotation();
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    canvas.translate(canvasPosition.x, canvasPosition.y);
                    canvas.scale(canvasScale.x, canvasScale.y);
                    canvas.rotate((float)rotation, rotationAxis.x, rotationAxis.y);
                    try {
                        this.view.draw(canvas);
                        if (status == Status.RENDER1) {
                            this.surface.unlockCanvasAndPost(canvas);
                            this.renderingStatus = Status.DONE1;
                            continue;
                        }
                        this.surface2.unlockCanvasAndPost(canvas);
                        this.renderingStatus = Status.DONE2;
                    }
                    catch (Exception e) {
                        this.mainHandler.post(() -> {
                            this.view.draw(canvas);
                            if (status == Status.RENDER1) {
                                this.surface.unlockCanvasAndPost(canvas);
                                this.renderingStatus = Status.DONE1;
                            } else {
                                this.surface2.unlockCanvasAndPost(canvas);
                                this.renderingStatus = Status.DONE2;
                            }
                        });
                    }
                    continue;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    private void stopRender() {
        this.running = false;
        if (this.thread != null) {
            this.thread.shutdownNow();
            this.thread = null;
        }
        this.renderingStatus = Status.DONE1;
    }

    private static enum Status {
        RENDER1,
        RENDER2,
        DONE1,
        DONE2;

    }
}

