/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RequiresApi(api=18)
public class SaturationFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uShiftHandle = -1;
    private int uWeightsHandle = -1;
    private int uExponentsHandle = -1;
    private int uSaturationHandle = -1;
    private float saturation = -0.5f;
    private final float shift = 0.003921569f;
    private final float[] weights = new float[]{0.25f, 0.625f, 0.125f};
    private float[] exponents = new float[3];

    public SaturationFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.saturation_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uShiftHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uShift");
        this.uWeightsHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uWeights");
        this.uExponentsHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uExponents");
        this.uSaturationHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSaturation");
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1f((int)this.uShiftHandle, (float)0.003921569f);
        GLES20.glUniform3f((int)this.uWeightsHandle, (float)this.weights[0], (float)this.weights[1], (float)this.weights[2]);
        GLES20.glUniform3f((int)this.uExponentsHandle, (float)this.exponents[0], (float)this.exponents[1], (float)this.exponents[2]);
        GLES20.glUniform1f((int)this.uSaturationHandle, (float)this.saturation);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
    }

    @Override
    protected void disableResources() {
        GlUtil.disableResources(this.aTextureHandle, this.aPositionHandle);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        if (saturation > 0.0f) {
            this.exponents[0] = 0.9f * saturation + 1.0f;
            this.exponents[1] = 2.1f * saturation + 1.0f;
            this.exponents[2] = 2.7f * saturation + 1.0f;
            this.saturation = saturation;
        } else {
            this.saturation = saturation + 1.0f;
        }
    }
}

