/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import com.pedro.common.TimeUtils;

public class FpsLimiter {
    private long startTS = TimeUtils.getCurrentTimeMillis();
    private long ratioF = 33L;
    private long ratio = 33L;
    private long frameStartTS = 0L;
    private boolean configured = false;

    public void setFPS(int fps) {
        if (fps <= 0) {
            this.configured = false;
            return;
        }
        this.configured = true;
        this.startTS = TimeUtils.getCurrentTimeMillis();
        this.ratioF = 1000 / fps;
        this.ratio = 1000 / fps;
    }

    public boolean limitFPS() {
        if (!this.configured) {
            return false;
        }
        long lastFrameTimestamp = TimeUtils.getCurrentTimeMillis() - this.startTS;
        if (this.ratio < lastFrameTimestamp) {
            this.ratio += this.ratioF;
            return false;
        }
        return true;
    }

    public void setFrameStartTs() {
        this.frameStartTS = TimeUtils.getCurrentTimeMillis();
    }

    public long getSleepTime() {
        return Math.max(0L, this.ratioF - (TimeUtils.getCurrentTimeMillis() - this.frameStartTS));
    }
}

