/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/pedro/encoder/input/decoder/BufferDecoder;", "", "videoCodec", "Lcom/pedro/common/VideoCodec;", "<init>", "(Lcom/pedro/common/VideoCodec;)V", "codec", "Landroid/media/MediaCodec;", "mediaFormat", "Landroid/media/MediaFormat;", "startTs", "", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "mime", "", "isSurfaceMode", "", "prepare", "", "width", "", "height", "fps", "rotation", "start", "surface", "Landroid/view/Surface;", "stop", "decode", "Ljava/nio/ByteBuffer;", "data", "", "encoder_release"})
public final class BufferDecoder {
    @Nullable
    private MediaCodec codec;
    @Nullable
    private MediaFormat mediaFormat;
    private long startTs;
    @NotNull
    private final MediaCodec.BufferInfo bufferInfo;
    @NotNull
    private final String mime;
    private boolean isSurfaceMode;

    public BufferDecoder(@NotNull VideoCodec videoCodec) {
        Intrinsics.checkNotNullParameter((Object)videoCodec, (String)"videoCodec");
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.mime = switch (WhenMappings.$EnumSwitchMapping$0[videoCodec.ordinal()]) {
            case 1 -> "video/avc";
            case 2 -> "video/hevc";
            case 3 -> "video/av01";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void prepare(int width, int height, int fps, int rotation) {
        MediaFormat mediaFormat = new MediaFormat();
        switch (rotation) {
            case 0: 
            case 180: {
                mediaFormat.setInteger("width", width);
                mediaFormat.setInteger("height", height);
                break;
            }
            default: {
                mediaFormat.setInteger("width", height);
                mediaFormat.setInteger("height", width);
            }
        }
        mediaFormat.setInteger("frame-rate", fps);
        mediaFormat.setString("mime", this.mime);
        this.mediaFormat = mediaFormat;
    }

    public final int start(@Nullable Surface surface) {
        this.isSurfaceMode = surface != null;
        MediaFormat mediaFormat = this.mediaFormat;
        if (mediaFormat != null) {
            int n;
            MediaFormat it = mediaFormat;
            boolean bl = false;
            this.startTs = TimeUtils.getCurrentTimeMicro();
            MediaCodec mediaCodec = this.codec = MediaCodec.createDecoderByType((String)this.mime);
            if (mediaCodec != null) {
                mediaCodec.configure(this.mediaFormat, surface, null, 0);
            }
            try {
                MediaCodec mediaCodec2 = this.codec;
                n = mediaCodec2 != null && (mediaCodec2 = mediaCodec2.getOutputFormat()) != null ? mediaCodec2.getInteger("color-format") : -1;
            }
            catch (Exception e) {
                n = -1;
            }
            int color = n;
            MediaCodec mediaCodec3 = this.codec;
            if (mediaCodec3 != null) {
                mediaCodec3.start();
            }
            return color;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        try {
            MediaCodec mediaCodec = this.codec;
            if (mediaCodec != null) {
                mediaCodec.flush();
            }
            MediaCodec mediaCodec2 = this.codec;
            if (mediaCodec2 != null) {
                mediaCodec2.stop();
            }
            MediaCodec mediaCodec3 = this.codec;
            if (mediaCodec3 != null) {
                mediaCodec3.release();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.codec = null;
            this.mediaFormat = null;
            this.startTs = 0L;
            this.isSurfaceMode = false;
        }
    }

    @Nullable
    public final ByteBuffer decode(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MediaCodec mediaCodec = this.codec;
        if (mediaCodec != null) {
            int outIndex;
            MediaCodec it = mediaCodec;
            boolean bl = false;
            int inIndex = it.dequeueInputBuffer(10000L);
            if (inIndex >= 0) {
                ByteBuffer input;
                ByteBuffer byteBuffer = input = it.getInputBuffer(inIndex);
                if (byteBuffer != null) {
                    byteBuffer.put(data);
                }
                it.queueInputBuffer(inIndex, 0, data.length, TimeUtils.getCurrentTimeMicro() - this.startTs, 0);
            }
            if ((outIndex = it.dequeueOutputBuffer(this.bufferInfo, 10000L)) >= 0) {
                ByteBuffer byteBuffer;
                if (!this.isSurfaceMode) {
                    ByteBuffer byteBuffer2 = it.getOutputBuffer(outIndex);
                    byteBuffer = byteBuffer2 != null ? ExtensionsKt.clone((ByteBuffer)byteBuffer2) : null;
                } else {
                    byteBuffer = null;
                }
                ByteBuffer rawData = byteBuffer;
                it.releaseOutputBuffer(outIndex, this.isSurfaceMode);
                return rawData;
            }
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

