/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.audio;

import android.media.AudioDeviceInfo;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.sources.MediaProjectionHandler;
import com.pedro.encoder.input.sources.audio.AudioSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u001cJ\u0006\u0010%\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u00020+2\u0006\u0010*\u001a\u00020+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010.\"\u0004\b3\u00100R$\u00104\u001a\u00020+2\u0006\u0010*\u001a\u00020+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010.\"\u0004\b6\u00100\u00a8\u00067"}, d2={"Lcom/pedro/encoder/input/sources/audio/MixAudioSource;", "Lcom/pedro/encoder/input/sources/audio/AudioSource;", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "Landroid/media/projection/MediaProjection$Callback;", "microphoneAudioSource", "", "<init>", "(Landroid/media/projection/MediaProjection;Landroid/media/projection/MediaProjection$Callback;I)V", "TAG", "", "handlerThread", "Landroid/os/HandlerThread;", "microphone", "Lcom/pedro/encoder/input/audio/MicrophoneManager;", "preferredDevice", "Landroid/media/AudioDeviceInfo;", "create", "", "sampleRate", "isStereo", "echoCanceler", "noiseSuppressor", "setPreferredDevice", "deviceInfo", "start", "", "getMicrophoneData", "stop", "isRunning", "release", "inputPCMData", "frame", "Lcom/pedro/encoder/Frame;", "mute", "unMute", "isMuted", "setAudioEffect", "effect", "Lcom/pedro/encoder/input/audio/CustomAudioEffect;", "value", "", "mixVolume", "getMixVolume", "()F", "setMixVolume", "(F)V", "microphoneVolume", "getMicrophoneVolume", "setMicrophoneVolume", "internalVolume", "getInternalVolume", "setInternalVolume", "encoder_release"})
@RequiresApi(value=29)
public final class MixAudioSource
extends AudioSource
implements GetMicrophoneData {
    private final int microphoneAudioSource;
    @NotNull
    private final String TAG;
    @NotNull
    private HandlerThread handlerThread;
    @NotNull
    private final MicrophoneManager microphone;
    @Nullable
    private AudioDeviceInfo preferredDevice;
    @NotNull
    private final MediaProjection.Callback mediaProjectionCallback;

    public MixAudioSource(@NotNull MediaProjection mediaProjection, @Nullable MediaProjection.Callback mediaProjectionCallback2, int microphoneAudioSource) {
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.microphoneAudioSource = microphoneAudioSource;
        this.TAG = "MixAudioSource";
        this.handlerThread = new HandlerThread(this.TAG);
        this.microphone = new MicrophoneManager(this);
        MediaProjection.Callback callback2 = mediaProjectionCallback2;
        if (callback2 == null) {
            callback2 = new MediaProjection.Callback(){};
        }
        this.mediaProjectionCallback = callback2;
        MediaProjectionHandler.INSTANCE.setMediaProjection(mediaProjection);
    }

    public /* synthetic */ MixAudioSource(MediaProjection mediaProjection, MediaProjection.Callback callback2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            callback2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(mediaProjection, callback2, n);
    }

    @Override
    protected boolean create(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        boolean result = this.microphone.createMicrophone(this.microphoneAudioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (!result) {
            throw new IllegalArgumentException("Some parameters specified are not valid");
        }
        return true;
    }

    public final boolean setPreferredDevice(@Nullable AudioDeviceInfo deviceInfo) {
        this.preferredDevice = deviceInfo;
        return this.microphone.setPreferredDevice(deviceInfo);
    }

    @Override
    public void start(@NotNull GetMicrophoneData getMicrophoneData) {
        Intrinsics.checkNotNullParameter((Object)getMicrophoneData, (String)"getMicrophoneData");
        this.setGetMicrophoneData(getMicrophoneData);
        if (!this.isRunning()) {
            this.handlerThread = new HandlerThread(this.TAG);
            this.handlerThread.start();
            MediaProjection mediaProjection = MediaProjectionHandler.INSTANCE.getMediaProjection();
            if (mediaProjection != null) {
                mediaProjection.registerCallback(this.mediaProjectionCallback, new Handler(this.handlerThread.getLooper()));
            }
            MediaProjection mediaProjection2 = MediaProjectionHandler.INSTANCE.getMediaProjection();
            Intrinsics.checkNotNull((Object)mediaProjection2);
            AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = new AudioPlaybackCaptureConfiguration.Builder(mediaProjection2).addMatchingUsage(1).addMatchingUsage(14).addMatchingUsage(0).build();
            Intrinsics.checkNotNullExpressionValue((Object)audioPlaybackCaptureConfiguration, (String)"build(...)");
            AudioPlaybackCaptureConfiguration config = audioPlaybackCaptureConfiguration;
            boolean result = this.microphone.createMixMicrophone(this.microphoneAudioSource, config, this.getSampleRate(), this.isStereo(), this.getEchoCanceler(), this.getNoiseSuppressor());
            if (!result) {
                throw new IllegalArgumentException("Failed to create microphone audio source");
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.microphone.setPreferredDevice(this.preferredDevice);
            }
            this.microphone.start();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.setGetMicrophoneData(null);
            this.microphone.stop();
            this.handlerThread.quitSafely();
        }
    }

    @Override
    public boolean isRunning() {
        return this.microphone.isRunning();
    }

    @Override
    public void release() {
    }

    @Override
    public void inputPCMData(@NotNull Frame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            GetMicrophoneData getMicrophoneData = this.getGetMicrophoneData();
            if (getMicrophoneData == null) break block0;
            getMicrophoneData.inputPCMData(frame);
        }
    }

    public final void mute() {
        this.microphone.mute();
    }

    public final void unMute() {
        this.microphone.unMute();
    }

    public final boolean isMuted() {
        return this.microphone.isMuted();
    }

    public final void setAudioEffect(@NotNull CustomAudioEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.microphone.setCustomAudioEffect(effect);
    }

    public final float getMixVolume() {
        return (this.microphone.getMicrophoneVolume() + this.microphone.getInternalVolume()) / 2.0f;
    }

    public final void setMixVolume(float value) {
        this.microphone.setVolume(value);
    }

    public final float getMicrophoneVolume() {
        return this.microphone.getMicrophoneVolume();
    }

    public final void setMicrophoneVolume(float value) {
        this.microphone.setMicrophoneVolume(value);
    }

    public final float getInternalVolume() {
        return this.microphone.getInternalVolume();
    }

    public final void setInternalVolume(float value) {
        this.microphone.setInternalVolume(value);
    }
}

