/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.Sprite;
import com.pedro.encoder.input.gl.TextureLoader;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class ChromaFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int aTextureObjectHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uObjectHandle = -1;
    private int uSensitiveHandle = -1;
    private FloatBuffer squareVertexObject;
    protected int[] streamObjectTextureId = new int[]{-1};
    protected TextureLoader textureLoader = new TextureLoader();
    protected StreamObjectBase streamObject = new ImageStreamObject();
    private Sprite sprite;
    protected boolean shouldLoad = false;
    private float sensitive = 0.8f;

    public ChromaFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        this.sprite = new Sprite();
        float[] vertices = this.sprite.getTransformedVertices();
        this.squareVertexObject = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertexObject.put(vertices).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.object_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.chroma_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.aTextureObjectHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureObjectCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uObjectHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uObject");
        this.uSensitiveHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSensitive");
    }

    @Override
    protected void drawFilter() {
        if (this.shouldLoad) {
            this.releaseTexture();
            this.streamObjectTextureId = this.textureLoader.load(this.streamObject.getBitmaps());
            this.shouldLoad = false;
        }
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        this.squareVertexObject.position(0);
        GLES20.glVertexAttribPointer((int)this.aTextureObjectHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.squareVertexObject);
        GLES20.glEnableVertexAttribArray((int)this.aTextureObjectHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
        GLES20.glUniform1i((int)this.uObjectHandle, (int)1);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[0]);
        GLES20.glUniform1f((int)this.uSensitiveHandle, (float)this.sensitive);
    }

    @Override
    protected void disableResources() {
        GlUtil.disableResources(this.aTextureHandle, this.aTextureObjectHandle, this.aPositionHandle);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
        this.releaseTexture();
        this.sprite.reset();
    }

    private void releaseTexture() {
        GLES20.glDeleteTextures((int)this.streamObjectTextureId.length, (int[])this.streamObjectTextureId, (int)0);
        this.streamObjectTextureId = new int[]{-1};
    }

    private void setScale(float scaleX, float scaleY) {
        this.sprite.scale(scaleX, scaleY);
        this.squareVertexObject.put(this.sprite.getTransformedVertices()).position(0);
    }

    private void setPosition(TranslateTo positionTo) {
        this.sprite.translate(positionTo);
        this.squareVertexObject.put(this.sprite.getTransformedVertices()).position(0);
    }

    public void setImage(Bitmap bitmap) {
        ((ImageStreamObject)this.streamObject).load(bitmap);
        this.shouldLoad = true;
        this.setScale(100.0f, 100.0f);
        this.setPosition(TranslateTo.CENTER);
    }

    public void setSensitive(float sensitive) {
        this.sensitive = sensitive;
    }
}

