/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import com.pedro.encoder.input.audio.AudioUtils;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/pedro/encoder/input/audio/AmplitudeEffect;", "Lcom/pedro/encoder/input/audio/CustomAudioEffect;", "listener", "Lcom/pedro/encoder/input/audio/AmplitudeEffect$Listener;", "<init>", "(Lcom/pedro/encoder/input/audio/AmplitudeEffect$Listener;)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "audioUtils", "Lcom/pedro/encoder/input/audio/AudioUtils;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "running", "", "process", "pcmBuffer", "start", "", "stop", "isRunning", "Listener", "encoder_release"})
public final class AmplitudeEffect
extends CustomAudioEffect {
    @NotNull
    private final Listener listener;
    @NotNull
    private final LinkedBlockingQueue<byte[]> queue;
    @NotNull
    private final AudioUtils audioUtils;
    private ExecutorService executor;
    private boolean running;

    public AmplitudeEffect(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.queue = new LinkedBlockingQueue(200);
        this.audioUtils = new AudioUtils();
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    @NotNull
    public byte[] process(@NotNull byte[] pcmBuffer) {
        Intrinsics.checkNotNullParameter((Object)pcmBuffer, (String)"pcmBuffer");
        if (this.running) {
            byte[] buffer = (byte[])pcmBuffer.clone();
            this.queue.offer(buffer);
        }
        return pcmBuffer;
    }

    public final void start() {
        this.queue.clear();
        this.running = true;
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute(() -> AmplitudeEffect.start$lambda$0(this));
    }

    public final void stop() {
        this.running = false;
        this.executor.shutdownNow();
        this.queue.clear();
    }

    public final boolean isRunning() {
        return this.running;
    }

    private static final void start$lambda$0(AmplitudeEffect this$0) {
        while (this$0.running) {
            byte[] buffer = this$0.queue.take();
            AudioUtils audioUtils = this$0.audioUtils;
            Intrinsics.checkNotNull((Object)buffer);
            float amplitude = audioUtils.calculateAmplitude(buffer);
            this$0.listener.onAmplitude(amplitude);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/pedro/encoder/input/audio/AmplitudeEffect$Listener;", "", "onAmplitude", "", "value", "", "encoder_release"})
    public static interface Listener {
        public void onAmplitude(float var1);
    }
}

