/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.video.Camera2ResolutionCalculator;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import com.pedro.encoder.input.video.facedetector.UtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u00b7\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'2\u0006\u0010&\u001a\u00020'J.\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017J.\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u00105\u001a\u0002062\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'J\u0010\u0010<\u001a\u0002062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010=\u001a\u00020>2\u0006\u0010\b\u001a\u00020\t2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0@H\u0002J$\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0B0@2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010H\u001a\u000206J\u0006\u0010I\u001a\u000206J\u0006\u0010J\u001a\u000206J\u000e\u0010K\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u0007J\u0019\u0010W\u001a\b\u0012\u0004\u0012\u00020D0R2\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010XJ\u0019\u0010W\u001a\b\u0012\u0004\u0012\u00020D0R2\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0002\u0010YJ\u000e\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00070@H\u0007J\u0012\u0010_\u001a\u0002062\b\u0010`\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010a\u001a\u0002062\b\u0010`\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010b\u001a\u00020\u00132\u0006\u0010c\u001a\u00020\u0019H\u0002J\u000e\u0010d\u001a\u00020\u00132\u0006\u0010e\u001a\u00020'J\u0006\u0010f\u001a\u000206J\f\u0010g\u001a\b\u0012\u0004\u0012\u00020'0@J\u0006\u0010h\u001a\u00020'J&\u0010i\u001a\u00020\u00132\u0006\u0010j\u001a\u00020\u001b2\u0006\u0010k\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020\u001b2\u0006\u0010m\u001a\u00020\u001bJ\u0006\u0010n\u001a\u00020\u0013J\u0006\u0010o\u001a\u000206J\u0006\u0010p\u001a\u00020\u0013J\u0006\u0010q\u001a\u000206J\u0006\u0010r\u001a\u00020\u0013J\u0006\u0010s\u001a\u000206J\u000e\u0010t\u001a\u0002062\u0006\u0010u\u001a\u00020\u001bJ\u0006\u0010v\u001a\u00020\u0007J\u0010\u0010\u007f\u001a\u00020\u00132\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001J\u0010\u0010\u0082\u0001\u001a\u0002062\u0007\u0010\u0083\u0001\u001a\u00020\u0017J\u0007\u0010\u0085\u0001\u001a\u000206J\u0007\u0010\u0086\u0001\u001a\u000206J\u0007\u0010\u0087\u0001\u001a\u00020\u0013J\u0007\u0010\u0088\u0001\u001a\u00020\u0013J\u0011\u0010\u0089\u0001\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u000100J\u0007\u0010\u008a\u0001\u001a\u000206J\u0007\u0010\u008b\u0001\u001a\u00020\u0013J\u0011\u0010\u008c\u0001\u001a\u0002062\b\u0010*\u001a\u0004\u0018\u00010+J\u0011\u0010\u008f\u0001\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J\u0007\u0010\u0094\u0001\u001a\u000206J\u000f\u0010\u0095\u0001\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u0007J\u0013\u0010\u009f\u0001\u001a\b\u0012\u0004\u0012\u00020\u001b0R\u00a2\u0006\u0003\u0010\u00a0\u0001J\u0010\u0010\u00a1\u0001\u001a\u0002062\u0007\u0010\u0099\u0001\u001a\u00020\u001bJ\u001e\u0010\u009d\u0001\u001a\u0002062\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\t\b\u0002\u0010\u00a2\u0001\u001a\u00020\u001bH\u0007J\u0014\u0010\u00a3\u0001\u001a\u0002062\t\b\u0002\u0010\u00a4\u0001\u001a\u00020\u0013H\u0007J<\u0010\u00a5\u0001\u001a\u0002062\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'2\u0007\u0010\u00a6\u0001\u001a\u00020'2\u0007\u0010\u00a7\u0001\u001a\u00020'2\u0007\u0010\u00a8\u0001\u001a\u00020\u00132\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001J\u0007\u0010\u00ab\u0001\u001a\u000206J\u0011\u0010\u00ac\u0001\u001a\u0002062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\u00ad\u0001\u001a\u0002062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u00ae\u0001\u001a\u0002062\u0006\u0010\b\u001a\u00020\t2\u0007\u0010\u00af\u0001\u001a\u00020'H\u0016J\u001b\u0010\u00b0\u0001\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0019\u0010\u00b1\u0001\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002JV\u0010\u00b2\u0001\u001a\u0002062\u0006\u0010\b\u001a\u00020\t2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0@2\u0014\u0010\u00b3\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002060\u00b4\u00012\u0014\u0010\u00b5\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002060\u00b4\u00012\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u000fH\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u001e\u0010\"\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u001e\u0010#\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u001e\u0010$\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u001e\u0010%\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001fR\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010E\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR$\u0010L\u001a\u00020\u00172\u0006\u0010L\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u0017\u0010Q\u001a\b\u0012\u0004\u0012\u00020D0R8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020D0R8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010TR\u0013\u0010Z\u001a\u0004\u0018\u00010[8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R$\u0010w\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bx\u0010G\"\u0004\by\u0010zR\u0011\u0010{\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b|\u0010GR\u0011\u0010}\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b~\u0010GR\u0013\u0010\u0084\u0001\u001a\u00020\u00138F\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010\u001fR\u0010\u0010\u008d\u0001\u001a\u00030\u008e\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070R\u00a2\u0006\r\n\u0003\u0010\u0093\u0001\u001a\u0006\b\u0091\u0001\u0010\u0092\u0001R\u001a\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\u001b0B8F\u00a2\u0006\b\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001R*\u0010\u009a\u0001\u001a\u00020\u001b2\u0007\u0010\u0099\u0001\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\u0010\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001\"\u0006\b\u009d\u0001\u0010\u009e\u0001\u00a8\u0006\u00b8\u0001"}, d2={"Lcom/pedro/encoder/input/video/Camera2ApiManager;", "Landroid/hardware/camera2/CameraDevice$StateCallback;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "TAG", "", "cameraDevice", "Landroid/hardware/camera2/CameraDevice;", "surfaceEncoder", "Landroid/view/Surface;", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "cameraHandler", "Landroid/os/Handler;", "cameraCaptureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "isPrepared", "", "cameraId", "physicalCameraId", "facing", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "builderInputSurface", "Landroid/hardware/camera2/CaptureRequest$Builder;", "fingerSpacing", "", "zoomLevel", "value", "isLanternEnabled", "()Z", "isVideoStabilizationEnabled", "isOpticalStabilizationEnabled", "isAutoFocusEnabled", "isAutoExposureEnabled", "isAutoWhiteBalanceEnabled", "isRunning", "fps", "", "semaphore", "Ljava/util/concurrent/Semaphore;", "cameraCallbacks", "Lcom/pedro/encoder/input/video/CameraCallbacks;", "sensorOrientation", "faceSensorScale", "Landroid/graphics/Rect;", "faceDetectorCallback", "Lcom/pedro/encoder/input/video/facedetector/FaceDetectorCallback;", "faceDetectionEnabled", "faceDetectionMode", "imageReader", "Landroid/media/ImageReader;", "prepareCamera", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "height", "surface", "startPreview", "drawSurface", "Landroid/hardware/camera2/CaptureRequest;", "surfaces", "", "getSupportedFps", "Landroid/util/Range;", "size", "Landroid/util/Size;", "levelSupported", "getLevelSupported", "()I", "openCameraBack", "openCameraFront", "openLastCamera", "setCameraId", "cameraFacing", "getCameraFacing", "()Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "setCameraFacing", "(Lcom/pedro/encoder/input/video/CameraHelper$Facing;)V", "cameraResolutionsBack", "", "getCameraResolutionsBack", "()[Landroid/util/Size;", "cameraResolutionsFront", "getCameraResolutionsFront", "getCameraResolutions", "(Lcom/pedro/encoder/input/video/CameraHelper$Facing;)[Landroid/util/Size;", "(Ljava/lang/String;)[Landroid/util/Size;", "cameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "getCameraCharacteristics", "()Landroid/hardware/camera2/CameraCharacteristics;", "getPhysicalCamerasAvailable", "setPhysicalCamera", "id", "openPhysicalCamera", "applyRequest", "builder", "enableAutoWhiteBalance", "mode", "disableAutoWhiteBalance", "getAutoWhiteBalanceModesAvailable", "getWhiteBalance", "setColorCorrectionGains", "red", "greenEven", "greenOdd", "blue", "enableAutoExposure", "disableAutoExposure", "enableVideoStabilization", "disableVideoStabilization", "enableOpticalVideoStabilization", "disableOpticalVideoStabilization", "setFocusDistance", "distance", "getCurrentCameraId", "exposure", "getExposure", "setExposure", "(I)V", "maxExposure", "getMaxExposure", "minExposure", "getMinExposure", "tapToFocus", "event", "Landroid/view/MotionEvent;", "openCameraFacing", "selectedCameraFacing", "isLanternSupported", "enableLantern", "disableLantern", "enableAutoFocus", "disableAutoFocus", "enableFaceDetection", "disableFaceDetection", "isFaceDetectionEnabled", "setCameraCallbacks", "cb", "Landroid/hardware/camera2/CameraCaptureSession$CaptureCallback;", "openCameraId", "camerasAvailable", "getCamerasAvailable", "()[Ljava/lang/String;", "[Ljava/lang/String;", "switchCamera", "reOpenCamera", "zoomRange", "getZoomRange", "()Landroid/util/Range;", "level", "zoom", "getZoom", "()F", "setZoom", "(F)V", "getOpticalZooms", "()[Ljava/lang/Float;", "setOpticalZoom", "delta", "closeCamera", "resetSurface", "addImageListener", "format", "maxImages", "autoClose", "listener", "Lcom/pedro/encoder/input/video/Camera2ApiManager$ImageCallback;", "removeImageListener", "onOpened", "onDisconnected", "onError", "i", "getCameraIdForFacing", "getFacingByCameraId", "createCaptureSession", "onConfigured", "Lkotlin/Function1;", "onConfiguredFailed", "handler", "ImageCallback", "encoder_release"})
@RequiresApi(api=21)
@SourceDebugExtension(value={"SMAP\nCamera2ApiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera2ApiManager.kt\ncom/pedro/encoder/input/video/Camera2ApiManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,887:1\n1#2:888\n1557#3:889\n1628#3,3:890\n1863#3,2:893\n*S KotlinDebug\n*F\n+ 1 Camera2ApiManager.kt\ncom/pedro/encoder/input/video/Camera2ApiManager\n*L\n874#1:889\n874#1:890,3\n875#1:893,2\n*E\n"})
public final class Camera2ApiManager
extends CameraDevice.StateCallback {
    @NotNull
    private final String TAG;
    @Nullable
    private CameraDevice cameraDevice;
    @NotNull
    private Surface surfaceEncoder;
    @NotNull
    private final CameraManager cameraManager;
    @Nullable
    private Handler cameraHandler;
    @Nullable
    private CameraCaptureSession cameraCaptureSession;
    private boolean isPrepared;
    @NotNull
    private String cameraId;
    @Nullable
    private String physicalCameraId;
    @NotNull
    private CameraHelper.Facing facing;
    @Nullable
    private CaptureRequest.Builder builderInputSurface;
    private float fingerSpacing;
    private float zoomLevel;
    private boolean isLanternEnabled;
    private boolean isVideoStabilizationEnabled;
    private boolean isOpticalStabilizationEnabled;
    private boolean isAutoFocusEnabled;
    private boolean isAutoExposureEnabled;
    private boolean isAutoWhiteBalanceEnabled;
    private boolean isRunning;
    private int fps;
    @NotNull
    private final Semaphore semaphore;
    @Nullable
    private CameraCallbacks cameraCallbacks;
    private int sensorOrientation;
    @Nullable
    private Rect faceSensorScale;
    @Nullable
    private FaceDetectorCallback faceDetectorCallback;
    private boolean faceDetectionEnabled;
    private int faceDetectionMode;
    @Nullable
    private ImageReader imageReader;
    @NotNull
    private final CameraCaptureSession.CaptureCallback cb;
    @NotNull
    private final String[] camerasAvailable;

    /*
     * WARNING - void declaration
     */
    public Camera2ApiManager(@NotNull Context context) {
        Camera2ApiManager camera2ApiManager;
        void $this$surfaceEncoder_u24lambda_u2412;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.TAG = "Camera2ApiManager";
        SurfaceTexture surfaceTexture = object = new SurfaceTexture(-1);
        Camera2ApiManager camera2ApiManager2 = this;
        boolean bl = false;
        $this$surfaceEncoder_u24lambda_u2412.release();
        SurfaceTexture surfaceTexture2 = object;
        camera2ApiManager2.surfaceEncoder = new Surface(surfaceTexture2);
        Object object2 = context.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        this.cameraManager = (CameraManager)object2;
        this.cameraId = "0";
        this.facing = CameraHelper.Facing.BACK;
        this.isAutoFocusEnabled = true;
        this.isAutoWhiteBalanceEnabled = true;
        this.fps = 30;
        this.semaphore = new Semaphore(0);
        camera2ApiManager2 = this;
        try {
            camera2ApiManager = camera2ApiManager2;
            object = Camera2ApiManager.getCameraIdForFacing$default(this, CameraHelper.Facing.BACK, null, 2, null);
        }
        catch (Exception $this$surfaceEncoder_u24lambda_u2412) {
            camera2ApiManager = camera2ApiManager2;
            object = "0";
        }
        camera2ApiManager.cameraId = object;
        this.cb = new CameraCaptureSession.CaptureCallback(this){
            final /* synthetic */ Camera2ApiManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    Face[] faceArray = (Face[])result.get(CaptureResult.STATISTICS_FACES);
                    if (faceArray == null) {
                        return;
                    }
                    Face[] faces = faceArray;
                    FaceDetectorCallback faceDetectorCallback = Camera2ApiManager.access$getFaceDetectorCallback$p(this.this$0);
                    if (faceDetectorCallback == null) break block1;
                    faceDetectorCallback.onGetFaces(UtilsKt.mapCamera2Faces(faces), Camera2ApiManager.access$getFaceSensorScale$p(this.this$0), Camera2ApiManager.access$getSensorOrientation$p(this.this$0));
                }
            }
        };
        String[] stringArray = this.cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
        this.camerasAvailable = stringArray;
    }

    public final boolean isLanternEnabled() {
        return this.isLanternEnabled;
    }

    public final boolean isVideoStabilizationEnabled() {
        return this.isVideoStabilizationEnabled;
    }

    public final boolean isOpticalStabilizationEnabled() {
        return this.isOpticalStabilizationEnabled;
    }

    public final boolean isAutoFocusEnabled() {
        return this.isAutoFocusEnabled;
    }

    public final boolean isAutoExposureEnabled() {
        return this.isAutoExposureEnabled;
    }

    public final boolean isAutoWhiteBalanceEnabled() {
        return this.isAutoWhiteBalanceEnabled;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void prepareCamera(@NotNull SurfaceTexture surfaceTexture, int width, int height, int fps) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        Size optimalResolution = Camera2ResolutionCalculator.INSTANCE.getOptimalResolution(new Size(width, height), this.getCameraResolutions(this.facing));
        Log.i((String)this.TAG, (String)("optimal resolution set to: " + optimalResolution.getWidth() + "x" + optimalResolution.getHeight()));
        surfaceTexture.setDefaultBufferSize(optimalResolution.getWidth(), optimalResolution.getHeight());
        this.surfaceEncoder = new Surface(surfaceTexture);
        this.fps = fps;
        this.isPrepared = true;
    }

    public final void prepareCamera(@NotNull SurfaceTexture surfaceTexture, int width, int height, int fps, @NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        this.facing = facing;
        this.prepareCamera(surfaceTexture, width, height, fps);
    }

    public final void prepareCamera(@NotNull SurfaceTexture surfaceTexture, int width, int height, int fps, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        this.cameraId = cameraId;
        this.facing = this.getFacingByCameraId(this.cameraManager, cameraId);
        this.prepareCamera(surfaceTexture, width, height, fps);
    }

    public final void prepareCamera(@NotNull Surface surface, int fps) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.surfaceEncoder = surface;
        this.fps = fps;
        this.isPrepared = true;
    }

    private final void startPreview(CameraDevice cameraDevice) {
        try {
            List listSurfaces = new ArrayList();
            listSurfaces.add(this.surfaceEncoder);
            ImageReader imageReader = this.imageReader;
            if (imageReader != null) {
                ImageReader it = imageReader;
                boolean bl = false;
                Surface surface = it.getSurface();
                Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
                listSurfaces.add(surface);
            }
            CaptureRequest captureRequest = this.drawSurface(cameraDevice, listSurfaces);
            this.createCaptureSession(cameraDevice, listSurfaces, (Function1<? super CameraCaptureSession, Unit>)((Function1)arg_0 -> Camera2ApiManager.startPreview$lambda$2(this, captureRequest, arg_0)), (Function1<? super CameraCaptureSession, Unit>)((Function1)arg_0 -> Camera2ApiManager.startPreview$lambda$3(this, arg_0)), this.cameraHandler);
        }
        catch (IllegalStateException e) {
            this.reOpenCamera(this.cameraId);
        }
        catch (Exception e) {
            CameraCallbacks cameraCallbacks = this.cameraCallbacks;
            if (cameraCallbacks != null) {
                cameraCallbacks.onCameraError("Create capture session failed: " + e.getMessage());
            }
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    private final CaptureRequest drawSurface(CameraDevice cameraDevice, List<? extends Surface> surfaces) throws IllegalStateException, Exception {
        CaptureRequest.Builder builder = cameraDevice.createCaptureRequest(1);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createCaptureRequest(...)");
        CaptureRequest.Builder builderInputSurface = builder;
        for (Surface surface : surfaces) {
            builderInputSurface.addTarget(surface);
        }
        builderInputSurface.set(CaptureRequest.CONTROL_MODE, (Object)1);
        int validFps = Math.min(60, this.fps);
        builderInputSurface.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(validFps), (Comparable)Integer.valueOf(validFps)));
        this.builderInputSurface = builderInputSurface;
        CaptureRequest captureRequest = builderInputSurface.build();
        Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"build(...)");
        return captureRequest;
    }

    @NotNull
    public final List<Range<Integer>> getSupportedFps(@Nullable Size size, @NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        try {
            List list;
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(Camera2ApiManager.getCameraIdForFacing$default(this, facing, null, 2, null));
            Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"getCameraCharacteristics(...)");
            CameraCharacteristics characteristics = cameraCharacteristics;
            Range[] rangeArray = (Range[])characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            if (rangeArray == null) {
                return CollectionsKt.emptyList();
            }
            Range[] fpsSupported = rangeArray;
            if (size != null) {
                StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                List list2 = new ArrayList();
                StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap;
                if (streamConfigurationMap2 == null) {
                    return CollectionsKt.emptyList();
                }
                long fd = streamConfigurationMap2.getOutputMinFrameDuration(SurfaceTexture.class, size);
                int maxFPS = (int)(10.0f / Float.parseFloat("0." + fd));
                for (Range r : fpsSupported) {
                    if (((Number)((Object)r.getUpper())).intValue() > maxFPS) continue;
                    Intrinsics.checkNotNull((Object)r);
                    list2.add(r);
                }
                list = list2;
            } else {
                list = CollectionsKt.listOf((Object[])Arrays.copyOf(fpsSupported, fpsSupported.length));
            }
            return list;
        }
        catch (IllegalStateException e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    public final int getLevelSupported() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return -1;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CameraCharacteristics.Key key = CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"INFO_SUPPORTED_HARDWARE_LEVEL");
        Integer n = (Integer)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        return n != null ? n : -1;
    }

    public final void openCameraBack() {
        this.openCameraFacing(CameraHelper.Facing.BACK);
    }

    public final void openCameraFront() {
        this.openCameraFacing(CameraHelper.Facing.FRONT);
    }

    public final void openLastCamera() {
        this.openCameraId(this.cameraId);
    }

    public final void setCameraId(@NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        this.cameraId = cameraId;
    }

    @NotNull
    public final CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    public final void setCameraFacing(@NotNull CameraHelper.Facing cameraFacing) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraFacing), (String)"cameraFacing");
        try {
            String cameraId = Camera2ApiManager.getCameraIdForFacing$default(this, cameraFacing, null, 2, null);
            this.facing = cameraFacing;
            this.cameraId = cameraId;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    @NotNull
    public final Size[] getCameraResolutionsBack() {
        return this.getCameraResolutions(CameraHelper.Facing.BACK);
    }

    @NotNull
    public final Size[] getCameraResolutionsFront() {
        return this.getCameraResolutions(CameraHelper.Facing.FRONT);
    }

    @NotNull
    public final Size[] getCameraResolutions(@NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        return this.getCameraResolutions(Camera2ApiManager.getCameraIdForFacing$default(this, facing, null, 2, null));
    }

    @NotNull
    public final Size[] getCameraResolutions(@NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        try {
            Size[] outputSizes;
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(cameraId);
            Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"getCameraCharacteristics(...)");
            CameraCharacteristics characteristics = cameraCharacteristics;
            CameraCharacteristics.Key key = CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SCALER_STREAM_CONFIGURATION_MAP");
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
            if (streamConfigurationMap == null) {
                return new Size[0];
            }
            StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap;
            Size[] sizeArray = outputSizes = streamConfigurationMap2.getOutputSizes(SurfaceTexture.class);
            if (outputSizes == null) {
                sizeArray = new Size[]{};
            }
            return sizeArray;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            return new Size[0];
        }
    }

    @Nullable
    public final CameraCharacteristics getCameraCharacteristics() {
        try {
            return this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            return null;
        }
    }

    @RequiresApi(value=28)
    @NotNull
    public final List<String> getPhysicalCamerasAvailable() {
        Object object = this.getCameraCharacteristics();
        if (object == null || (object = object.getPhysicalCameraIds()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @RequiresApi(value=28)
    public final void setPhysicalCamera(@Nullable String id) {
        this.physicalCameraId = id;
    }

    @RequiresApi(value=28)
    public final void openPhysicalCamera(@Nullable String id) {
        this.setPhysicalCamera(id);
        if (this.isRunning) {
            this.reOpenCamera(this.cameraId);
        } else {
            this.openCameraId(this.cameraId);
        }
    }

    private final boolean applyRequest(CaptureRequest.Builder builder) {
        this.builderInputSurface = builder;
        CameraCaptureSession cameraCaptureSession = this.cameraCaptureSession;
        if (cameraCaptureSession == null) {
            return false;
        }
        CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
        try {
            cameraCaptureSession2.setRepeatingRequest(builder.build(), this.faceDetectionEnabled ? this.cb : null, null);
            return true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            return false;
        }
    }

    public final boolean enableAutoWhiteBalance(int mode) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_AVAILABLE_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)mode)) {
            return false;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_AWB_MODE, (Object)mode);
        this.isAutoWhiteBalanceEnabled = this.applyRequest(builderInputSurface);
        return this.isAutoWhiteBalanceEnabled;
    }

    public final void disableAutoWhiteBalance() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_AVAILABLE_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)0)) {
            return;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_AWB_MODE, (Object)0);
        this.applyRequest(builderInputSurface);
        this.isAutoExposureEnabled = false;
    }

    @NotNull
    public final List<Integer> getAutoWhiteBalanceModesAvailable() {
        Object object;
        block5: {
            block4: {
                CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
                if (cameraCharacteristics == null) {
                    return CollectionsKt.emptyList();
                }
                CameraCharacteristics characteristics = cameraCharacteristics;
                CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_AVAILABLE_MODES");
                object = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
                if (object == null) break block4;
                List list = ArraysKt.toList((int[])object);
                object = list;
                if (list != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final int getWhiteBalance() {
        int n = 1;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return n;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CaptureRequest.Key key = CaptureRequest.CONTROL_AWB_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_MODE");
        Integer n2 = (Integer)ExtensionsKt.secureGet((CaptureRequest.Builder)builderInputSurface, (CaptureRequest.Key)key);
        return n2 != null ? n2 : n;
    }

    public final boolean setColorCorrectionGains(float red, float greenEven, float greenOdd, float blue) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)0)) {
            return false;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_AWB_MODE, (Object)0);
        builderInputSurface.set(CaptureRequest.COLOR_CORRECTION_MODE, (Object)0);
        builderInputSurface.set(CaptureRequest.COLOR_CORRECTION_TRANSFORM, characteristics.get(CameraCharacteristics.SENSOR_CALIBRATION_TRANSFORM1));
        RggbChannelVector vector = new RggbChannelVector(red, greenEven, greenOdd, blue);
        builderInputSurface.set(CaptureRequest.COLOR_CORRECTION_GAINS, (Object)vector);
        return this.applyRequest(builderInputSurface);
    }

    public final boolean enableAutoExposure() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_AVAILABLE_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)1)) {
            return false;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        this.isAutoExposureEnabled = this.applyRequest(builderInputSurface);
        return this.isAutoExposureEnabled;
    }

    public final void disableAutoExposure() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_AVAILABLE_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)1)) {
            return;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_AE_MODE, (Object)0);
        this.applyRequest(builderInputSurface);
        this.isAutoExposureEnabled = false;
    }

    public final boolean enableVideoStabilization() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)1)) {
            return false;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
        this.isVideoStabilizationEnabled = this.applyRequest(builderInputSurface);
        return this.isVideoStabilizationEnabled;
    }

    public final void disableVideoStabilization() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)1)) {
            return;
        }
        builderInputSurface.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
        this.applyRequest(builderInputSurface);
        this.isVideoStabilizationEnabled = false;
    }

    public final boolean enableOpticalVideoStabilization() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        int[] opticalStabilizationModes = nArray;
        if (!ArraysKt.contains((int[])opticalStabilizationModes, (int)1)) {
            return false;
        }
        builderInputSurface.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
        this.isOpticalStabilizationEnabled = this.applyRequest(builderInputSurface);
        return this.isOpticalStabilizationEnabled;
    }

    public final void disableOpticalVideoStabilization() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return;
        }
        int[] modes = nArray;
        if (!ArraysKt.contains((int[])modes, (int)1)) {
            return;
        }
        builderInputSurface.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
        this.applyRequest(builderInputSurface);
        this.isOpticalStabilizationEnabled = false;
    }

    public final void setFocusDistance(float distance) {
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        builderInputSurface.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(Math.max(0.0f, distance)));
        this.applyRequest(builderInputSurface);
    }

    @NotNull
    public final String getCurrentCameraId() {
        return this.cameraId;
    }

    public final int getExposure() {
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return 0;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CaptureRequest.Key key = CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_EXPOSURE_COMPENSATION");
        Integer n = (Integer)ExtensionsKt.secureGet((CaptureRequest.Builder)builderInputSurface, (CaptureRequest.Key)key);
        return n != null ? n : 0;
    }

    public final void setExposure(int value) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_COMPENSATION_RANGE");
        Range range = (Range)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (range == null) {
            return;
        }
        Range supportedExposure = range;
        Comparable comparable = supportedExposure.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getLower(...)");
        int n = ((Number)((Object)comparable)).intValue();
        Comparable comparable2 = supportedExposure.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getUpper(...)");
        int v = RangesKt.coerceIn((int)value, (int)n, (int)((Number)((Object)comparable2)).intValue());
        builderInputSurface.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)v);
        this.applyRequest(builderInputSurface);
    }

    public final int getMaxExposure() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return 0;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_COMPENSATION_RANGE");
        Object object = (Range)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        int supportedExposure = object != null && (object = (Integer)object.getUpper()) != null ? (Integer)object : 0;
        return supportedExposure;
    }

    public final int getMinExposure() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return 0;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_COMPENSATION_RANGE");
        Object object = (Range)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        int supportedExposure = object != null && (object = (Integer)object.getLower()) != null ? (Integer)object : 0;
        return supportedExposure;
    }

    public final boolean tapToFocus(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        boolean result = false;
        int pointerId = event.getPointerId(0);
        int pointerIndex = event.findPointerIndex(pointerId);
        float x = event.getX(pointerIndex);
        float y = event.getY(pointerIndex);
        if (x < 100.0f || y < 100.0f) {
            return false;
        }
        Rect touchRect = new Rect((int)(x - (float)100), (int)(y - (float)100), (int)(x + (float)100), (int)(y + (float)100));
        MeteringRectangle focusArea = new MeteringRectangle(touchRect, 0);
        try {
            builderInputSurface.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            this.applyRequest(builderInputSurface);
            MeteringRectangle[] meteringRectangleArray = new MeteringRectangle[]{focusArea};
            builderInputSurface.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)meteringRectangleArray);
            builderInputSurface.set(CaptureRequest.CONTROL_MODE, (Object)1);
            builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            builderInputSurface.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.isAutoFocusEnabled = this.applyRequest(builderInputSurface);
            result = true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
        return result;
    }

    public final void openCameraFacing(@NotNull CameraHelper.Facing selectedCameraFacing) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedCameraFacing), (String)"selectedCameraFacing");
        try {
            String cameraId = Camera2ApiManager.getCameraIdForFacing$default(this, selectedCameraFacing, null, 2, null);
            this.openCameraId(cameraId);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    public final boolean isLanternSupported() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CameraCharacteristics.Key key = CameraCharacteristics.FLASH_INFO_AVAILABLE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"FLASH_INFO_AVAILABLE");
        Boolean bl = (Boolean)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (bl == null) {
            return false;
        }
        boolean available = bl;
        return available;
    }

    public final void enableLantern() throws Exception {
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        if (this.isLanternSupported()) {
            try {
                builderInputSurface.set(CaptureRequest.FLASH_MODE, (Object)2);
                this.isLanternEnabled = this.applyRequest(builderInputSurface);
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e) {
                Integer n = Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            }
        } else {
            Log.e((String)this.TAG, (String)"Lantern unsupported");
            throw new Exception("Lantern unsupported");
        }
    }

    public final void disableLantern() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.FLASH_INFO_AVAILABLE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"FLASH_INFO_AVAILABLE");
        Boolean bl = (Boolean)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (bl == null) {
            return;
        }
        boolean available = bl;
        if (available) {
            try {
                builderInputSurface.set(CaptureRequest.FLASH_MODE, (Object)0);
                this.applyRequest(builderInputSurface);
                this.isLanternEnabled = false;
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            }
        }
    }

    public final boolean enableAutoFocus() {
        boolean result = false;
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AF_AVAILABLE_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        int[] supportedFocusModes = nArray;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        try {
            if (!(supportedFocusModes.length == 0)) {
                builderInputSurface.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                this.applyRequest(builderInputSurface);
                if (ArraysKt.contains((int[])supportedFocusModes, (int)4)) {
                    builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                    this.isAutoFocusEnabled = true;
                } else if (ArraysKt.contains((int[])supportedFocusModes, (int)1)) {
                    builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                    this.isAutoFocusEnabled = true;
                } else {
                    builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)supportedFocusModes[0]);
                    this.isAutoFocusEnabled = false;
                }
                this.applyRequest(builderInputSurface);
            }
            result = this.isAutoFocusEnabled;
        }
        catch (Exception e) {
            this.isAutoFocusEnabled = false;
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
        return result;
    }

    public final boolean disableAutoFocus() {
        boolean result = false;
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AF_AVAILABLE_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        if (nArray == null) {
            return false;
        }
        for (int mode : nArray) {
            try {
                if (mode != 0) continue;
                builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                this.applyRequest(builderInputSurface);
                this.isAutoFocusEnabled = false;
                return true;
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            }
        }
        return result;
    }

    public final boolean enableFaceDetection(@Nullable FaceDetectorCallback faceDetectorCallback) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return false;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return false;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        CameraCharacteristics.Key key = CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SENSOR_INFO_ACTIVE_ARRAY_SIZE");
        this.faceSensorScale = (Rect)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        CameraCharacteristics.Key key2 = CameraCharacteristics.SENSOR_ORIENTATION;
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"SENSOR_ORIENTATION");
        Integer n = (Integer)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key2);
        if (n == null) {
            return false;
        }
        this.sensorOrientation = n;
        CameraCharacteristics.Key key3 = CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES;
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES");
        int[] nArray = (int[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key3);
        if (nArray == null) {
            return false;
        }
        int[] fd = nArray;
        CameraCharacteristics.Key key4 = CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT;
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"STATISTICS_INFO_MAX_FACE_COUNT");
        Integer n2 = (Integer)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key4);
        if (n2 == null) {
            return false;
        }
        int maxFD = n2;
        if (fd.length == 0 || maxFD <= 0) {
            return false;
        }
        this.faceDetectorCallback = faceDetectorCallback;
        this.faceDetectionEnabled = true;
        this.faceDetectionMode = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)ArraysKt.toList((int[])fd)))).intValue();
        if (this.faceDetectionEnabled) {
            builderInputSurface.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.faceDetectionMode);
        }
        this.applyRequest(builderInputSurface);
        return true;
    }

    public final void disableFaceDetection() {
        block1: {
            if (!this.faceDetectionEnabled) break block1;
            this.faceDetectorCallback = null;
            this.faceDetectionEnabled = false;
            this.faceDetectionMode = 0;
            CaptureRequest.Builder builder = this.builderInputSurface;
            if (builder != null) {
                CaptureRequest.Builder it = builder;
                boolean bl = false;
                this.applyRequest(it);
            }
        }
    }

    public final boolean isFaceDetectionEnabled() {
        return this.faceDetectorCallback != null;
    }

    public final void setCameraCallbacks(@Nullable CameraCallbacks cameraCallbacks) {
        this.cameraCallbacks = cameraCallbacks;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void openCameraId(@NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        this.cameraId = cameraId;
        if (this.isPrepared) {
            HandlerThread cameraHandlerThread = new HandlerThread(this.TAG + " Id = " + cameraId);
            cameraHandlerThread.start();
            this.cameraHandler = new Handler(cameraHandlerThread.getLooper());
            try {
                Unit unit;
                this.cameraManager.openCamera(cameraId, (CameraDevice.StateCallback)this, this.cameraHandler);
                this.semaphore.acquireUninterruptibly();
                CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(cameraId);
                Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"getCameraCharacteristics(...)");
                CameraCharacteristics cameraCharacteristics2 = cameraCharacteristics;
                this.isRunning = true;
                CameraCharacteristics.Key key = CameraCharacteristics.LENS_FACING;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LENS_FACING");
                Integer n = (Integer)ExtensionsKt.secureGet((CameraCharacteristics)cameraCharacteristics2, (CameraCharacteristics.Key)key);
                if (n == null) {
                    return;
                }
                int facing = n;
                this.facing = facing == 0 ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
                CameraCallbacks cameraCallbacks = this.cameraCallbacks;
                if (cameraCallbacks != null) {
                    cameraCallbacks.onCameraChanged(this.facing);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Exception e) {
                CameraCallbacks cameraCallbacks = this.cameraCallbacks;
                if (cameraCallbacks != null) {
                    cameraCallbacks.onCameraError("Open camera " + cameraId + " failed");
                }
                Integer n = Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            }
        } else {
            throw new IllegalStateException("You need prepare camera before open it");
        }
    }

    @NotNull
    public final String[] getCamerasAvailable() {
        return this.camerasAvailable;
    }

    public final void switchCamera() {
        try {
            String cameraId = this.cameraDevice == null || this.facing == CameraHelper.Facing.FRONT ? Camera2ApiManager.getCameraIdForFacing$default(this, CameraHelper.Facing.BACK, null, 2, null) : Camera2ApiManager.getCameraIdForFacing$default(this, CameraHelper.Facing.FRONT, null, 2, null);
            this.reOpenCamera(cameraId);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    public final void reOpenCamera(@NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        if (this.cameraDevice != null) {
            this.closeCamera(false);
            this.prepareCamera(this.surfaceEncoder, this.fps);
            this.openCameraId(cameraId);
        }
    }

    @NotNull
    public final Range<Float> getZoomRange() {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        Range zoomRanges = null;
        if (Build.VERSION.SDK_INT >= 30 && this.getLevelSupported() != 2) {
            CameraCharacteristics.Key key = CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_ZOOM_RATIO_RANGE");
            zoomRanges = (Range)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
        }
        if (zoomRanges == null) {
            CameraCharacteristics.Key key = CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SCALER_AVAILABLE_MAX_DIGITAL_ZOOM");
            Float f = (Float)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
            float maxZoom = f != null ? f.floatValue() : 1.0f;
            zoomRanges = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(maxZoom));
        }
        return zoomRanges;
    }

    public final float getZoom() {
        return this.zoomLevel;
    }

    public final void setZoom(float level) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics characteristics = cameraCharacteristics;
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        Comparable comparable = this.getZoomRange().getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getLower(...)");
        float f = ((Number)((Object)comparable)).floatValue();
        Comparable comparable2 = this.getZoomRange().getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getUpper(...)");
        float l = RangesKt.coerceIn((float)level, (float)f, (float)((Number)((Object)comparable2)).floatValue());
        try {
            if (Build.VERSION.SDK_INT >= 30 && this.getLevelSupported() != 2) {
                builderInputSurface.set(CaptureRequest.CONTROL_ZOOM_RATIO, (Object)Float.valueOf(l));
            } else {
                CameraCharacteristics.Key key = CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SENSOR_INFO_ACTIVE_ARRAY_SIZE");
                Rect rect = (Rect)ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
                if (rect == null) {
                    return;
                }
                Rect rect2 = rect;
                float ratio = 1.0f / l;
                int croppedWidth = rect2.width() - Math.round((float)rect2.width() * ratio);
                int croppedHeight = rect2.height() - Math.round((float)rect2.height() * ratio);
                Rect zoom = new Rect(croppedWidth / 2, croppedHeight / 2, rect2.width() - croppedWidth / 2, rect2.height() - croppedHeight / 2);
                builderInputSurface.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoom);
            }
            this.applyRequest(builderInputSurface);
            this.zoomLevel = l;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    @NotNull
    public final Float[] getOpticalZooms() {
        Object[] objectArray;
        block5: {
            block4: {
                CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
                if (cameraCharacteristics == null) {
                    return new Float[0];
                }
                CameraCharacteristics characteristics = cameraCharacteristics;
                CameraCharacteristics.Key key = CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LENS_INFO_AVAILABLE_FOCAL_LENGTHS");
                objectArray = (float[])ExtensionsKt.secureGet((CameraCharacteristics)characteristics, (CameraCharacteristics.Key)key);
                if (objectArray == null) break block4;
                Float[] floatArray = ArraysKt.toTypedArray((float[])objectArray);
                objectArray = floatArray;
                if (floatArray != null) break block5;
            }
            objectArray = new Float[0];
        }
        return objectArray;
    }

    public final void setOpticalZoom(float level) {
        CaptureRequest.Builder builder = this.builderInputSurface;
        if (builder == null) {
            return;
        }
        CaptureRequest.Builder builderInputSurface = builder;
        try {
            builderInputSurface.set(CaptureRequest.LENS_FOCAL_LENGTH, (Object)Float.valueOf(level));
            this.applyRequest(builderInputSurface);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event, float delta) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getPointerCount() < 2 || event.getAction() != 2) {
            return;
        }
        float currentFingerSpacing = CameraHelper.getFingerSpacing(event);
        if (currentFingerSpacing > this.fingerSpacing) {
            this.setZoom(this.getZoom() + delta);
        } else if (currentFingerSpacing < this.fingerSpacing) {
            this.setZoom(this.getZoom() - delta);
        }
        this.fingerSpacing = currentFingerSpacing;
    }

    public static /* synthetic */ void setZoom$default(Camera2ApiManager camera2ApiManager, MotionEvent motionEvent, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.1f;
        }
        camera2ApiManager.setZoom(motionEvent, f);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void closeCamera(boolean resetSurface) {
        this.isLanternEnabled = false;
        this.zoomLevel = 1.0f;
        CameraCaptureSession cameraCaptureSession = this.cameraCaptureSession;
        if (cameraCaptureSession != null) {
            cameraCaptureSession.close();
        }
        this.cameraCaptureSession = null;
        CameraDevice cameraDevice = this.cameraDevice;
        if (cameraDevice != null) {
            cameraDevice.close();
        }
        this.cameraDevice = null;
        Handler handler = this.cameraHandler;
        if (handler != null && (handler = handler.getLooper()) != null) {
            handler.quitSafely();
        }
        this.cameraHandler = null;
        if (resetSurface) {
            void $this$closeCamera_u24lambda_u245;
            SurfaceTexture surfaceTexture;
            SurfaceTexture surfaceTexture2 = surfaceTexture = new SurfaceTexture(-1);
            Camera2ApiManager camera2ApiManager = this;
            boolean bl = false;
            $this$closeCamera_u24lambda_u245.release();
            SurfaceTexture surfaceTexture3 = surfaceTexture;
            camera2ApiManager.surfaceEncoder = new Surface(surfaceTexture3);
            this.builderInputSurface = null;
        }
        this.isPrepared = false;
        this.isRunning = false;
    }

    public static /* synthetic */ void closeCamera$default(Camera2ApiManager camera2ApiManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        camera2ApiManager.closeCamera(bl);
    }

    public final void addImageListener(int width, int height, int format, int maxImages, boolean autoClose, @NotNull ImageCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        boolean wasRunning = this.isRunning;
        this.closeCamera(false);
        ImageReader imageReader = this.imageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        HandlerThread imageThread = new HandlerThread(this.TAG + " imageThread");
        imageThread.start();
        ImageReader imageReader2 = ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages);
        Intrinsics.checkNotNullExpressionValue((Object)imageReader2, (String)"newInstance(...)");
        ImageReader imageReader3 = imageReader2;
        imageReader3.setOnImageAvailableListener(arg_0 -> Camera2ApiManager.addImageListener$lambda$6(listener, autoClose, arg_0), new Handler(imageThread.getLooper()));
        this.imageReader = imageReader3;
        if (wasRunning) {
            this.prepareCamera(this.surfaceEncoder, this.fps);
            this.openLastCamera();
        }
    }

    public final void removeImageListener() {
        ImageReader imageReader = this.imageReader;
        if (imageReader == null) {
            return;
        }
        ImageReader imageReader2 = imageReader;
        boolean wasRunning = this.isRunning;
        if (wasRunning) {
            this.closeCamera(false);
        }
        imageReader2.close();
        this.imageReader = null;
        if (wasRunning) {
            this.prepareCamera(this.surfaceEncoder, this.fps);
            this.openLastCamera();
        }
    }

    public void onOpened(@NotNull CameraDevice cameraDevice) {
        Intrinsics.checkNotNullParameter((Object)cameraDevice, (String)"cameraDevice");
        this.cameraDevice = cameraDevice;
        this.startPreview(cameraDevice);
        this.semaphore.release();
        CameraCallbacks cameraCallbacks = this.cameraCallbacks;
        if (cameraCallbacks != null) {
            cameraCallbacks.onCameraOpened();
        }
        Log.i((String)this.TAG, (String)"Camera opened");
    }

    public void onDisconnected(@NotNull CameraDevice cameraDevice) {
        Intrinsics.checkNotNullParameter((Object)cameraDevice, (String)"cameraDevice");
        cameraDevice.close();
        this.semaphore.release();
        CameraCallbacks cameraCallbacks = this.cameraCallbacks;
        if (cameraCallbacks != null) {
            cameraCallbacks.onCameraDisconnected();
        }
        Log.i((String)this.TAG, (String)"Camera disconnected");
    }

    public void onError(@NotNull CameraDevice cameraDevice, int i) {
        Intrinsics.checkNotNullParameter((Object)cameraDevice, (String)"cameraDevice");
        cameraDevice.close();
        this.semaphore.release();
        CameraCallbacks cameraCallbacks = this.cameraCallbacks;
        if (cameraCallbacks != null) {
            cameraCallbacks.onCameraError("Open camera failed: " + i);
        }
        Log.e((String)this.TAG, (String)("Open failed: " + i));
    }

    @JvmOverloads
    @NotNull
    public final String getCameraIdForFacing(@NotNull CameraHelper.Facing facing, @NotNull CameraManager cameraManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        Intrinsics.checkNotNullParameter((Object)cameraManager, (String)"cameraManager");
        int selectedFacing = facing == CameraHelper.Facing.BACK ? 1 : 0;
        String[] stringArray = cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
        String[] ids = stringArray;
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            String cameraId = ids[i];
            Integer cameraFacing = (Integer)cameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.LENS_FACING);
            if (cameraFacing == null) continue;
            int n2 = selectedFacing;
            if (cameraFacing != n2) continue;
            Intrinsics.checkNotNull((Object)cameraId);
            return cameraId;
        }
        if (ids.length == 0) {
            throw new CameraOpenException("Camera no detected");
        }
        String string = ids[0];
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    public static /* synthetic */ String getCameraIdForFacing$default(Camera2ApiManager camera2ApiManager, CameraHelper.Facing facing, CameraManager cameraManager, int n, Object object) {
        if ((n & 2) != 0) {
            cameraManager = camera2ApiManager.cameraManager;
        }
        return camera2ApiManager.getCameraIdForFacing(facing, cameraManager);
    }

    private final CameraHelper.Facing getFacingByCameraId(CameraManager cameraManager, String cameraId) {
        try {
            for (String id : cameraManager.getCameraIdList()) {
                Integer cameraFacing;
                if (!Intrinsics.areEqual((Object)id, (Object)cameraId)) continue;
                Integer n = cameraFacing = (Integer)cameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.LENS_FACING);
                int n2 = 1;
                return n != null && n == n2 ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT;
            }
            return CameraHelper.Facing.BACK;
        }
        catch (Exception e) {
            return CameraHelper.Facing.BACK;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    private final void createCaptureSession(CameraDevice cameraDevice, List<? extends Surface> surfaces, Function1<? super CameraCaptureSession, Unit> onConfigured, Function1<? super CameraCaptureSession, Unit> onConfiguredFailed, Handler handler) {
        CameraCaptureSession.StateCallback callback2 = new CameraCaptureSession.StateCallback(onConfigured, onConfiguredFailed){
            final /* synthetic */ Function1<CameraCaptureSession, Unit> $onConfigured;
            final /* synthetic */ Function1<CameraCaptureSession, Unit> $onConfiguredFailed;
            {
                this.$onConfigured = $onConfigured;
                this.$onConfiguredFailed = $onConfiguredFailed;
            }

            public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                Intrinsics.checkNotNullParameter((Object)cameraCaptureSession, (String)"cameraCaptureSession");
                this.$onConfigured.invoke((Object)cameraCaptureSession);
            }

            public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                Intrinsics.checkNotNullParameter((Object)cameraCaptureSession, (String)"cameraCaptureSession");
                this.$onConfiguredFailed.invoke((Object)cameraCaptureSession);
            }
        };
        if (Build.VERSION.SDK_INT >= 28) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = surfaces;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Surface surface = (Surface)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new OutputConfiguration((Surface)it));
            }
            List configurations = (List)destination$iv$iv;
            Iterable $this$forEach$iv = configurations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutputConfiguration it = (OutputConfiguration)element$iv;
                boolean bl = false;
                it.setPhysicalCameraId(this.physicalCameraId);
            }
            SessionConfiguration config = new SessionConfiguration(0, configurations, (Executor)Executors.newSingleThreadExecutor(), callback2);
            cameraDevice.createCaptureSession(config);
        } else {
            cameraDevice.createCaptureSession(surfaces, callback2, handler);
        }
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Camera2ApiManager.setZoom$default(this, event, 0.0f, 2, null);
    }

    @JvmOverloads
    public final void closeCamera() {
        Camera2ApiManager.closeCamera$default(this, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final String getCameraIdForFacing(@NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
        return Camera2ApiManager.getCameraIdForFacing$default(this, facing, null, 2, null);
    }

    private static final Unit startPreview$lambda$2(Camera2ApiManager this$0, CaptureRequest $captureRequest, CameraCaptureSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cameraCaptureSession = it;
        try {
            it.setRepeatingRequest($captureRequest, this$0.faceDetectionEnabled ? this$0.cb : null, this$0.cameraHandler);
        }
        catch (IllegalStateException e) {
            this$0.reOpenCamera(this$0.cameraId);
        }
        catch (Exception e) {
            CameraCallbacks cameraCallbacks = this$0.cameraCallbacks;
            if (cameraCallbacks != null) {
                cameraCallbacks.onCameraError("Create capture session failed: " + e.getMessage());
            }
            Log.e((String)this$0.TAG, (String)"Error", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit startPreview$lambda$3(Camera2ApiManager this$0, CameraCaptureSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.close();
        CameraCallbacks cameraCallbacks = this$0.cameraCallbacks;
        if (cameraCallbacks != null) {
            cameraCallbacks.onCameraError("Configuration failed");
        }
        Log.e((String)this$0.TAG, (String)"Configuration failed");
        return Unit.INSTANCE;
    }

    private static final void addImageListener$lambda$6(ImageCallback $listener, boolean $autoClose, ImageReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Image image = reader.acquireLatestImage();
        if (image != null) {
            $listener.onImageAvailable(image);
            if ($autoClose) {
                image.close();
            }
        }
    }

    public static final /* synthetic */ FaceDetectorCallback access$getFaceDetectorCallback$p(Camera2ApiManager $this) {
        return $this.faceDetectorCallback;
    }

    public static final /* synthetic */ Rect access$getFaceSensorScale$p(Camera2ApiManager $this) {
        return $this.faceSensorScale;
    }

    public static final /* synthetic */ int access$getSensorOrientation$p(Camera2ApiManager $this) {
        return $this.sensorOrientation;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/pedro/encoder/input/video/Camera2ApiManager$ImageCallback;", "", "onImageAvailable", "", "image", "Landroid/media/Image;", "encoder_release"})
    public static interface ImageCallback {
        public void onImageAvailable(@NotNull Image var1);
    }
}

