/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.pedro.common.TimeUtils;
import com.pedro.encoder.input.decoder.AndroidExtractor;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.Extractor;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseDecoder {
    protected String TAG = "BaseDecoder";
    protected MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    protected MediaCodec codec;
    protected volatile boolean running = false;
    protected MediaFormat mediaFormat;
    private ExecutorService executor;
    protected String mime = "";
    protected boolean loopMode = false;
    private volatile long startTs = 0L;
    protected long duration;
    protected final Object sync = new Object();
    protected AtomicBoolean pause = new AtomicBoolean(false);
    protected volatile boolean looped = false;
    private final DecoderInterface decoderInterface;
    private Extractor extractor = new AndroidExtractor();

    public BaseDecoder(DecoderInterface decoderInterface2) {
        this.decoderInterface = decoderInterface2;
    }

    public boolean initExtractor(String filePath) throws IOException {
        this.extractor.initialize(filePath);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(FileDescriptor fileDescriptor) throws IOException {
        this.extractor.initialize(fileDescriptor);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(Context context, Uri uri) throws IOException {
        this.extractor.initialize(context, uri);
        return this.extract(this.extractor);
    }

    public void start() {
        Log.i((String)this.TAG, (String)"start decoder");
        this.running = true;
        this.codec.start();
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute(() -> {
            try {
                this.decode();
            }
            catch (IllegalStateException e) {
                Log.i((String)this.TAG, (String)"Decoding error", (Throwable)e);
            }
            catch (NullPointerException e) {
                Log.i((String)this.TAG, (String)"Decoder maybe was stopped");
                Log.i((String)this.TAG, (String)"Decoding error", (Throwable)e);
            }
        });
    }

    public void stop() {
        Log.i((String)this.TAG, (String)"stop decoder");
        this.running = false;
        this.stopDecoder();
        this.startTs = 0L;
        this.extractor.release();
    }

    public void reset(Surface surface) {
        boolean wasRunning = this.running;
        this.stopDecoder(!wasRunning);
        this.moveTo(0.0);
        this.prepare(surface);
        if (wasRunning) {
            this.start();
        }
    }

    protected boolean prepare(Surface surface) {
        try {
            this.codec = MediaCodec.createDecoderByType((String)this.mime);
            this.codec.configure(this.mediaFormat, surface, null, 0);
            return true;
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"Prepare decoder error:", (Throwable)e);
            return false;
        }
    }

    protected void resetCodec(Surface surface) {
        boolean wasRunning = this.running;
        this.stopDecoder(!wasRunning);
        this.prepare(surface);
        if (wasRunning) {
            this.start();
        }
    }

    protected void stopDecoder() {
        this.stopDecoder(true);
    }

    protected void stopDecoder(boolean clearTs) {
        this.running = false;
        if (clearTs) {
            this.startTs = 0L;
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
            if (this.codec != null) {
                try {
                    this.codec.flush();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        try {
            this.codec.stop();
            this.codec.release();
            this.codec = null;
        }
        catch (IllegalStateException | NullPointerException e) {
            this.codec = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(double time) {
        Object object = this.sync;
        synchronized (object) {
            this.extractor.seekTo((long)(time * 1000000.0));
        }
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
    }

    public boolean isLoopMode() {
        return this.loopMode;
    }

    public double getDuration() {
        if (this.duration < 0L) {
            return this.duration;
        }
        return (double)this.duration / 1000000.0;
    }

    public double getTime() {
        if (this.running) {
            return (double)this.extractor.getTimeStamp() / 1000000.0;
        }
        return 0.0;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected abstract boolean extract(Extractor var1) throws IOException;

    protected abstract boolean decodeOutput(ByteBuffer var1, long var2);

    protected abstract void finished();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() {
        if (this.startTs == 0L) {
            this.moveTo(0.0);
            this.startTs = TimeUtils.getCurrentTimeMicro();
        }
        long sleepTime = 0L;
        while (this.running) {
            Object object = this.sync;
            synchronized (object) {
                int outIndex;
                if (this.pause.get()) {
                    continue;
                }
                if (this.looped) {
                    this.decoderInterface.onLoop();
                    this.looped = false;
                }
                int inIndex = this.codec.dequeueInputBuffer(10000L);
                long timeStamp = TimeUtils.getCurrentTimeMicro();
                boolean finished = false;
                if (inIndex >= 0) {
                    ByteBuffer input = Build.VERSION.SDK_INT >= 21 ? this.codec.getInputBuffer(inIndex) : this.codec.getInputBuffers()[inIndex];
                    if (input == null) {
                        continue;
                    }
                    int sampleSize = this.extractor.readFrame(input);
                    long ts = TimeUtils.getCurrentTimeMicro() - this.startTs;
                    sleepTime = this.extractor.getSleepTime(ts);
                    boolean bl = finished = !this.extractor.advance();
                    if (finished) {
                        if (!this.loopMode) {
                            this.codec.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                        }
                    } else {
                        this.codec.queueInputBuffer(inIndex, 0, sampleSize, ts + sleepTime, 0);
                    }
                }
                if ((outIndex = this.codec.dequeueOutputBuffer(this.bufferInfo, 10000L)) >= 0) {
                    if (!this.sleep(sleepTime)) {
                        return;
                    }
                    ByteBuffer output = Build.VERSION.SDK_INT >= 21 ? this.codec.getOutputBuffer(outIndex) : this.codec.getOutputBuffers()[outIndex];
                    boolean render = this.decodeOutput(output, timeStamp);
                    this.codec.releaseOutputBuffer(outIndex, render && this.bufferInfo.size != 0);
                    if (finished) {
                        if (this.loopMode) {
                            this.looped = true;
                        } else {
                            Log.i((String)this.TAG, (String)"end of file");
                            this.finished();
                        }
                    }
                }
            }
        }
    }

    private boolean sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void setExtractor(Extractor extractor) {
        this.extractor = extractor;
    }

    public Extractor getExtractor() {
        return this.extractor;
    }
}

