/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters.object;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.filters.object.BaseObjectFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;

@RequiresApi(api=18)
public class SurfaceFilterRender
extends BaseObjectFilterRender {
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private final SurfaceReadyCallback surfaceReadyCallback;

    public SurfaceFilterRender() {
        this(null);
    }

    public SurfaceFilterRender(SurfaceReadyCallback surfaceReadyCallback) {
        this.surfaceReadyCallback = surfaceReadyCallback;
    }

    @Override
    protected void initGlFilter(Context context) {
        this.fragment = R.raw.surface_fragment;
        super.initGlFilter(context);
        GlUtil.createExternalTextures(this.streamObjectTextureId.length, this.streamObjectTextureId, 0);
        this.surfaceTexture = new SurfaceTexture(this.streamObjectTextureId[0]);
        this.surfaceTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
        this.surface = new Surface(this.surfaceTexture);
        if (this.surfaceReadyCallback != null) {
            new Handler(Looper.getMainLooper()).post(() -> this.surfaceReadyCallback.surfaceReady(this.surfaceTexture));
        }
    }

    @Override
    protected void drawFilter() {
        this.surfaceTexture.updateTexImage();
        super.drawFilter();
        GLES20.glBindTexture((int)36197, (int)this.streamObjectTextureId[0]);
        GLES20.glUniform1f((int)this.uAlphaHandle, (float)(this.streamObjectTextureId[0] == -1 ? 0.0f : this.alpha));
    }

    @Override
    public void release() {
        super.release();
        this.surfaceTexture.release();
        this.surface.release();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public static interface SurfaceReadyCallback {
        public void surfaceReady(SurfaceTexture var1);
    }
}

