/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.camera2.params.Face;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.utils.FaceParsed;

public class FaceDetectorUtil {
    @RequiresApi(api=21)
    public static FaceParsed camera2Parse(Face face, Rect scaleSensor, int sensorOrientation, int rotation, CameraHelper.Facing facing) {
        return FaceDetectorUtil.cameraParse(face.getBounds(), scaleSensor, sensorOrientation, rotation, facing, 100.0f);
    }

    public static FaceParsed camera1Parse(Camera.Face face, Rect scaleSensor, int sensorOrientation, int rotation, CameraHelper.Facing facing) {
        return FaceDetectorUtil.cameraParse(face.rect, scaleSensor, sensorOrientation, rotation, facing, 50.0f);
    }

    private static FaceParsed cameraParse(Rect face, Rect scaleSensor, int sensorOrientation, int streamRotation, CameraHelper.Facing facing, float translate) {
        Matrix matrix = new Matrix();
        matrix.setScale(facing == CameraHelper.Facing.FRONT ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)streamRotation);
        float s1 = 100.0f / (float)scaleSensor.width();
        float s2 = 100.0f / (float)scaleSensor.height();
        if (sensorOrientation == 90 || sensorOrientation == 270) {
            matrix.postScale(s2, s1);
        } else {
            matrix.postScale(s1, s2);
        }
        matrix.postTranslate(translate, translate);
        Rect uRect = new Rect(face);
        RectF rectF = new RectF(uRect);
        matrix.mapRect(rectF);
        uRect = new Rect((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
        PointF positionParsed = new PointF((float)uRect.centerX() - (float)uRect.width() / 2.0f, (float)uRect.centerY() - (float)uRect.height() / 2.0f);
        PointF sizeParsed = new PointF((float)uRect.width(), (float)uRect.height());
        return new FaceParsed(positionParsed, sizeParsed);
    }
}

