/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaDataSource;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.DecoderInterface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseDecoder {
    protected String TAG = "BaseDecoder";
    protected MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    protected MediaExtractor extractor;
    protected MediaCodec codec;
    protected volatile boolean running = false;
    protected MediaFormat mediaFormat;
    private HandlerThread handlerThread;
    protected String mime = "";
    protected boolean loopMode = false;
    private volatile long startTs = 0L;
    protected long duration;
    protected final Object sync = new Object();
    private volatile long lastExtractorTs = 0L;
    protected AtomicBoolean pause = new AtomicBoolean(false);
    protected volatile boolean looped = false;
    private final DecoderInterface decoderInterface;

    public BaseDecoder(DecoderInterface decoderInterface) {
        this.decoderInterface = decoderInterface;
    }

    public boolean initExtractor(String filePath) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(filePath);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(FileDescriptor fileDescriptor) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(fileDescriptor);
        return this.extract(this.extractor);
    }

    @RequiresApi(api=24)
    public boolean initExtractor(AssetFileDescriptor assetFileDescriptor) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(assetFileDescriptor);
        return this.extract(this.extractor);
    }

    @RequiresApi(api=23)
    public boolean initExtractor(MediaDataSource mediaDataSource) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(mediaDataSource);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(String filePath, Map<String, String> headers) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(filePath, headers);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(FileDescriptor fileDescriptor, long offset, long length) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(fileDescriptor, offset, length);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(Context context, Uri uri, Map<String, String> headers) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(context, uri, headers);
        return this.extract(this.extractor);
    }

    public void start() {
        Log.i((String)this.TAG, (String)"start decoder");
        this.running = true;
        this.handlerThread = new HandlerThread(this.TAG);
        this.handlerThread.start();
        Handler handler = new Handler(this.handlerThread.getLooper());
        this.codec.start();
        handler.post(() -> {
            try {
                this.decode();
            }
            catch (IllegalStateException e) {
                Log.i((String)this.TAG, (String)"Decoding error", (Throwable)e);
            }
            catch (NullPointerException e) {
                Log.i((String)this.TAG, (String)"Decoder maybe was stopped");
                Log.i((String)this.TAG, (String)"Decoding error", (Throwable)e);
            }
        });
    }

    public void stop() {
        Log.i((String)this.TAG, (String)"stop decoder");
        this.running = false;
        this.stopDecoder();
        this.lastExtractorTs = 0L;
        this.startTs = 0L;
        if (this.extractor != null) {
            this.extractor.release();
            this.extractor = null;
            this.mime = "";
        }
    }

    protected boolean prepare(Surface surface) {
        try {
            this.codec = MediaCodec.createDecoderByType((String)this.mime);
            this.codec.configure(this.mediaFormat, surface, null, 0);
            return true;
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"Prepare decoder error:", (Throwable)e);
            return false;
        }
    }

    protected void resetCodec(Surface surface) {
        boolean wasRunning = this.running;
        this.stopDecoder(!wasRunning);
        this.prepare(surface);
        if (wasRunning) {
            this.start();
        }
    }

    protected void stopDecoder() {
        this.stopDecoder(true);
    }

    protected void stopDecoder(boolean clearTs) {
        this.running = false;
        if (clearTs) {
            this.startTs = 0L;
        }
        if (this.handlerThread != null) {
            if (this.handlerThread.getLooper() != null) {
                if (this.handlerThread.getLooper().getThread() != null) {
                    this.handlerThread.getLooper().getThread().interrupt();
                }
                this.handlerThread.getLooper().quit();
            }
            this.handlerThread.quit();
            if (this.codec != null) {
                try {
                    this.codec.flush();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            try {
                this.handlerThread.getLooper().getThread().join(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handlerThread = null;
        }
        try {
            this.codec.stop();
            this.codec.release();
            this.codec = null;
        }
        catch (IllegalStateException | NullPointerException e) {
            this.codec = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(double time) {
        Object object = this.sync;
        synchronized (object) {
            this.extractor.seekTo((long)(time * 1000000.0), 0);
            this.lastExtractorTs = this.extractor.getSampleTime();
        }
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
    }

    public boolean isLoopMode() {
        return this.loopMode;
    }

    public double getDuration() {
        return (double)this.duration / 1000000.0;
    }

    public double getTime() {
        if (this.running) {
            return (double)this.extractor.getSampleTime() / 1000000.0;
        }
        return 0.0;
    }

    protected abstract boolean extract(MediaExtractor var1);

    protected abstract boolean decodeOutput(ByteBuffer var1, long var2);

    protected abstract void finished();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() {
        if (this.startTs == 0L) {
            this.moveTo(0.0);
            this.startTs = System.nanoTime() / 1000L;
        }
        long sleepTime = 0L;
        long accumulativeTs = 0L;
        while (this.running) {
            Object object = this.sync;
            synchronized (object) {
                int outIndex;
                if (this.pause.get()) {
                    continue;
                }
                if (this.looped) {
                    double time = this.getTime();
                    if (time > 0.0) {
                        this.moveTo(0.0);
                        continue;
                    }
                    this.decoderInterface.onLoop();
                    this.looped = false;
                }
                int inIndex = this.codec.dequeueInputBuffer(10000L);
                long timeStamp = System.nanoTime() / 1000L;
                if (inIndex >= 0) {
                    ByteBuffer input = Build.VERSION.SDK_INT >= 21 ? this.codec.getInputBuffer(inIndex) : this.codec.getInputBuffers()[inIndex];
                    if (input == null) {
                        continue;
                    }
                    int sampleSize = this.extractor.readSampleData(input, 0);
                    long ts = System.nanoTime() / 1000L - this.startTs;
                    long extractorTs = this.extractor.getSampleTime();
                    this.lastExtractorTs = this.extractor.getSampleTime();
                    sleepTime = (accumulativeTs += extractorTs - this.lastExtractorTs) > ts ? (accumulativeTs - ts) / 1000L : 0L;
                    if (sampleSize < 0) {
                        if (!this.loopMode) {
                            this.codec.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                        }
                    } else {
                        this.codec.queueInputBuffer(inIndex, 0, sampleSize, ts + sleepTime, 0);
                        this.extractor.advance();
                    }
                }
                if ((outIndex = this.codec.dequeueOutputBuffer(this.bufferInfo, 10000L)) >= 0) {
                    boolean finished;
                    if (!this.sleep(sleepTime)) {
                        return;
                    }
                    ByteBuffer output = Build.VERSION.SDK_INT >= 21 ? this.codec.getOutputBuffer(outIndex) : this.codec.getOutputBuffers()[outIndex];
                    boolean render = this.decodeOutput(output, timeStamp);
                    this.codec.releaseOutputBuffer(outIndex, render && this.bufferInfo.size != 0);
                    boolean bl = finished = this.extractor.getSampleTime() < 0L;
                    if (finished) {
                        if (this.loopMode) {
                            this.moveTo(0.0);
                            this.looped = true;
                        } else {
                            Log.i((String)this.TAG, (String)"end of file");
                            this.finished();
                        }
                    }
                }
            }
        }
    }

    private boolean sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

