/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class GlUtil {
    private static final String TAG = "GlUtil";

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GlUtil.checkGlError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + shaderType + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = GlUtil.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = GlUtil.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GlUtil.checkGlError("glCreateProgram");
        if (program == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        return program;
    }

    public static void createTextures(int quantity, int[] texturesId, int offset) {
        GLES20.glGenTextures((int)quantity, (int[])texturesId, (int)offset);
        for (int i = offset; i < quantity; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)texturesId[i]);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
    }

    public static void createExternalTextures(int quantity, int[] texturesId, int offset) {
        GLES20.glGenTextures((int)quantity, (int[])texturesId, (int)offset);
        for (int i = offset; i < quantity; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)36197, (int)texturesId[i]);
            GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        }
    }

    public static String getStringFromRaw(Context context, int id) {
        String str;
        try {
            Resources r = context.getResources();
            InputStream is = r.openRawResource(id);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = is.read();
            while (i != -1) {
                baos.write(i);
                i = is.read();
            }
            str = baos.toString();
            is.close();
        }
        catch (IOException e) {
            str = "";
        }
        return str;
    }

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new RuntimeException(op + ". GL error: " + error);
        }
    }

    public static void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ". EGL error: " + error);
        }
    }

    public static Bitmap getBitmap(int streamWidth, int streamHeight) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(streamWidth * streamHeight * 4);
        GLES20.glReadPixels((int)0, (int)0, (int)streamWidth, (int)streamHeight, (int)6408, (int)5121, (Buffer)buffer);
        Bitmap bitmap = Bitmap.createBitmap((int)streamWidth, (int)streamHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)buffer);
        return GlUtil.flipVerticalBitmap(bitmap, streamWidth, streamHeight);
    }

    private static Bitmap flipVerticalBitmap(Bitmap bitmap, int width, int height) {
        float cx = (float)width / 2.0f;
        float cy = (float)height / 2.0f;
        Matrix matrix = new Matrix();
        matrix.postScale(1.0f, -1.0f, cx, cy);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }
}

